/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.objects.ForeignClassNode;
import org.truffleruby.language.objects.ImmutableClassNode;
import org.truffleruby.language.objects.MetaClassNodeGen;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
public abstract class MetaClassNode
extends RubyBaseNode {
    @NeverDefault
    public static MetaClassNode create() {
        return MetaClassNodeGen.create();
    }

    public static RubyClass executeUncached(Object value) {
        return MetaClassNodeGen.getUncached().execute(null, value);
    }

    public final RubyClass executeCached(Object value) {
        return this.execute(this, value);
    }

    public abstract RubyClass execute(Node var1, Object var2);

    @Specialization(guards={"isSingleContext()", "object == cachedObject", "metaClass.isSingleton", "!isRubyIO(cachedObject)"}, limit="1")
    static RubyClass singleton(Node node, RubyDynamicObject object, @Cached(value="object") RubyDynamicObject cachedObject, @Cached(value="object.getMetaClass()") RubyClass metaClass) {
        return metaClass;
    }

    @Specialization(replaces={"singleton"})
    static RubyClass object(RubyDynamicObject object) {
        return object.getMetaClass();
    }

    @Specialization(guards={"isPrimitiveOrImmutable(value)"})
    static RubyClass immutable(Node node, Object value, @Cached ImmutableClassNode immutableClassNode) {
        return immutableClassNode.execute(node, value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObject(object)"})
    static RubyClass foreign(Node node, Object object, @Cached ForeignClassNode foreignClassNode) {
        return foreignClassNode.execute(node, object);
    }

    protected int getCacheLimit() {
        return this.getLanguage().options.CLASS_CACHE;
    }
}

