/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.RubyContextSourceAssignableNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.locals.ReadFrameSlotNode;
import org.truffleruby.language.objects.IsFrozenNode;
import org.truffleruby.language.objects.IsFrozenNodeGen;
import org.truffleruby.language.objects.SelfNode;
import org.truffleruby.language.objects.WriteInstanceVariableNodeGen;
import org.truffleruby.language.objects.WriteObjectFieldNode;
import org.truffleruby.language.objects.WriteObjectFieldNodeGen;

public abstract class WriteInstanceVariableNode
extends RubyContextSourceAssignableNode {
    private final String name;
    @Node.Child
    private ReadFrameSlotNode readSelfSlotNode;
    @Node.Child
    private IsFrozenNode isFrozenNode;
    @Node.Child
    private RubyNode rhs;
    @Node.Child
    private WriteObjectFieldNode writeNode;
    @CompilerDirectives.CompilationFinal
    private boolean frozenProfile;

    @Override
    public abstract Object execute(VirtualFrame var1);

    public WriteInstanceVariableNode(String name, RubyNode rhs) {
        this.name = name;
        this.readSelfSlotNode = SelfNode.createReadSelfFrameSlotNode();
        this.rhs = rhs;
    }

    @Specialization
    Object doWrite(VirtualFrame frame) {
        Object self = SelfNode.readSelf(frame, this.readSelfSlotNode);
        Object value = this.rhs.execute(frame);
        this.write(self, value);
        return value;
    }

    @Override
    public void assign(VirtualFrame frame, Object value) {
        Object self = SelfNode.readSelf(frame, this.readSelfSlotNode);
        this.write(self, value);
    }

    private void write(Object object, Object value) {
        if (this.getIsFrozenNode().execute(object)) {
            if (!this.frozenProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.frozenProfile = true;
            }
            throw new RaiseException(this.getContext(), this.coreExceptions().frozenError(object, this));
        }
        if (this.writeNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.writeNode = (WriteObjectFieldNode)this.insert(WriteObjectFieldNodeGen.create());
        }
        this.writeNode.execute(this, (RubyDynamicObject)((Object)object), this.name, value);
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        return FrozenStrings.ASSIGNMENT;
    }

    private IsFrozenNode getIsFrozenNode() {
        if (this.isFrozenNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeGen.create());
        }
        return this.isFrozenNode;
    }

    @Override
    public AssignableNode toAssignableNode() {
        this.rhs = null;
        return this;
    }

    @Override
    public AssignableNode cloneUninitializedAssignable() {
        return (AssignableNode)((Object)this.cloneUninitialized());
    }

    @Override
    public RubyNode cloneUninitialized() {
        WriteInstanceVariableNode copy = WriteInstanceVariableNodeGen.create(this.name, WriteInstanceVariableNode.cloneUninitialized(this.rhs));
        return copy.copyFlags(this);
    }
}

