/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects.classvariables;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.parser.Identifiers;

@ImportStatic(value={Identifiers.class})
@GenerateInline
@GenerateCached(value=false)
@ReportPolymorphism
public abstract class CheckClassVariableNameNode
extends RubyBaseNode {
    public abstract void execute(Node var1, RubyDynamicObject var2, String var3);

    @Specialization(guards={"name == cachedName", "isValidClassVariableName(cachedName)"}, limit="getDefaultCacheLimit()")
    static void cached(RubyDynamicObject object, String name, @Cached(value="name") String cachedName) {
    }

    @Specialization(replaces={"cached"})
    static void uncached(Node node, RubyDynamicObject object, String name, @Cached InlinedBranchProfile errorProfile) {
        if (!Identifiers.isValidClassVariableName(name)) {
            errorProfile.enter(node);
            throw new RaiseException(CheckClassVariableNameNode.getContext(node), (RubyException)CheckClassVariableNameNode.coreExceptions(node).nameErrorInstanceNameNotAllowable(name, (Object)object, node));
        }
    }
}

