/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.prism.AbstractNodeVisitor;
import org.prism.Nodes;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.DummyNode;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.SequenceNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;
import org.truffleruby.language.literal.BooleanLiteralNode;
import org.truffleruby.language.literal.NilLiteralNode;
import org.truffleruby.parser.ParseEnvironment;
import org.truffleruby.parser.RubySource;
import org.truffleruby.parser.TranslatorEnvironment;

public abstract class YARPBaseTranslator
extends AbstractNodeVisitor<RubyNode> {
    protected final TranslatorEnvironment environment;
    protected final ParseEnvironment parseEnvironment;
    protected final RubyLanguage language;
    protected final RubySource rubySource;
    protected final Source source;
    protected final RubyEncoding sourceEncoding;
    protected final Node currentNode;
    public static final Nodes.Node[] EMPTY_NODE_ARRAY = Nodes.Node.EMPTY_ARRAY;
    public static final Nodes.OptionalParameterNode[] EMPTY_OPTIONAL_PARAMETER_NODE_ARRAY = new Nodes.OptionalParameterNode[0];
    public static final Nodes.BlockLocalVariableNode[] EMPTY_BLOCK_LOCAL_VARIABLE_NODE_ARRAY = new Nodes.BlockLocalVariableNode[0];
    public static final Nodes.ParametersNode ZERO_PARAMETERS_NODE = new Nodes.ParametersNode(0, 0, EMPTY_NODE_ARRAY, EMPTY_OPTIONAL_PARAMETER_NODE_ARRAY, null, EMPTY_NODE_ARRAY, EMPTY_NODE_ARRAY, null, null);
    public static final short NO_FLAGS = 0;

    public YARPBaseTranslator(TranslatorEnvironment environment) {
        this.environment = Objects.requireNonNull(environment);
        this.parseEnvironment = environment.getParseEnvironment();
        this.language = this.parseEnvironment.language;
        this.rubySource = this.parseEnvironment.rubySource;
        this.source = this.rubySource.getSource();
        this.sourceEncoding = this.rubySource.getEncoding();
        this.currentNode = this.parseEnvironment.currentNode;
    }

    public final TranslatorEnvironment getEnvironment() {
        return this.environment;
    }

    protected RuntimeException fail(Nodes.Node node) {
        RubyContext context = RubyLanguage.getCurrentContext();
        String code = this.toString(node);
        String message = this.getClass().getSimpleName() + " does not know how to translate " + node.getClass().getSimpleName() + " at " + context.fileLine(this.getSourceSection(node)) + "\nCode snippet:\n" + code + "\nPrism AST:\n" + String.valueOf(node);
        throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxError(message, null, this.getSourceSection(node)));
    }

    @Override
    protected RubyNode defaultVisit(Nodes.Node node) {
        throw this.fail(node);
    }

    protected static RubyNode[] createArray(int size) {
        return size == 0 ? RubyNode.EMPTY_ARRAY : new RubyNode[size];
    }

    protected final RubyNode translateNodeOrNil(Nodes.Node node) {
        RubyNode rubyNode = node == null ? new NilLiteralNode() : node.accept(this);
        return rubyNode;
    }

    protected final RubyNode translateNodeOrTrue(Nodes.Node node) {
        RubyNode rubyNode = node == null ? new BooleanLiteralNode(true) : node.accept(this);
        return rubyNode;
    }

    protected final RubyContextSourceNode createCallNode(RubyNode receiver, String method, RubyNode ... arguments) {
        return this.createCallNode(true, receiver, method, arguments);
    }

    protected final RubyContextSourceNode createCallNode(boolean ignoreVisibility, RubyNode receiver, String method, RubyNode ... arguments) {
        RubyCallNodeParameters parameters = new RubyCallNodeParameters(receiver, method, null, NoKeywordArgumentsDescriptor.INSTANCE, arguments, ignoreVisibility);
        return this.language.coreMethodAssumptions.createCallNode(parameters);
    }

    protected static Nodes.CallNode callNode(Nodes.Node location, Nodes.Node receiver, String methodName, Nodes.Node ... arguments) {
        return YARPBaseTranslator.callNode(location, (short)0, receiver, methodName, arguments);
    }

    protected static Nodes.CallNode callNode(Nodes.Node location, short flags, Nodes.Node receiver, String methodName, Nodes.Node ... arguments) {
        return new Nodes.CallNode(location.startOffset, location.length, flags, receiver, methodName, new Nodes.ArgumentsNode(location.startOffset, location.length, 0, arguments), null);
    }

    protected final TruffleString toTString(Nodes.Node node) {
        return TruffleString.fromByteArrayUncached((byte[])this.rubySource.getBytes(), (int)node.startOffset, (int)node.length, (TruffleString.Encoding)this.sourceEncoding.tencoding, (boolean)false);
    }

    protected final TruffleString toTString(String string) {
        return TStringUtils.fromJavaString(string, this.sourceEncoding);
    }

    protected final String toString(Nodes.Node node) {
        return TStringUtils.toJavaStringOrThrow((AbstractTruffleString)this.toTString(node), this.sourceEncoding);
    }

    protected final TruffleString toTString(byte[] bytes) {
        return TruffleString.fromByteArrayUncached((byte[])bytes, (TruffleString.Encoding)this.sourceEncoding.tencoding, (boolean)false);
    }

    protected final String toString(byte[] bytes) {
        return TStringUtils.toJavaStringOrThrow((AbstractTruffleString)this.toTString(bytes), this.sourceEncoding);
    }

    protected final SourceSection getSourceSection(Nodes.Node yarpNode) {
        if (yarpNode.length == 0 && yarpNode.startOffset == 0) {
            return this.source.createUnavailableSection();
        }
        return this.source.createSection(yarpNode.startOffset, yarpNode.length);
    }

    public final RubyNode assignPositionAndFlags(Nodes.Node yarpNode, RubyNode rubyNode) {
        YARPBaseTranslator.assignPositionOnly(yarpNode, rubyNode);
        this.copyNewlineFlag(yarpNode, rubyNode);
        return rubyNode;
    }

    public final RubyNode assignPositionAndFlagsIfMissing(Nodes.Node yarpNode, RubyNode rubyNode) {
        if (rubyNode.hasSource()) {
            return rubyNode;
        }
        YARPBaseTranslator.assignPositionOnly(yarpNode, rubyNode);
        this.copyNewlineFlag(yarpNode, rubyNode);
        return rubyNode;
    }

    protected static void assignPositionOnly(Nodes.Node yarpNode, RubyNode rubyNode) {
        if (yarpNode.length != 0 || yarpNode.startOffset != 0) {
            rubyNode.unsafeSetSourceSection(yarpNode.startOffset, yarpNode.length);
        }
    }

    protected final void assignPositionOnly(Nodes.Node[] nodes, RubyNode rubyNode) {
        Nodes.Node first = nodes[0];
        Nodes.Node last = ArrayUtils.getLast(nodes);
        int length = last.endOffset() - first.startOffset;
        assert (length > 0) : length;
        rubyNode.unsafeSetSourceSection(first.startOffset, length);
    }

    protected final void copyNewlineFlag(Nodes.Node yarpNode, RubyNode rubyNode) {
        if (yarpNode.hasNewLineFlag()) {
            TruffleSafepoint.poll((Node)DummyNode.INSTANCE);
            if (this.parseEnvironment.isCoverageEnabled()) {
                rubyNode.unsafeSetIsCoverageLine();
                int startLine = this.parseEnvironment.yarpSource.line(yarpNode.startOffset);
                this.language.coverageManager.setLineHasCode(this.source, startLine);
            }
            rubyNode.unsafeSetIsNewLine();
        }
    }

    protected void copyNewLineFlag(Nodes.Node source, Nodes.Node target) {
        target.setNewLineFlag(source.hasNewLineFlag());
    }

    protected static RubyNode sequence(Nodes.Node yarpNode, RubyNode ... sequence) {
        assert (!yarpNode.hasNewLineFlag()) : "Expected node passed to sequence() to not have a newline flag";
        RubyNode sequenceNode = YARPBaseTranslator.sequence(sequence);
        if (!sequenceNode.hasSource()) {
            YARPBaseTranslator.assignPositionOnly(yarpNode, sequenceNode);
        }
        return sequenceNode;
    }

    protected static RubyNode sequence(RubyNode ... sequence) {
        List<RubyNode> flattened = YARPBaseTranslator.flatten(sequence);
        if (flattened.isEmpty()) {
            return new NilLiteralNode();
        }
        if (flattened.size() == 1) {
            return flattened.get(0);
        }
        RubyNode[] flatSequence = flattened.toArray(RubyNode.EMPTY_ARRAY);
        return new SequenceNode(flatSequence);
    }

    private static List<RubyNode> flatten(RubyNode[] sequence) {
        return YARPBaseTranslator.flattenFromN(sequence, 0);
    }

    private static List<RubyNode> flattenFromN(RubyNode[] sequence, int n) {
        ArrayList<RubyNode> flattened = new ArrayList<RubyNode>();
        while (n < sequence.length) {
            boolean lastNode = n == sequence.length - 1;
            RubyNode node = sequence[n];
            if (node != null) {
                if (node instanceof SequenceNode) {
                    flattened.addAll(YARPBaseTranslator.flatten(((SequenceNode)node).getSequence()));
                } else {
                    if (node.canSubsumeFollowing() && !lastNode) {
                        List<RubyNode> rest = YARPBaseTranslator.flattenFromN(sequence, n + 1);
                        if (rest.size() == 1) {
                            flattened.add(node.subsumeFollowing(rest.get(0)));
                        } else {
                            flattened.add(node.subsumeFollowing(new SequenceNode(rest.toArray(RubyNode.EMPTY_ARRAY))));
                        }
                        return flattened;
                    }
                    flattened.add(node);
                }
            }
            ++n;
        }
        return flattened;
    }

    protected final RubyNode[] translate(Nodes.Node[] nodes) {
        if (nodes.length == 0) {
            return RubyNode.EMPTY_ARRAY;
        }
        RubyNode[] rubyNodes = new RubyNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            rubyNodes[i] = nodes[i].accept(this);
        }
        return rubyNodes;
    }
}

