/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.List;
import org.prism.AbstractNodeVisitor;
import org.prism.Nodes;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.core.array.MultipleAssignmentNode;
import org.truffleruby.core.array.NoopAssignableNode;
import org.truffleruby.core.cast.SplatCastNode;
import org.truffleruby.core.cast.SplatCastNodeGen;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.literal.NilLiteralNode;
import org.truffleruby.language.locals.ReadLocalNode;
import org.truffleruby.language.locals.WriteLocalNode;
import org.truffleruby.parser.YARPExecutedOnceExpression;
import org.truffleruby.parser.YARPTranslator;

public final class YARPMultiTargetNodeTranslator
extends AbstractNodeVisitor<AssignableNode> {
    private final Nodes.MultiTargetNode node;
    private final RubyLanguage language;
    private final YARPTranslator yarpTranslator;
    private final RubyNode readNode;
    public final List<RubyNode> prolog;

    public YARPMultiTargetNodeTranslator(Nodes.MultiTargetNode node, RubyLanguage language, YARPTranslator yarpTranslator, RubyNode readNode) {
        this.node = node;
        this.language = language;
        this.yarpTranslator = yarpTranslator;
        this.readNode = readNode;
        this.prolog = new ArrayList<RubyNode>();
    }

    public MultipleAssignmentNode translate() {
        RubyNode rhsNode = this.readNode == null ? new NilLiteralNode() : this.readNode;
        SplatCastNode splatCastNode = SplatCastNodeGen.create(this.language, SplatCastNode.NilBehavior.ARRAY_WITH_NIL, true, null);
        AssignableNode[] preNodes = this.processAssignables(this.node.lefts);
        AssignableNode restNode = this.node.rest != null ? (this.node.rest instanceof Nodes.ImplicitRestNode ? null : this.node.rest.accept(this)) : null;
        AssignableNode[] postNodes = this.processAssignables(this.node.rights);
        MultipleAssignmentNode multipleAssignmentNode = new MultipleAssignmentNode(null, preNodes, restNode, postNodes, splatCastNode, rhsNode);
        return multipleAssignmentNode;
    }

    private AssignableNode[] processAssignables(Nodes.Node[] nodes) {
        if (nodes.length == 0) {
            return AssignableNode.EMPTY_ARRAY;
        }
        AssignableNode[] assignables = new AssignableNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            assignables[i] = nodes[i].accept(this);
        }
        return assignables;
    }

    @Override
    public AssignableNode visitClassVariableTargetNode(Nodes.ClassVariableTargetNode node) {
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitCallTargetNode(Nodes.CallTargetNode node) {
        Nodes.Node readReceiver = this.stash(node.receiver, "receiver");
        node = new Nodes.CallTargetNode(node.startOffset, node.length, node.flags, readReceiver, node.name);
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitConstantPathTargetNode(Nodes.ConstantPathTargetNode node) {
        if (node.parent != null) {
            Nodes.Node readParent = this.stash(node.parent, "parent");
            node = new Nodes.ConstantPathTargetNode(node.startOffset, node.length, readParent, node.name);
        }
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitConstantTargetNode(Nodes.ConstantTargetNode node) {
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitGlobalVariableTargetNode(Nodes.GlobalVariableTargetNode node) {
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitImplicitRestNode(Nodes.ImplicitRestNode node) {
        throw CompilerDirectives.shouldNotReachHere((String)"handled in #translate");
    }

    @Override
    public AssignableNode visitIndexTargetNode(Nodes.IndexTargetNode node) {
        Nodes.ArgumentsNode arguments;
        Nodes.Node readReceiver = this.stash(node.receiver, "receiver");
        if (node.arguments != null) {
            Nodes.Node[] argumentsReads = new Nodes.Node[node.arguments.arguments.length];
            for (int i = 0; i < node.arguments.arguments.length; ++i) {
                argumentsReads[i] = this.stash(node.arguments.arguments[i], "argument");
            }
            arguments = new Nodes.ArgumentsNode(node.arguments.startOffset, node.arguments.length, node.arguments.flags, argumentsReads);
        } else {
            arguments = null;
        }
        node = new Nodes.IndexTargetNode(node.startOffset, node.length, node.flags, readReceiver, arguments, node.block);
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitInstanceVariableTargetNode(Nodes.InstanceVariableTargetNode node) {
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitLocalVariableTargetNode(Nodes.LocalVariableTargetNode node) {
        RubyNode rubyNode = node.accept(this.yarpTranslator);
        return ((AssignableNode)((Object)rubyNode)).toAssignableNode();
    }

    @Override
    public AssignableNode visitMultiTargetNode(Nodes.MultiTargetNode node) {
        YARPMultiTargetNodeTranslator translator = new YARPMultiTargetNodeTranslator(node, this.language, this.yarpTranslator, null);
        MultipleAssignmentNode multipleAssignmentNode = translator.translate();
        this.prolog.addAll(translator.prolog);
        return multipleAssignmentNode.toAssignableNode();
    }

    @Override
    public AssignableNode visitSplatNode(Nodes.SplatNode node) {
        if (node.expression != null) {
            return node.expression.accept(this);
        }
        return new NoopAssignableNode();
    }

    @Override
    public AssignableNode visitRequiredParameterNode(Nodes.RequiredParameterNode node) {
        String name = node.name;
        ReadLocalNode lhs = this.yarpTranslator.getEnvironment().findLocalVarNode(name);
        WriteLocalNode rubyNode = lhs.makeWriteNode(null);
        return rubyNode.toAssignableNode();
    }

    @Override
    protected AssignableNode defaultVisit(Nodes.Node node) {
        throw new Error("Unknown node: " + String.valueOf(node));
    }

    Nodes.Node stash(Nodes.Node node, String name) {
        YARPExecutedOnceExpression e = new YARPExecutedOnceExpression(name, node, this.yarpTranslator);
        RubyNode writeNode = e.getWriteNode();
        if (writeNode != null) {
            this.prolog.add(writeNode);
        }
        return e.getReadYARPNode();
    }
}

