/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.platform;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import org.truffleruby.RubyContext;
import org.truffleruby.interop.TranslateInteropExceptionNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.platform.NativeConfiguration;

public final class TruffleNFIPlatform {
    final Object defaultLibrary;
    private final String size_t;
    private final Object strlen;
    private final Object strnlen;

    public TruffleNFIPlatform(RubyContext context) {
        this.defaultLibrary = context.getEnv().parseInternal(Source.newBuilder((String)"nfi", (CharSequence)"default", (String)"native").build(), new String[0]).call(new Object[0]);
        this.size_t = this.resolveType(context.getNativeConfiguration(), "size_t");
        this.strlen = this.getFunction(context, "strlen", String.format("(pointer):%s", this.size_t));
        this.strnlen = this.getFunction(context, "strnlen", String.format("(pointer,%s):%s", this.size_t, this.size_t));
    }

    public Object getDefaultLibrary() {
        return this.defaultLibrary;
    }

    public Object lookup(Object library, String name) {
        try {
            return ((InteropLibrary)InteropLibrary.getFactory().getUncached(library)).readMember(library, name);
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            throw TranslateInteropExceptionNode.executeUncached((InteropException)e);
        }
    }

    public static Object bind(RubyContext context, Object function, String signature) {
        Object parsedSignature = context.getEnv().parseInternal(Source.newBuilder((String)"nfi", (CharSequence)signature, (String)"native").build(), new String[0]).call(new Object[0]);
        return SignatureLibrary.getUncached().bind(parsedSignature, function);
    }

    public long asPointer(Object object) {
        try {
            return ((InteropLibrary)InteropLibrary.getFactory().getUncached(object)).asPointer(object);
        }
        catch (UnsupportedMessageException e) {
            throw TranslateInteropExceptionNode.executeUncached((InteropException)((Object)e));
        }
    }

    public Object resolveTypeRaw(NativeConfiguration nativeConfiguration, String type) {
        Object typedef = nativeConfiguration.get("platform.typedef." + type);
        if (typedef == null) {
            throw CompilerDirectives.shouldNotReachHere((String)("Type " + type + " is not defined in the native configuration"));
        }
        return typedef;
    }

    public String resolveType(NativeConfiguration nativeConfiguration, String type) {
        Object typedef = this.resolveTypeRaw(nativeConfiguration, type);
        return this.toNFIType(RubyGuards.getJavaString(typedef));
    }

    private String toNFIType(String type) {
        switch (type) {
            case "uint": {
                return "uint32";
            }
            case "ulong": {
                return "uint64";
            }
        }
        return type;
    }

    public Object getFunction(RubyContext context, String functionName, String signature) {
        Object symbol = this.lookup(this.defaultLibrary, functionName);
        return TruffleNFIPlatform.bind(context, symbol, signature);
    }

    public String size_t() {
        return this.size_t;
    }

    public Object getStrlen() {
        return this.strlen;
    }

    public Object getStrnlen() {
        return this.strnlen;
    }
}

