/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.stdlib;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Set;
import org.truffleruby.Layouts;
import org.truffleruby.RubyContext;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.regexp.MatchDataNodes;
import org.truffleruby.core.regexp.RubyMatchData;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.parser.RubySource;

@CoreModule(value="Truffle::ObjSpace")
public abstract class ObjSpaceNodes {
    @CompilerDirectives.TruffleBoundary
    private static AllocationTracing.AllocationTrace getAllocationTrace(RubyContext context, RubyDynamicObject object) {
        AllocationTracing.AllocationTrace trace = (AllocationTracing.AllocationTrace)DynamicObjectLibrary.getUncached().getOrDefault((DynamicObject)object, (Object)Layouts.ALLOCATION_TRACE_IDENTIFIER, null);
        if (trace != null && trace.tracingGeneration == context.getObjectSpaceManager().getTracingGeneration()) {
            return trace;
        }
        return null;
    }

    @Primitive(name="allocation_sourceline")
    public static abstract class AllocationSourceLineNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object allocationInfo(RubyDynamicObject object) {
            AllocationTracing.AllocationTrace trace = ObjSpaceNodes.getAllocationTrace(this.getContext(), object);
            if (trace == null) {
                return nil;
            }
            return RubySource.getStartLineAdjusted(this.getContext(), trace.allocatingSourceSection);
        }

        @Fallback
        Object allocationSourcelineImmutable(Object object) {
            return nil;
        }
    }

    @Primitive(name="allocation_sourcefile")
    public static abstract class AllocationSourceFileNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object allocationInfo(RubyDynamicObject object, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            AllocationTracing.AllocationTrace trace = ObjSpaceNodes.getAllocationTrace(this.getContext(), object);
            if (trace == null) {
                return nil;
            }
            String sourcePath = this.getLanguage().getSourcePath(trace.allocatingSourceSection.getSource());
            return this.createString(fromJavaStringNode, sourcePath, Encodings.UTF_8);
        }

        @Fallback
        Object allocationSourcefileImmutable(Object object) {
            return nil;
        }
    }

    @Primitive(name="allocation_method_id")
    public static abstract class AllocationMethodIDNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object allocationInfo(RubyDynamicObject object) {
            AllocationTracing.AllocationTrace trace = ObjSpaceNodes.getAllocationTrace(this.getContext(), object);
            if (trace == null) {
                return nil;
            }
            String allocatingMethod = trace.allocatingMethod;
            if (SharedMethodInfo.isModuleBody(allocatingMethod)) {
                return nil;
            }
            if (allocatingMethod.equals("__allocate__")) {
                return this.getLanguage().coreSymbols.NEW;
            }
            return this.getLanguage().getSymbol(allocatingMethod);
        }

        @Fallback
        Object allocationMethodIdImmutable(Object object) {
            return nil;
        }
    }

    @Primitive(name="allocation_generation")
    public static abstract class AllocationGenerationNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object allocationInfo(RubyDynamicObject object) {
            AllocationTracing.AllocationTrace trace = ObjSpaceNodes.getAllocationTrace(this.getContext(), object);
            if (trace == null) {
                return nil;
            }
            return trace.gcGeneration;
        }

        @Fallback
        Object allocationGenerationImmutable(Object object) {
            return nil;
        }
    }

    @Primitive(name="allocation_class_path")
    public static abstract class AllocationClassPathNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object allocationInfo(RubyDynamicObject object, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            AllocationTracing.AllocationTrace trace = ObjSpaceNodes.getAllocationTrace(this.getContext(), object);
            if (trace == null) {
                return nil;
            }
            String className = trace.className;
            if (className.isEmpty()) {
                return nil;
            }
            return this.createString(fromJavaStringNode, className, Encodings.UTF_8);
        }

        @Fallback
        Object allocationInfoImmutable(Object object) {
            return nil;
        }
    }

    @CoreMethod(names={"trace_allocations_clear"}, onSingleton=true)
    public static abstract class TraceAllocationsClearNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object traceAllocationsClear() {
            this.getContext().getObjectSpaceManager().traceAllocationsClear();
            return nil;
        }
    }

    @CoreMethod(names={"trace_allocations_stop"}, onSingleton=true)
    public static abstract class TraceAllocationsStopNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object traceAllocationsStop() {
            this.getContext().getObjectSpaceManager().traceAllocationsStop(this.getLanguage());
            return nil;
        }
    }

    @CoreMethod(names={"trace_allocations_start"}, onSingleton=true)
    public static abstract class TraceAllocationsStartNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object traceAllocationsStart() {
            this.getContext().getObjectSpaceManager().traceAllocationsStart(this.getLanguage());
            return nil;
        }
    }

    @CoreMethod(names={"root_objects"}, onSingleton=true)
    public static abstract class RootObjectsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray rootObjects() {
            Set<Object> objects = ObjectGraph.stopAndGetRootObjects("ObjectSpace.reachable_objects_from_root", this.getContext(), this);
            return this.createArray(objects.toArray());
        }
    }

    @CoreMethod(names={"adjacent_objects"}, onSingleton=true, required=1)
    public static abstract class AdjacentObjectsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray adjacentObjects(RubyDynamicObject object) {
            Set<Object> objects = ObjectGraph.getAdjacentObjects(object);
            return this.createArray(objects.toArray());
        }

        @Fallback
        Object adjacentObjectsPrimitive(Object object) {
            return nil;
        }
    }

    @CoreMethod(names={"memsize_of"}, onSingleton=true, required=1)
    public static abstract class MemsizeOfNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int memsizeOfArray(RubyArray object) {
            return this.memsizeOfObject(object) + object.size;
        }

        @Specialization
        int memsizeOfHash(RubyHash object) {
            return this.memsizeOfObject(object) + object.size;
        }

        @Specialization
        int memsizeOfString(RubyString object, @Cached @Cached.Exclusive RubyStringLibrary libString) {
            return this.memsizeOfObject(object) + libString.byteLength(this, (Object)object);
        }

        @Specialization
        int memsizeOfString(ImmutableRubyString object, @Cached @Cached.Exclusive RubyStringLibrary libString) {
            return 1 + libString.byteLength(this, object);
        }

        @Specialization
        int memsizeOfMatchData(RubyMatchData object, @Cached @Cached.Exclusive MatchDataNodes.ValuesNode matchDataValues) {
            return this.memsizeOfObject(object) + matchDataValues.execute(object).length;
        }

        @Specialization(guards={"!isRubyArray(object)", "!isRubyHash(object)", "isNotRubyString(object)", "!isRubyMatchData(object)"})
        int memsizeOfObject(RubyDynamicObject object) {
            return 1 + object.getShape().getPropertyCount();
        }

        @Specialization(guards={"!isRubyDynamicObject(object)"})
        int memsize(Object object) {
            return 0;
        }
    }
}

