/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.stdlib.readline;

import com.oracle.truffle.api.CompilerDirectives;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.graalvm.shadowed.org.jline.builtins.Completers;
import org.graalvm.shadowed.org.jline.reader.Completer;
import org.graalvm.shadowed.org.jline.reader.History;
import org.graalvm.shadowed.org.jline.reader.LineReader;
import org.graalvm.shadowed.org.jline.reader.Parser;
import org.graalvm.shadowed.org.jline.reader.impl.LineReaderImpl;
import org.graalvm.shadowed.org.jline.terminal.Size;
import org.graalvm.shadowed.org.jline.terminal.Terminal;
import org.graalvm.shadowed.org.jline.terminal.impl.DumbTerminal;
import org.graalvm.shadowed.org.jline.terminal.impl.exec.ExecPty;
import org.graalvm.shadowed.org.jline.terminal.impl.exec.ExecTerminalProvider;
import org.graalvm.shadowed.org.jline.terminal.spi.SystemStream;
import org.graalvm.shadowed.org.jline.terminal.spi.TerminalProvider;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.support.RubyIO;
import org.truffleruby.stdlib.readline.IoStream;
import org.truffleruby.stdlib.readline.IsTTYHelper;
import org.truffleruby.stdlib.readline.MemoryHistory;
import org.truffleruby.stdlib.readline.ParserWithCustomDelimiters;
import org.truffleruby.stdlib.readline.PosixSysTerminalKeepSignalHandlers;
import org.truffleruby.stdlib.readline.SingleThreadTerminal;

public final class ConsoleHolder {
    private static final boolean DEBUG_JLINE = false;
    private final RubyContext context;
    private final RubyLanguage language;
    private final LineReaderImpl readline;
    private final IoStream in;
    private final IoStream out;

    public static ConsoleHolder create(RubyContext context, RubyLanguage language) {
        RubyIO stdin = (RubyIO)((Object)context.getCoreLibrary().getStdin());
        return new ConsoleHolder(context, language, 0, stdin, 1, null, (Completer)new Completers.FileNameCompleter(), new MemoryHistory(), new ParserWithCustomDelimiters());
    }

    @CompilerDirectives.TruffleBoundary
    private ConsoleHolder(RubyContext context, RubyLanguage language, int inFd, RubyIO inIo, int outFd, RubyIO outIo, Completer completer, MemoryHistory history, ParserWithCustomDelimiters parser) {
        Object terminal;
        boolean system;
        block9: {
            this.context = context;
            this.language = language;
            this.in = new IoStream(context, language, inFd, inIo);
            this.out = new IoStream(context, language, outFd, outIo);
            system = IsTTYHelper.isTTY() && inFd == 0 && outFd == 1;
            try {
                if (system) {
                    terminal = new PosixSysTerminalKeepSignalHandlers("TruffleRuby", this.getType(), ExecPty.current((TerminalProvider)new ExecTerminalProvider(), (SystemStream)SystemStream.Output), StandardCharsets.UTF_8);
                    break block9;
                }
                try (DumbTerminal inherit = new DumbTerminal((InputStream)this.in.getIn(), this.out.getOut());){
                    terminal = new SingleThreadTerminal("TruffleRuby", this.getType(), this.in.getIn(), this.out.getOut(), StandardCharsets.UTF_8, inherit.getAttributes(), new Size(160, 50));
                }
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Couldn't initialize readline", e);
            }
        }
        this.readline = new LineReaderImpl((Terminal)terminal, null, null);
        this.readline.setHistory((History)history);
        this.readline.setParser((Parser)parser);
        this.readline.setCompleter(completer);
        this.readline.option(LineReader.Option.DISABLE_EVENT_EXPANSION, true);
        this.readline.option(LineReader.Option.HISTORY_BEEP, true);
        if (!system) {
            this.readline.option(LineReader.Option.BRACKETED_PASTE, false);
        }
    }

    private String getType() {
        String type = System.getProperty("org.jline.terminal.type");
        if (type == null) {
            type = System.getenv("TERM");
        }
        return type;
    }

    public void close() {
        try {
            Terminal terminal = this.readline.getTerminal();
            if (terminal instanceof PosixSysTerminalKeepSignalHandlers) {
                ((PosixSysTerminalKeepSignalHandlers)terminal).customClose();
            } else {
                terminal.close();
            }
        }
        catch (IOException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    public LineReader getReadline() {
        return this.readline;
    }

    public MemoryHistory getHistory() {
        return (MemoryHistory)this.readline.getHistory();
    }

    public ParserWithCustomDelimiters getParser() {
        return (ParserWithCustomDelimiters)this.readline.getParser();
    }

    public void setCompleter(Completer completer) {
        this.readline.setCompleter(completer);
    }

    public ConsoleHolder updateIn(int fd, RubyIO io) {
        if (fd == this.in.getFd()) {
            return this;
        }
        return new ConsoleHolder(this.context, this.language, fd, io, this.out.getFd(), this.out.getIo(), this.readline.getCompleter(), this.getHistory(), this.getParser());
    }

    public ConsoleHolder updateOut(int fd, RubyIO io) {
        if (fd == this.out.getFd()) {
            return this;
        }
        return new ConsoleHolder(this.context, this.language, this.in.getFd(), this.in.getIo(), fd, io, this.readline.getCompleter(), this.getHistory(), this.getParser());
    }
}

