# frozen_string_literal: true

=begin
This file is generated by the templates/template.rb script and should not be
modified manually. See templates/lib/prism/dot_visitor.rb.erb
if you are looking to modify the template
=end

require "cgi"

module Prism
  # This visitor provides the ability to call Node#to_dot, which converts a
  # subtree into a graphviz dot graph.
  class DotVisitor < Visitor
    class Field # :nodoc:
      attr_reader :name, :value, :port

      def initialize(name, value, port)
        @name = name
        @value = value
        @port = port
      end

      def to_dot
        if port
          "<tr><td align=\"left\" colspan=\"2\" port=\"#{name}\">#{name}</td></tr>"
        else
          "<tr><td align=\"left\">#{name}</td><td>#{CGI.escapeHTML(value || raise)}</td></tr>"
        end
      end
    end

    class Table # :nodoc:
      attr_reader :name, :fields

      def initialize(name)
        @name = name
        @fields = []
      end

      def field(name, value = nil, port: false)
        fields << Field.new(name, value, port)
      end

      def to_dot
        dot = <<~DOT
          <table border="0" cellborder="1" cellspacing="0" cellpadding="4">
            <tr><td colspan="2"><b>#{name}</b></td></tr>
        DOT

        if fields.any?
          "#{dot}  #{fields.map(&:to_dot).join("\n  ")}\n</table>"
        else
          "#{dot}</table>"
        end
      end
    end

    class Digraph # :nodoc:
      attr_reader :nodes, :waypoints, :edges

      def initialize
        @nodes = []
        @waypoints = []
        @edges = []
      end

      def node(value)
        nodes << value
      end

      def waypoint(value)
        waypoints << value
      end

      def edge(value)
        edges << value
      end

      def to_dot
        <<~DOT
          digraph "Prism" {
            node [
              fontname=\"Courier New\"
              shape=plain
              style=filled
              fillcolor=gray95
            ];

            #{nodes.map { |node| node.gsub(/\n/, "\n  ") }.join("\n  ")}
            node [shape=point];
            #{waypoints.join("\n  ")}

            #{edges.join("\n  ")}
          }
        DOT
      end
    end

    private_constant :Field, :Table, :Digraph

    # The digraph that is being built.
    attr_reader :digraph

    # Initialize a new dot visitor.
    def initialize
      @digraph = Digraph.new
    end

    # Convert this visitor into a graphviz dot graph string.
    def to_dot
      digraph.to_dot
    end

    # Visit a AliasGlobalVariableNode node.
    def visit_alias_global_variable_node(node)
      table = Table.new("AliasGlobalVariableNode")
      id = node_id(node)

      # new_name
      table.field("new_name", port: true)
      digraph.edge("#{id}:new_name -> #{node_id(node.new_name)};")

      # old_name
      table.field("old_name", port: true)
      digraph.edge("#{id}:old_name -> #{node_id(node.old_name)};")

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a AliasMethodNode node.
    def visit_alias_method_node(node)
      table = Table.new("AliasMethodNode")
      id = node_id(node)

      # new_name
      table.field("new_name", port: true)
      digraph.edge("#{id}:new_name -> #{node_id(node.new_name)};")

      # old_name
      table.field("old_name", port: true)
      digraph.edge("#{id}:old_name -> #{node_id(node.old_name)};")

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a AlternationPatternNode node.
    def visit_alternation_pattern_node(node)
      table = Table.new("AlternationPatternNode")
      id = node_id(node)

      # left
      table.field("left", port: true)
      digraph.edge("#{id}:left -> #{node_id(node.left)};")

      # right
      table.field("right", port: true)
      digraph.edge("#{id}:right -> #{node_id(node.right)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a AndNode node.
    def visit_and_node(node)
      table = Table.new("AndNode")
      id = node_id(node)

      # left
      table.field("left", port: true)
      digraph.edge("#{id}:left -> #{node_id(node.left)};")

      # right
      table.field("right", port: true)
      digraph.edge("#{id}:right -> #{node_id(node.right)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ArgumentsNode node.
    def visit_arguments_node(node)
      table = Table.new("ArgumentsNode")
      id = node_id(node)

      # flags
      table.field("flags", arguments_node_flags_inspect(node))

      # arguments
      if node.arguments.any?
        table.field("arguments", port: true)

        waypoint = "#{id}_arguments"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:arguments -> #{waypoint};")
        node.arguments.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("arguments", "[]")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ArrayNode node.
    def visit_array_node(node)
      table = Table.new("ArrayNode")
      id = node_id(node)

      # flags
      table.field("flags", array_node_flags_inspect(node))

      # elements
      if node.elements.any?
        table.field("elements", port: true)

        waypoint = "#{id}_elements"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:elements -> #{waypoint};")
        node.elements.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("elements", "[]")
      end

      # opening_loc
      unless (opening_loc = node.opening_loc).nil?
        table.field("opening_loc", location_inspect(opening_loc))
      end

      # closing_loc
      unless (closing_loc = node.closing_loc).nil?
        table.field("closing_loc", location_inspect(closing_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ArrayPatternNode node.
    def visit_array_pattern_node(node)
      table = Table.new("ArrayPatternNode")
      id = node_id(node)

      # constant
      unless (constant = node.constant).nil?
        table.field("constant", port: true)
        digraph.edge("#{id}:constant -> #{node_id(constant)};")
      end

      # requireds
      if node.requireds.any?
        table.field("requireds", port: true)

        waypoint = "#{id}_requireds"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:requireds -> #{waypoint};")
        node.requireds.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("requireds", "[]")
      end

      # rest
      unless (rest = node.rest).nil?
        table.field("rest", port: true)
        digraph.edge("#{id}:rest -> #{node_id(rest)};")
      end

      # posts
      if node.posts.any?
        table.field("posts", port: true)

        waypoint = "#{id}_posts"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:posts -> #{waypoint};")
        node.posts.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("posts", "[]")
      end

      # opening_loc
      unless (opening_loc = node.opening_loc).nil?
        table.field("opening_loc", location_inspect(opening_loc))
      end

      # closing_loc
      unless (closing_loc = node.closing_loc).nil?
        table.field("closing_loc", location_inspect(closing_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a AssocNode node.
    def visit_assoc_node(node)
      table = Table.new("AssocNode")
      id = node_id(node)

      # key
      table.field("key", port: true)
      digraph.edge("#{id}:key -> #{node_id(node.key)};")

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # operator_loc
      unless (operator_loc = node.operator_loc).nil?
        table.field("operator_loc", location_inspect(operator_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a AssocSplatNode node.
    def visit_assoc_splat_node(node)
      table = Table.new("AssocSplatNode")
      id = node_id(node)

      # value
      unless (value = node.value).nil?
        table.field("value", port: true)
        digraph.edge("#{id}:value -> #{node_id(value)};")
      end

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a BackReferenceReadNode node.
    def visit_back_reference_read_node(node)
      table = Table.new("BackReferenceReadNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a BeginNode node.
    def visit_begin_node(node)
      table = Table.new("BeginNode")
      id = node_id(node)

      # begin_keyword_loc
      unless (begin_keyword_loc = node.begin_keyword_loc).nil?
        table.field("begin_keyword_loc", location_inspect(begin_keyword_loc))
      end

      # statements
      unless (statements = node.statements).nil?
        table.field("statements", port: true)
        digraph.edge("#{id}:statements -> #{node_id(statements)};")
      end

      # rescue_clause
      unless (rescue_clause = node.rescue_clause).nil?
        table.field("rescue_clause", port: true)
        digraph.edge("#{id}:rescue_clause -> #{node_id(rescue_clause)};")
      end

      # else_clause
      unless (else_clause = node.else_clause).nil?
        table.field("else_clause", port: true)
        digraph.edge("#{id}:else_clause -> #{node_id(else_clause)};")
      end

      # ensure_clause
      unless (ensure_clause = node.ensure_clause).nil?
        table.field("ensure_clause", port: true)
        digraph.edge("#{id}:ensure_clause -> #{node_id(ensure_clause)};")
      end

      # end_keyword_loc
      unless (end_keyword_loc = node.end_keyword_loc).nil?
        table.field("end_keyword_loc", location_inspect(end_keyword_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a BlockArgumentNode node.
    def visit_block_argument_node(node)
      table = Table.new("BlockArgumentNode")
      id = node_id(node)

      # expression
      unless (expression = node.expression).nil?
        table.field("expression", port: true)
        digraph.edge("#{id}:expression -> #{node_id(expression)};")
      end

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a BlockLocalVariableNode node.
    def visit_block_local_variable_node(node)
      table = Table.new("BlockLocalVariableNode")
      id = node_id(node)

      # flags
      table.field("flags", parameter_flags_inspect(node))

      # name
      table.field("name", node.name.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a BlockNode node.
    def visit_block_node(node)
      table = Table.new("BlockNode")
      id = node_id(node)

      # locals
      table.field("locals", node.locals.inspect)

      # parameters
      unless (parameters = node.parameters).nil?
        table.field("parameters", port: true)
        digraph.edge("#{id}:parameters -> #{node_id(parameters)};")
      end

      # body
      unless (body = node.body).nil?
        table.field("body", port: true)
        digraph.edge("#{id}:body -> #{node_id(body)};")
      end

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a BlockParameterNode node.
    def visit_block_parameter_node(node)
      table = Table.new("BlockParameterNode")
      id = node_id(node)

      # flags
      table.field("flags", parameter_flags_inspect(node))

      # name
      table.field("name", node.name.inspect)

      # name_loc
      unless (name_loc = node.name_loc).nil?
        table.field("name_loc", location_inspect(name_loc))
      end

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a BlockParametersNode node.
    def visit_block_parameters_node(node)
      table = Table.new("BlockParametersNode")
      id = node_id(node)

      # parameters
      unless (parameters = node.parameters).nil?
        table.field("parameters", port: true)
        digraph.edge("#{id}:parameters -> #{node_id(parameters)};")
      end

      # locals
      if node.locals.any?
        table.field("locals", port: true)

        waypoint = "#{id}_locals"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:locals -> #{waypoint};")
        node.locals.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("locals", "[]")
      end

      # opening_loc
      unless (opening_loc = node.opening_loc).nil?
        table.field("opening_loc", location_inspect(opening_loc))
      end

      # closing_loc
      unless (closing_loc = node.closing_loc).nil?
        table.field("closing_loc", location_inspect(closing_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a BreakNode node.
    def visit_break_node(node)
      table = Table.new("BreakNode")
      id = node_id(node)

      # arguments
      unless (arguments = node.arguments).nil?
        table.field("arguments", port: true)
        digraph.edge("#{id}:arguments -> #{node_id(arguments)};")
      end

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a CallAndWriteNode node.
    def visit_call_and_write_node(node)
      table = Table.new("CallAndWriteNode")
      id = node_id(node)

      # flags
      table.field("flags", call_node_flags_inspect(node))

      # receiver
      unless (receiver = node.receiver).nil?
        table.field("receiver", port: true)
        digraph.edge("#{id}:receiver -> #{node_id(receiver)};")
      end

      # call_operator_loc
      unless (call_operator_loc = node.call_operator_loc).nil?
        table.field("call_operator_loc", location_inspect(call_operator_loc))
      end

      # message_loc
      unless (message_loc = node.message_loc).nil?
        table.field("message_loc", location_inspect(message_loc))
      end

      # read_name
      table.field("read_name", node.read_name.inspect)

      # write_name
      table.field("write_name", node.write_name.inspect)

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a CallNode node.
    def visit_call_node(node)
      table = Table.new("CallNode")
      id = node_id(node)

      # flags
      table.field("flags", call_node_flags_inspect(node))

      # receiver
      unless (receiver = node.receiver).nil?
        table.field("receiver", port: true)
        digraph.edge("#{id}:receiver -> #{node_id(receiver)};")
      end

      # call_operator_loc
      unless (call_operator_loc = node.call_operator_loc).nil?
        table.field("call_operator_loc", location_inspect(call_operator_loc))
      end

      # name
      table.field("name", node.name.inspect)

      # message_loc
      unless (message_loc = node.message_loc).nil?
        table.field("message_loc", location_inspect(message_loc))
      end

      # opening_loc
      unless (opening_loc = node.opening_loc).nil?
        table.field("opening_loc", location_inspect(opening_loc))
      end

      # arguments
      unless (arguments = node.arguments).nil?
        table.field("arguments", port: true)
        digraph.edge("#{id}:arguments -> #{node_id(arguments)};")
      end

      # closing_loc
      unless (closing_loc = node.closing_loc).nil?
        table.field("closing_loc", location_inspect(closing_loc))
      end

      # block
      unless (block = node.block).nil?
        table.field("block", port: true)
        digraph.edge("#{id}:block -> #{node_id(block)};")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a CallOperatorWriteNode node.
    def visit_call_operator_write_node(node)
      table = Table.new("CallOperatorWriteNode")
      id = node_id(node)

      # flags
      table.field("flags", call_node_flags_inspect(node))

      # receiver
      unless (receiver = node.receiver).nil?
        table.field("receiver", port: true)
        digraph.edge("#{id}:receiver -> #{node_id(receiver)};")
      end

      # call_operator_loc
      unless (call_operator_loc = node.call_operator_loc).nil?
        table.field("call_operator_loc", location_inspect(call_operator_loc))
      end

      # message_loc
      unless (message_loc = node.message_loc).nil?
        table.field("message_loc", location_inspect(message_loc))
      end

      # read_name
      table.field("read_name", node.read_name.inspect)

      # write_name
      table.field("write_name", node.write_name.inspect)

      # binary_operator
      table.field("binary_operator", node.binary_operator.inspect)

      # binary_operator_loc
      table.field("binary_operator_loc", location_inspect(node.binary_operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a CallOrWriteNode node.
    def visit_call_or_write_node(node)
      table = Table.new("CallOrWriteNode")
      id = node_id(node)

      # flags
      table.field("flags", call_node_flags_inspect(node))

      # receiver
      unless (receiver = node.receiver).nil?
        table.field("receiver", port: true)
        digraph.edge("#{id}:receiver -> #{node_id(receiver)};")
      end

      # call_operator_loc
      unless (call_operator_loc = node.call_operator_loc).nil?
        table.field("call_operator_loc", location_inspect(call_operator_loc))
      end

      # message_loc
      unless (message_loc = node.message_loc).nil?
        table.field("message_loc", location_inspect(message_loc))
      end

      # read_name
      table.field("read_name", node.read_name.inspect)

      # write_name
      table.field("write_name", node.write_name.inspect)

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a CallTargetNode node.
    def visit_call_target_node(node)
      table = Table.new("CallTargetNode")
      id = node_id(node)

      # flags
      table.field("flags", call_node_flags_inspect(node))

      # receiver
      table.field("receiver", port: true)
      digraph.edge("#{id}:receiver -> #{node_id(node.receiver)};")

      # call_operator_loc
      table.field("call_operator_loc", location_inspect(node.call_operator_loc))

      # name
      table.field("name", node.name.inspect)

      # message_loc
      table.field("message_loc", location_inspect(node.message_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a CapturePatternNode node.
    def visit_capture_pattern_node(node)
      table = Table.new("CapturePatternNode")
      id = node_id(node)

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # target
      table.field("target", port: true)
      digraph.edge("#{id}:target -> #{node_id(node.target)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a CaseMatchNode node.
    def visit_case_match_node(node)
      table = Table.new("CaseMatchNode")
      id = node_id(node)

      # predicate
      unless (predicate = node.predicate).nil?
        table.field("predicate", port: true)
        digraph.edge("#{id}:predicate -> #{node_id(predicate)};")
      end

      # conditions
      if node.conditions.any?
        table.field("conditions", port: true)

        waypoint = "#{id}_conditions"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:conditions -> #{waypoint};")
        node.conditions.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("conditions", "[]")
      end

      # else_clause
      unless (else_clause = node.else_clause).nil?
        table.field("else_clause", port: true)
        digraph.edge("#{id}:else_clause -> #{node_id(else_clause)};")
      end

      # case_keyword_loc
      table.field("case_keyword_loc", location_inspect(node.case_keyword_loc))

      # end_keyword_loc
      table.field("end_keyword_loc", location_inspect(node.end_keyword_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a CaseNode node.
    def visit_case_node(node)
      table = Table.new("CaseNode")
      id = node_id(node)

      # predicate
      unless (predicate = node.predicate).nil?
        table.field("predicate", port: true)
        digraph.edge("#{id}:predicate -> #{node_id(predicate)};")
      end

      # conditions
      if node.conditions.any?
        table.field("conditions", port: true)

        waypoint = "#{id}_conditions"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:conditions -> #{waypoint};")
        node.conditions.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("conditions", "[]")
      end

      # else_clause
      unless (else_clause = node.else_clause).nil?
        table.field("else_clause", port: true)
        digraph.edge("#{id}:else_clause -> #{node_id(else_clause)};")
      end

      # case_keyword_loc
      table.field("case_keyword_loc", location_inspect(node.case_keyword_loc))

      # end_keyword_loc
      table.field("end_keyword_loc", location_inspect(node.end_keyword_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ClassNode node.
    def visit_class_node(node)
      table = Table.new("ClassNode")
      id = node_id(node)

      # locals
      table.field("locals", node.locals.inspect)

      # class_keyword_loc
      table.field("class_keyword_loc", location_inspect(node.class_keyword_loc))

      # constant_path
      table.field("constant_path", port: true)
      digraph.edge("#{id}:constant_path -> #{node_id(node.constant_path)};")

      # inheritance_operator_loc
      unless (inheritance_operator_loc = node.inheritance_operator_loc).nil?
        table.field("inheritance_operator_loc", location_inspect(inheritance_operator_loc))
      end

      # superclass
      unless (superclass = node.superclass).nil?
        table.field("superclass", port: true)
        digraph.edge("#{id}:superclass -> #{node_id(superclass)};")
      end

      # body
      unless (body = node.body).nil?
        table.field("body", port: true)
        digraph.edge("#{id}:body -> #{node_id(body)};")
      end

      # end_keyword_loc
      table.field("end_keyword_loc", location_inspect(node.end_keyword_loc))

      # name
      table.field("name", node.name.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ClassVariableAndWriteNode node.
    def visit_class_variable_and_write_node(node)
      table = Table.new("ClassVariableAndWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ClassVariableOperatorWriteNode node.
    def visit_class_variable_operator_write_node(node)
      table = Table.new("ClassVariableOperatorWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # binary_operator_loc
      table.field("binary_operator_loc", location_inspect(node.binary_operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # binary_operator
      table.field("binary_operator", node.binary_operator.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ClassVariableOrWriteNode node.
    def visit_class_variable_or_write_node(node)
      table = Table.new("ClassVariableOrWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ClassVariableReadNode node.
    def visit_class_variable_read_node(node)
      table = Table.new("ClassVariableReadNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ClassVariableTargetNode node.
    def visit_class_variable_target_node(node)
      table = Table.new("ClassVariableTargetNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ClassVariableWriteNode node.
    def visit_class_variable_write_node(node)
      table = Table.new("ClassVariableWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ConstantAndWriteNode node.
    def visit_constant_and_write_node(node)
      table = Table.new("ConstantAndWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ConstantOperatorWriteNode node.
    def visit_constant_operator_write_node(node)
      table = Table.new("ConstantOperatorWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # binary_operator_loc
      table.field("binary_operator_loc", location_inspect(node.binary_operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # binary_operator
      table.field("binary_operator", node.binary_operator.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ConstantOrWriteNode node.
    def visit_constant_or_write_node(node)
      table = Table.new("ConstantOrWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ConstantPathAndWriteNode node.
    def visit_constant_path_and_write_node(node)
      table = Table.new("ConstantPathAndWriteNode")
      id = node_id(node)

      # target
      table.field("target", port: true)
      digraph.edge("#{id}:target -> #{node_id(node.target)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ConstantPathNode node.
    def visit_constant_path_node(node)
      table = Table.new("ConstantPathNode")
      id = node_id(node)

      # parent
      unless (parent = node.parent).nil?
        table.field("parent", port: true)
        digraph.edge("#{id}:parent -> #{node_id(parent)};")
      end

      # name
      table.field("name", node.name.inspect)

      # delimiter_loc
      table.field("delimiter_loc", location_inspect(node.delimiter_loc))

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ConstantPathOperatorWriteNode node.
    def visit_constant_path_operator_write_node(node)
      table = Table.new("ConstantPathOperatorWriteNode")
      id = node_id(node)

      # target
      table.field("target", port: true)
      digraph.edge("#{id}:target -> #{node_id(node.target)};")

      # binary_operator_loc
      table.field("binary_operator_loc", location_inspect(node.binary_operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # binary_operator
      table.field("binary_operator", node.binary_operator.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ConstantPathOrWriteNode node.
    def visit_constant_path_or_write_node(node)
      table = Table.new("ConstantPathOrWriteNode")
      id = node_id(node)

      # target
      table.field("target", port: true)
      digraph.edge("#{id}:target -> #{node_id(node.target)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ConstantPathTargetNode node.
    def visit_constant_path_target_node(node)
      table = Table.new("ConstantPathTargetNode")
      id = node_id(node)

      # parent
      unless (parent = node.parent).nil?
        table.field("parent", port: true)
        digraph.edge("#{id}:parent -> #{node_id(parent)};")
      end

      # name
      table.field("name", node.name.inspect)

      # delimiter_loc
      table.field("delimiter_loc", location_inspect(node.delimiter_loc))

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ConstantPathWriteNode node.
    def visit_constant_path_write_node(node)
      table = Table.new("ConstantPathWriteNode")
      id = node_id(node)

      # target
      table.field("target", port: true)
      digraph.edge("#{id}:target -> #{node_id(node.target)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ConstantReadNode node.
    def visit_constant_read_node(node)
      table = Table.new("ConstantReadNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ConstantTargetNode node.
    def visit_constant_target_node(node)
      table = Table.new("ConstantTargetNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ConstantWriteNode node.
    def visit_constant_write_node(node)
      table = Table.new("ConstantWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a DefNode node.
    def visit_def_node(node)
      table = Table.new("DefNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # receiver
      unless (receiver = node.receiver).nil?
        table.field("receiver", port: true)
        digraph.edge("#{id}:receiver -> #{node_id(receiver)};")
      end

      # parameters
      unless (parameters = node.parameters).nil?
        table.field("parameters", port: true)
        digraph.edge("#{id}:parameters -> #{node_id(parameters)};")
      end

      # body
      unless (body = node.body).nil?
        table.field("body", port: true)
        digraph.edge("#{id}:body -> #{node_id(body)};")
      end

      # locals
      table.field("locals", node.locals.inspect)

      # def_keyword_loc
      table.field("def_keyword_loc", location_inspect(node.def_keyword_loc))

      # operator_loc
      unless (operator_loc = node.operator_loc).nil?
        table.field("operator_loc", location_inspect(operator_loc))
      end

      # lparen_loc
      unless (lparen_loc = node.lparen_loc).nil?
        table.field("lparen_loc", location_inspect(lparen_loc))
      end

      # rparen_loc
      unless (rparen_loc = node.rparen_loc).nil?
        table.field("rparen_loc", location_inspect(rparen_loc))
      end

      # equal_loc
      unless (equal_loc = node.equal_loc).nil?
        table.field("equal_loc", location_inspect(equal_loc))
      end

      # end_keyword_loc
      unless (end_keyword_loc = node.end_keyword_loc).nil?
        table.field("end_keyword_loc", location_inspect(end_keyword_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a DefinedNode node.
    def visit_defined_node(node)
      table = Table.new("DefinedNode")
      id = node_id(node)

      # lparen_loc
      unless (lparen_loc = node.lparen_loc).nil?
        table.field("lparen_loc", location_inspect(lparen_loc))
      end

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # rparen_loc
      unless (rparen_loc = node.rparen_loc).nil?
        table.field("rparen_loc", location_inspect(rparen_loc))
      end

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ElseNode node.
    def visit_else_node(node)
      table = Table.new("ElseNode")
      id = node_id(node)

      # else_keyword_loc
      table.field("else_keyword_loc", location_inspect(node.else_keyword_loc))

      # statements
      unless (statements = node.statements).nil?
        table.field("statements", port: true)
        digraph.edge("#{id}:statements -> #{node_id(statements)};")
      end

      # end_keyword_loc
      unless (end_keyword_loc = node.end_keyword_loc).nil?
        table.field("end_keyword_loc", location_inspect(end_keyword_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a EmbeddedStatementsNode node.
    def visit_embedded_statements_node(node)
      table = Table.new("EmbeddedStatementsNode")
      id = node_id(node)

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # statements
      unless (statements = node.statements).nil?
        table.field("statements", port: true)
        digraph.edge("#{id}:statements -> #{node_id(statements)};")
      end

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a EmbeddedVariableNode node.
    def visit_embedded_variable_node(node)
      table = Table.new("EmbeddedVariableNode")
      id = node_id(node)

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # variable
      table.field("variable", port: true)
      digraph.edge("#{id}:variable -> #{node_id(node.variable)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a EnsureNode node.
    def visit_ensure_node(node)
      table = Table.new("EnsureNode")
      id = node_id(node)

      # ensure_keyword_loc
      table.field("ensure_keyword_loc", location_inspect(node.ensure_keyword_loc))

      # statements
      unless (statements = node.statements).nil?
        table.field("statements", port: true)
        digraph.edge("#{id}:statements -> #{node_id(statements)};")
      end

      # end_keyword_loc
      table.field("end_keyword_loc", location_inspect(node.end_keyword_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a FalseNode node.
    def visit_false_node(node)
      table = Table.new("FalseNode")
      id = node_id(node)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a FindPatternNode node.
    def visit_find_pattern_node(node)
      table = Table.new("FindPatternNode")
      id = node_id(node)

      # constant
      unless (constant = node.constant).nil?
        table.field("constant", port: true)
        digraph.edge("#{id}:constant -> #{node_id(constant)};")
      end

      # left
      table.field("left", port: true)
      digraph.edge("#{id}:left -> #{node_id(node.left)};")

      # requireds
      if node.requireds.any?
        table.field("requireds", port: true)

        waypoint = "#{id}_requireds"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:requireds -> #{waypoint};")
        node.requireds.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("requireds", "[]")
      end

      # right
      table.field("right", port: true)
      digraph.edge("#{id}:right -> #{node_id(node.right)};")

      # opening_loc
      unless (opening_loc = node.opening_loc).nil?
        table.field("opening_loc", location_inspect(opening_loc))
      end

      # closing_loc
      unless (closing_loc = node.closing_loc).nil?
        table.field("closing_loc", location_inspect(closing_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a FlipFlopNode node.
    def visit_flip_flop_node(node)
      table = Table.new("FlipFlopNode")
      id = node_id(node)

      # flags
      table.field("flags", range_flags_inspect(node))

      # left
      unless (left = node.left).nil?
        table.field("left", port: true)
        digraph.edge("#{id}:left -> #{node_id(left)};")
      end

      # right
      unless (right = node.right).nil?
        table.field("right", port: true)
        digraph.edge("#{id}:right -> #{node_id(right)};")
      end

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a FloatNode node.
    def visit_float_node(node)
      table = Table.new("FloatNode")
      id = node_id(node)

      # value
      table.field("value", node.value.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ForNode node.
    def visit_for_node(node)
      table = Table.new("ForNode")
      id = node_id(node)

      # index
      table.field("index", port: true)
      digraph.edge("#{id}:index -> #{node_id(node.index)};")

      # collection
      table.field("collection", port: true)
      digraph.edge("#{id}:collection -> #{node_id(node.collection)};")

      # statements
      unless (statements = node.statements).nil?
        table.field("statements", port: true)
        digraph.edge("#{id}:statements -> #{node_id(statements)};")
      end

      # for_keyword_loc
      table.field("for_keyword_loc", location_inspect(node.for_keyword_loc))

      # in_keyword_loc
      table.field("in_keyword_loc", location_inspect(node.in_keyword_loc))

      # do_keyword_loc
      unless (do_keyword_loc = node.do_keyword_loc).nil?
        table.field("do_keyword_loc", location_inspect(do_keyword_loc))
      end

      # end_keyword_loc
      table.field("end_keyword_loc", location_inspect(node.end_keyword_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ForwardingArgumentsNode node.
    def visit_forwarding_arguments_node(node)
      table = Table.new("ForwardingArgumentsNode")
      id = node_id(node)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ForwardingParameterNode node.
    def visit_forwarding_parameter_node(node)
      table = Table.new("ForwardingParameterNode")
      id = node_id(node)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ForwardingSuperNode node.
    def visit_forwarding_super_node(node)
      table = Table.new("ForwardingSuperNode")
      id = node_id(node)

      # block
      unless (block = node.block).nil?
        table.field("block", port: true)
        digraph.edge("#{id}:block -> #{node_id(block)};")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a GlobalVariableAndWriteNode node.
    def visit_global_variable_and_write_node(node)
      table = Table.new("GlobalVariableAndWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a GlobalVariableOperatorWriteNode node.
    def visit_global_variable_operator_write_node(node)
      table = Table.new("GlobalVariableOperatorWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # binary_operator_loc
      table.field("binary_operator_loc", location_inspect(node.binary_operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # binary_operator
      table.field("binary_operator", node.binary_operator.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a GlobalVariableOrWriteNode node.
    def visit_global_variable_or_write_node(node)
      table = Table.new("GlobalVariableOrWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a GlobalVariableReadNode node.
    def visit_global_variable_read_node(node)
      table = Table.new("GlobalVariableReadNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a GlobalVariableTargetNode node.
    def visit_global_variable_target_node(node)
      table = Table.new("GlobalVariableTargetNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a GlobalVariableWriteNode node.
    def visit_global_variable_write_node(node)
      table = Table.new("GlobalVariableWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a HashNode node.
    def visit_hash_node(node)
      table = Table.new("HashNode")
      id = node_id(node)

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # elements
      if node.elements.any?
        table.field("elements", port: true)

        waypoint = "#{id}_elements"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:elements -> #{waypoint};")
        node.elements.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("elements", "[]")
      end

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a HashPatternNode node.
    def visit_hash_pattern_node(node)
      table = Table.new("HashPatternNode")
      id = node_id(node)

      # constant
      unless (constant = node.constant).nil?
        table.field("constant", port: true)
        digraph.edge("#{id}:constant -> #{node_id(constant)};")
      end

      # elements
      if node.elements.any?
        table.field("elements", port: true)

        waypoint = "#{id}_elements"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:elements -> #{waypoint};")
        node.elements.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("elements", "[]")
      end

      # rest
      unless (rest = node.rest).nil?
        table.field("rest", port: true)
        digraph.edge("#{id}:rest -> #{node_id(rest)};")
      end

      # opening_loc
      unless (opening_loc = node.opening_loc).nil?
        table.field("opening_loc", location_inspect(opening_loc))
      end

      # closing_loc
      unless (closing_loc = node.closing_loc).nil?
        table.field("closing_loc", location_inspect(closing_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a IfNode node.
    def visit_if_node(node)
      table = Table.new("IfNode")
      id = node_id(node)

      # if_keyword_loc
      unless (if_keyword_loc = node.if_keyword_loc).nil?
        table.field("if_keyword_loc", location_inspect(if_keyword_loc))
      end

      # predicate
      table.field("predicate", port: true)
      digraph.edge("#{id}:predicate -> #{node_id(node.predicate)};")

      # then_keyword_loc
      unless (then_keyword_loc = node.then_keyword_loc).nil?
        table.field("then_keyword_loc", location_inspect(then_keyword_loc))
      end

      # statements
      unless (statements = node.statements).nil?
        table.field("statements", port: true)
        digraph.edge("#{id}:statements -> #{node_id(statements)};")
      end

      # subsequent
      unless (subsequent = node.subsequent).nil?
        table.field("subsequent", port: true)
        digraph.edge("#{id}:subsequent -> #{node_id(subsequent)};")
      end

      # end_keyword_loc
      unless (end_keyword_loc = node.end_keyword_loc).nil?
        table.field("end_keyword_loc", location_inspect(end_keyword_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ImaginaryNode node.
    def visit_imaginary_node(node)
      table = Table.new("ImaginaryNode")
      id = node_id(node)

      # numeric
      table.field("numeric", port: true)
      digraph.edge("#{id}:numeric -> #{node_id(node.numeric)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ImplicitNode node.
    def visit_implicit_node(node)
      table = Table.new("ImplicitNode")
      id = node_id(node)

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ImplicitRestNode node.
    def visit_implicit_rest_node(node)
      table = Table.new("ImplicitRestNode")
      id = node_id(node)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a InNode node.
    def visit_in_node(node)
      table = Table.new("InNode")
      id = node_id(node)

      # pattern
      table.field("pattern", port: true)
      digraph.edge("#{id}:pattern -> #{node_id(node.pattern)};")

      # statements
      unless (statements = node.statements).nil?
        table.field("statements", port: true)
        digraph.edge("#{id}:statements -> #{node_id(statements)};")
      end

      # in_loc
      table.field("in_loc", location_inspect(node.in_loc))

      # then_loc
      unless (then_loc = node.then_loc).nil?
        table.field("then_loc", location_inspect(then_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a IndexAndWriteNode node.
    def visit_index_and_write_node(node)
      table = Table.new("IndexAndWriteNode")
      id = node_id(node)

      # flags
      table.field("flags", call_node_flags_inspect(node))

      # receiver
      unless (receiver = node.receiver).nil?
        table.field("receiver", port: true)
        digraph.edge("#{id}:receiver -> #{node_id(receiver)};")
      end

      # call_operator_loc
      unless (call_operator_loc = node.call_operator_loc).nil?
        table.field("call_operator_loc", location_inspect(call_operator_loc))
      end

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # arguments
      unless (arguments = node.arguments).nil?
        table.field("arguments", port: true)
        digraph.edge("#{id}:arguments -> #{node_id(arguments)};")
      end

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      # block
      unless (block = node.block).nil?
        table.field("block", port: true)
        digraph.edge("#{id}:block -> #{node_id(block)};")
      end

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a IndexOperatorWriteNode node.
    def visit_index_operator_write_node(node)
      table = Table.new("IndexOperatorWriteNode")
      id = node_id(node)

      # flags
      table.field("flags", call_node_flags_inspect(node))

      # receiver
      unless (receiver = node.receiver).nil?
        table.field("receiver", port: true)
        digraph.edge("#{id}:receiver -> #{node_id(receiver)};")
      end

      # call_operator_loc
      unless (call_operator_loc = node.call_operator_loc).nil?
        table.field("call_operator_loc", location_inspect(call_operator_loc))
      end

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # arguments
      unless (arguments = node.arguments).nil?
        table.field("arguments", port: true)
        digraph.edge("#{id}:arguments -> #{node_id(arguments)};")
      end

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      # block
      unless (block = node.block).nil?
        table.field("block", port: true)
        digraph.edge("#{id}:block -> #{node_id(block)};")
      end

      # binary_operator
      table.field("binary_operator", node.binary_operator.inspect)

      # binary_operator_loc
      table.field("binary_operator_loc", location_inspect(node.binary_operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a IndexOrWriteNode node.
    def visit_index_or_write_node(node)
      table = Table.new("IndexOrWriteNode")
      id = node_id(node)

      # flags
      table.field("flags", call_node_flags_inspect(node))

      # receiver
      unless (receiver = node.receiver).nil?
        table.field("receiver", port: true)
        digraph.edge("#{id}:receiver -> #{node_id(receiver)};")
      end

      # call_operator_loc
      unless (call_operator_loc = node.call_operator_loc).nil?
        table.field("call_operator_loc", location_inspect(call_operator_loc))
      end

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # arguments
      unless (arguments = node.arguments).nil?
        table.field("arguments", port: true)
        digraph.edge("#{id}:arguments -> #{node_id(arguments)};")
      end

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      # block
      unless (block = node.block).nil?
        table.field("block", port: true)
        digraph.edge("#{id}:block -> #{node_id(block)};")
      end

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a IndexTargetNode node.
    def visit_index_target_node(node)
      table = Table.new("IndexTargetNode")
      id = node_id(node)

      # flags
      table.field("flags", call_node_flags_inspect(node))

      # receiver
      table.field("receiver", port: true)
      digraph.edge("#{id}:receiver -> #{node_id(node.receiver)};")

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # arguments
      unless (arguments = node.arguments).nil?
        table.field("arguments", port: true)
        digraph.edge("#{id}:arguments -> #{node_id(arguments)};")
      end

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      # block
      unless (block = node.block).nil?
        table.field("block", port: true)
        digraph.edge("#{id}:block -> #{node_id(block)};")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a InstanceVariableAndWriteNode node.
    def visit_instance_variable_and_write_node(node)
      table = Table.new("InstanceVariableAndWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a InstanceVariableOperatorWriteNode node.
    def visit_instance_variable_operator_write_node(node)
      table = Table.new("InstanceVariableOperatorWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # binary_operator_loc
      table.field("binary_operator_loc", location_inspect(node.binary_operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # binary_operator
      table.field("binary_operator", node.binary_operator.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a InstanceVariableOrWriteNode node.
    def visit_instance_variable_or_write_node(node)
      table = Table.new("InstanceVariableOrWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a InstanceVariableReadNode node.
    def visit_instance_variable_read_node(node)
      table = Table.new("InstanceVariableReadNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a InstanceVariableTargetNode node.
    def visit_instance_variable_target_node(node)
      table = Table.new("InstanceVariableTargetNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a InstanceVariableWriteNode node.
    def visit_instance_variable_write_node(node)
      table = Table.new("InstanceVariableWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a IntegerNode node.
    def visit_integer_node(node)
      table = Table.new("IntegerNode")
      id = node_id(node)

      # flags
      table.field("flags", integer_base_flags_inspect(node))

      # value
      table.field("value", node.value.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a InterpolatedMatchLastLineNode node.
    def visit_interpolated_match_last_line_node(node)
      table = Table.new("InterpolatedMatchLastLineNode")
      id = node_id(node)

      # flags
      table.field("flags", regular_expression_flags_inspect(node))

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # parts
      if node.parts.any?
        table.field("parts", port: true)

        waypoint = "#{id}_parts"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:parts -> #{waypoint};")
        node.parts.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("parts", "[]")
      end

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a InterpolatedRegularExpressionNode node.
    def visit_interpolated_regular_expression_node(node)
      table = Table.new("InterpolatedRegularExpressionNode")
      id = node_id(node)

      # flags
      table.field("flags", regular_expression_flags_inspect(node))

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # parts
      if node.parts.any?
        table.field("parts", port: true)

        waypoint = "#{id}_parts"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:parts -> #{waypoint};")
        node.parts.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("parts", "[]")
      end

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a InterpolatedStringNode node.
    def visit_interpolated_string_node(node)
      table = Table.new("InterpolatedStringNode")
      id = node_id(node)

      # flags
      table.field("flags", interpolated_string_node_flags_inspect(node))

      # opening_loc
      unless (opening_loc = node.opening_loc).nil?
        table.field("opening_loc", location_inspect(opening_loc))
      end

      # parts
      if node.parts.any?
        table.field("parts", port: true)

        waypoint = "#{id}_parts"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:parts -> #{waypoint};")
        node.parts.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("parts", "[]")
      end

      # closing_loc
      unless (closing_loc = node.closing_loc).nil?
        table.field("closing_loc", location_inspect(closing_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a InterpolatedSymbolNode node.
    def visit_interpolated_symbol_node(node)
      table = Table.new("InterpolatedSymbolNode")
      id = node_id(node)

      # opening_loc
      unless (opening_loc = node.opening_loc).nil?
        table.field("opening_loc", location_inspect(opening_loc))
      end

      # parts
      if node.parts.any?
        table.field("parts", port: true)

        waypoint = "#{id}_parts"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:parts -> #{waypoint};")
        node.parts.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("parts", "[]")
      end

      # closing_loc
      unless (closing_loc = node.closing_loc).nil?
        table.field("closing_loc", location_inspect(closing_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a InterpolatedXStringNode node.
    def visit_interpolated_x_string_node(node)
      table = Table.new("InterpolatedXStringNode")
      id = node_id(node)

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # parts
      if node.parts.any?
        table.field("parts", port: true)

        waypoint = "#{id}_parts"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:parts -> #{waypoint};")
        node.parts.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("parts", "[]")
      end

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ItLocalVariableReadNode node.
    def visit_it_local_variable_read_node(node)
      table = Table.new("ItLocalVariableReadNode")
      id = node_id(node)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ItParametersNode node.
    def visit_it_parameters_node(node)
      table = Table.new("ItParametersNode")
      id = node_id(node)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a KeywordHashNode node.
    def visit_keyword_hash_node(node)
      table = Table.new("KeywordHashNode")
      id = node_id(node)

      # flags
      table.field("flags", keyword_hash_node_flags_inspect(node))

      # elements
      if node.elements.any?
        table.field("elements", port: true)

        waypoint = "#{id}_elements"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:elements -> #{waypoint};")
        node.elements.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("elements", "[]")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a KeywordRestParameterNode node.
    def visit_keyword_rest_parameter_node(node)
      table = Table.new("KeywordRestParameterNode")
      id = node_id(node)

      # flags
      table.field("flags", parameter_flags_inspect(node))

      # name
      table.field("name", node.name.inspect)

      # name_loc
      unless (name_loc = node.name_loc).nil?
        table.field("name_loc", location_inspect(name_loc))
      end

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a LambdaNode node.
    def visit_lambda_node(node)
      table = Table.new("LambdaNode")
      id = node_id(node)

      # locals
      table.field("locals", node.locals.inspect)

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      # parameters
      unless (parameters = node.parameters).nil?
        table.field("parameters", port: true)
        digraph.edge("#{id}:parameters -> #{node_id(parameters)};")
      end

      # body
      unless (body = node.body).nil?
        table.field("body", port: true)
        digraph.edge("#{id}:body -> #{node_id(body)};")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a LocalVariableAndWriteNode node.
    def visit_local_variable_and_write_node(node)
      table = Table.new("LocalVariableAndWriteNode")
      id = node_id(node)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # name
      table.field("name", node.name.inspect)

      # depth
      table.field("depth", node.depth.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a LocalVariableOperatorWriteNode node.
    def visit_local_variable_operator_write_node(node)
      table = Table.new("LocalVariableOperatorWriteNode")
      id = node_id(node)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # binary_operator_loc
      table.field("binary_operator_loc", location_inspect(node.binary_operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # name
      table.field("name", node.name.inspect)

      # binary_operator
      table.field("binary_operator", node.binary_operator.inspect)

      # depth
      table.field("depth", node.depth.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a LocalVariableOrWriteNode node.
    def visit_local_variable_or_write_node(node)
      table = Table.new("LocalVariableOrWriteNode")
      id = node_id(node)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # name
      table.field("name", node.name.inspect)

      # depth
      table.field("depth", node.depth.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a LocalVariableReadNode node.
    def visit_local_variable_read_node(node)
      table = Table.new("LocalVariableReadNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # depth
      table.field("depth", node.depth.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a LocalVariableTargetNode node.
    def visit_local_variable_target_node(node)
      table = Table.new("LocalVariableTargetNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # depth
      table.field("depth", node.depth.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a LocalVariableWriteNode node.
    def visit_local_variable_write_node(node)
      table = Table.new("LocalVariableWriteNode")
      id = node_id(node)

      # name
      table.field("name", node.name.inspect)

      # depth
      table.field("depth", node.depth.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a MatchLastLineNode node.
    def visit_match_last_line_node(node)
      table = Table.new("MatchLastLineNode")
      id = node_id(node)

      # flags
      table.field("flags", regular_expression_flags_inspect(node))

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # content_loc
      table.field("content_loc", location_inspect(node.content_loc))

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      # unescaped
      table.field("unescaped", node.unescaped.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a MatchPredicateNode node.
    def visit_match_predicate_node(node)
      table = Table.new("MatchPredicateNode")
      id = node_id(node)

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # pattern
      table.field("pattern", port: true)
      digraph.edge("#{id}:pattern -> #{node_id(node.pattern)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a MatchRequiredNode node.
    def visit_match_required_node(node)
      table = Table.new("MatchRequiredNode")
      id = node_id(node)

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      # pattern
      table.field("pattern", port: true)
      digraph.edge("#{id}:pattern -> #{node_id(node.pattern)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a MatchWriteNode node.
    def visit_match_write_node(node)
      table = Table.new("MatchWriteNode")
      id = node_id(node)

      # call
      table.field("call", port: true)
      digraph.edge("#{id}:call -> #{node_id(node.call)};")

      # targets
      if node.targets.any?
        table.field("targets", port: true)

        waypoint = "#{id}_targets"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:targets -> #{waypoint};")
        node.targets.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("targets", "[]")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a MissingNode node.
    def visit_missing_node(node)
      table = Table.new("MissingNode")
      id = node_id(node)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ModuleNode node.
    def visit_module_node(node)
      table = Table.new("ModuleNode")
      id = node_id(node)

      # locals
      table.field("locals", node.locals.inspect)

      # module_keyword_loc
      table.field("module_keyword_loc", location_inspect(node.module_keyword_loc))

      # constant_path
      table.field("constant_path", port: true)
      digraph.edge("#{id}:constant_path -> #{node_id(node.constant_path)};")

      # body
      unless (body = node.body).nil?
        table.field("body", port: true)
        digraph.edge("#{id}:body -> #{node_id(body)};")
      end

      # end_keyword_loc
      table.field("end_keyword_loc", location_inspect(node.end_keyword_loc))

      # name
      table.field("name", node.name.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a MultiTargetNode node.
    def visit_multi_target_node(node)
      table = Table.new("MultiTargetNode")
      id = node_id(node)

      # lefts
      if node.lefts.any?
        table.field("lefts", port: true)

        waypoint = "#{id}_lefts"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:lefts -> #{waypoint};")
        node.lefts.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("lefts", "[]")
      end

      # rest
      unless (rest = node.rest).nil?
        table.field("rest", port: true)
        digraph.edge("#{id}:rest -> #{node_id(rest)};")
      end

      # rights
      if node.rights.any?
        table.field("rights", port: true)

        waypoint = "#{id}_rights"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:rights -> #{waypoint};")
        node.rights.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("rights", "[]")
      end

      # lparen_loc
      unless (lparen_loc = node.lparen_loc).nil?
        table.field("lparen_loc", location_inspect(lparen_loc))
      end

      # rparen_loc
      unless (rparen_loc = node.rparen_loc).nil?
        table.field("rparen_loc", location_inspect(rparen_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a MultiWriteNode node.
    def visit_multi_write_node(node)
      table = Table.new("MultiWriteNode")
      id = node_id(node)

      # lefts
      if node.lefts.any?
        table.field("lefts", port: true)

        waypoint = "#{id}_lefts"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:lefts -> #{waypoint};")
        node.lefts.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("lefts", "[]")
      end

      # rest
      unless (rest = node.rest).nil?
        table.field("rest", port: true)
        digraph.edge("#{id}:rest -> #{node_id(rest)};")
      end

      # rights
      if node.rights.any?
        table.field("rights", port: true)

        waypoint = "#{id}_rights"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:rights -> #{waypoint};")
        node.rights.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("rights", "[]")
      end

      # lparen_loc
      unless (lparen_loc = node.lparen_loc).nil?
        table.field("lparen_loc", location_inspect(lparen_loc))
      end

      # rparen_loc
      unless (rparen_loc = node.rparen_loc).nil?
        table.field("rparen_loc", location_inspect(rparen_loc))
      end

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a NextNode node.
    def visit_next_node(node)
      table = Table.new("NextNode")
      id = node_id(node)

      # arguments
      unless (arguments = node.arguments).nil?
        table.field("arguments", port: true)
        digraph.edge("#{id}:arguments -> #{node_id(arguments)};")
      end

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a NilNode node.
    def visit_nil_node(node)
      table = Table.new("NilNode")
      id = node_id(node)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a NoKeywordsParameterNode node.
    def visit_no_keywords_parameter_node(node)
      table = Table.new("NoKeywordsParameterNode")
      id = node_id(node)

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a NumberedParametersNode node.
    def visit_numbered_parameters_node(node)
      table = Table.new("NumberedParametersNode")
      id = node_id(node)

      # maximum
      table.field("maximum", node.maximum.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a NumberedReferenceReadNode node.
    def visit_numbered_reference_read_node(node)
      table = Table.new("NumberedReferenceReadNode")
      id = node_id(node)

      # number
      table.field("number", node.number.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a OptionalKeywordParameterNode node.
    def visit_optional_keyword_parameter_node(node)
      table = Table.new("OptionalKeywordParameterNode")
      id = node_id(node)

      # flags
      table.field("flags", parameter_flags_inspect(node))

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a OptionalParameterNode node.
    def visit_optional_parameter_node(node)
      table = Table.new("OptionalParameterNode")
      id = node_id(node)

      # flags
      table.field("flags", parameter_flags_inspect(node))

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # value
      table.field("value", port: true)
      digraph.edge("#{id}:value -> #{node_id(node.value)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a OrNode node.
    def visit_or_node(node)
      table = Table.new("OrNode")
      id = node_id(node)

      # left
      table.field("left", port: true)
      digraph.edge("#{id}:left -> #{node_id(node.left)};")

      # right
      table.field("right", port: true)
      digraph.edge("#{id}:right -> #{node_id(node.right)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ParametersNode node.
    def visit_parameters_node(node)
      table = Table.new("ParametersNode")
      id = node_id(node)

      # requireds
      if node.requireds.any?
        table.field("requireds", port: true)

        waypoint = "#{id}_requireds"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:requireds -> #{waypoint};")
        node.requireds.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("requireds", "[]")
      end

      # optionals
      if node.optionals.any?
        table.field("optionals", port: true)

        waypoint = "#{id}_optionals"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:optionals -> #{waypoint};")
        node.optionals.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("optionals", "[]")
      end

      # rest
      unless (rest = node.rest).nil?
        table.field("rest", port: true)
        digraph.edge("#{id}:rest -> #{node_id(rest)};")
      end

      # posts
      if node.posts.any?
        table.field("posts", port: true)

        waypoint = "#{id}_posts"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:posts -> #{waypoint};")
        node.posts.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("posts", "[]")
      end

      # keywords
      if node.keywords.any?
        table.field("keywords", port: true)

        waypoint = "#{id}_keywords"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:keywords -> #{waypoint};")
        node.keywords.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("keywords", "[]")
      end

      # keyword_rest
      unless (keyword_rest = node.keyword_rest).nil?
        table.field("keyword_rest", port: true)
        digraph.edge("#{id}:keyword_rest -> #{node_id(keyword_rest)};")
      end

      # block
      unless (block = node.block).nil?
        table.field("block", port: true)
        digraph.edge("#{id}:block -> #{node_id(block)};")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ParenthesesNode node.
    def visit_parentheses_node(node)
      table = Table.new("ParenthesesNode")
      id = node_id(node)

      # body
      unless (body = node.body).nil?
        table.field("body", port: true)
        digraph.edge("#{id}:body -> #{node_id(body)};")
      end

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a PinnedExpressionNode node.
    def visit_pinned_expression_node(node)
      table = Table.new("PinnedExpressionNode")
      id = node_id(node)

      # expression
      table.field("expression", port: true)
      digraph.edge("#{id}:expression -> #{node_id(node.expression)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # lparen_loc
      table.field("lparen_loc", location_inspect(node.lparen_loc))

      # rparen_loc
      table.field("rparen_loc", location_inspect(node.rparen_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a PinnedVariableNode node.
    def visit_pinned_variable_node(node)
      table = Table.new("PinnedVariableNode")
      id = node_id(node)

      # variable
      table.field("variable", port: true)
      digraph.edge("#{id}:variable -> #{node_id(node.variable)};")

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a PostExecutionNode node.
    def visit_post_execution_node(node)
      table = Table.new("PostExecutionNode")
      id = node_id(node)

      # statements
      unless (statements = node.statements).nil?
        table.field("statements", port: true)
        digraph.edge("#{id}:statements -> #{node_id(statements)};")
      end

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a PreExecutionNode node.
    def visit_pre_execution_node(node)
      table = Table.new("PreExecutionNode")
      id = node_id(node)

      # statements
      unless (statements = node.statements).nil?
        table.field("statements", port: true)
        digraph.edge("#{id}:statements -> #{node_id(statements)};")
      end

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ProgramNode node.
    def visit_program_node(node)
      table = Table.new("ProgramNode")
      id = node_id(node)

      # locals
      table.field("locals", node.locals.inspect)

      # statements
      table.field("statements", port: true)
      digraph.edge("#{id}:statements -> #{node_id(node.statements)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a RangeNode node.
    def visit_range_node(node)
      table = Table.new("RangeNode")
      id = node_id(node)

      # flags
      table.field("flags", range_flags_inspect(node))

      # left
      unless (left = node.left).nil?
        table.field("left", port: true)
        digraph.edge("#{id}:left -> #{node_id(left)};")
      end

      # right
      unless (right = node.right).nil?
        table.field("right", port: true)
        digraph.edge("#{id}:right -> #{node_id(right)};")
      end

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a RationalNode node.
    def visit_rational_node(node)
      table = Table.new("RationalNode")
      id = node_id(node)

      # flags
      table.field("flags", integer_base_flags_inspect(node))

      # numerator
      table.field("numerator", node.numerator.inspect)

      # denominator
      table.field("denominator", node.denominator.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a RedoNode node.
    def visit_redo_node(node)
      table = Table.new("RedoNode")
      id = node_id(node)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a RegularExpressionNode node.
    def visit_regular_expression_node(node)
      table = Table.new("RegularExpressionNode")
      id = node_id(node)

      # flags
      table.field("flags", regular_expression_flags_inspect(node))

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # content_loc
      table.field("content_loc", location_inspect(node.content_loc))

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      # unescaped
      table.field("unescaped", node.unescaped.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a RequiredKeywordParameterNode node.
    def visit_required_keyword_parameter_node(node)
      table = Table.new("RequiredKeywordParameterNode")
      id = node_id(node)

      # flags
      table.field("flags", parameter_flags_inspect(node))

      # name
      table.field("name", node.name.inspect)

      # name_loc
      table.field("name_loc", location_inspect(node.name_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a RequiredParameterNode node.
    def visit_required_parameter_node(node)
      table = Table.new("RequiredParameterNode")
      id = node_id(node)

      # flags
      table.field("flags", parameter_flags_inspect(node))

      # name
      table.field("name", node.name.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a RescueModifierNode node.
    def visit_rescue_modifier_node(node)
      table = Table.new("RescueModifierNode")
      id = node_id(node)

      # expression
      table.field("expression", port: true)
      digraph.edge("#{id}:expression -> #{node_id(node.expression)};")

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      # rescue_expression
      table.field("rescue_expression", port: true)
      digraph.edge("#{id}:rescue_expression -> #{node_id(node.rescue_expression)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a RescueNode node.
    def visit_rescue_node(node)
      table = Table.new("RescueNode")
      id = node_id(node)

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      # exceptions
      if node.exceptions.any?
        table.field("exceptions", port: true)

        waypoint = "#{id}_exceptions"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:exceptions -> #{waypoint};")
        node.exceptions.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("exceptions", "[]")
      end

      # operator_loc
      unless (operator_loc = node.operator_loc).nil?
        table.field("operator_loc", location_inspect(operator_loc))
      end

      # reference
      unless (reference = node.reference).nil?
        table.field("reference", port: true)
        digraph.edge("#{id}:reference -> #{node_id(reference)};")
      end

      # statements
      unless (statements = node.statements).nil?
        table.field("statements", port: true)
        digraph.edge("#{id}:statements -> #{node_id(statements)};")
      end

      # subsequent
      unless (subsequent = node.subsequent).nil?
        table.field("subsequent", port: true)
        digraph.edge("#{id}:subsequent -> #{node_id(subsequent)};")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a RestParameterNode node.
    def visit_rest_parameter_node(node)
      table = Table.new("RestParameterNode")
      id = node_id(node)

      # flags
      table.field("flags", parameter_flags_inspect(node))

      # name
      table.field("name", node.name.inspect)

      # name_loc
      unless (name_loc = node.name_loc).nil?
        table.field("name_loc", location_inspect(name_loc))
      end

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a RetryNode node.
    def visit_retry_node(node)
      table = Table.new("RetryNode")
      id = node_id(node)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ReturnNode node.
    def visit_return_node(node)
      table = Table.new("ReturnNode")
      id = node_id(node)

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      # arguments
      unless (arguments = node.arguments).nil?
        table.field("arguments", port: true)
        digraph.edge("#{id}:arguments -> #{node_id(arguments)};")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a SelfNode node.
    def visit_self_node(node)
      table = Table.new("SelfNode")
      id = node_id(node)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a ShareableConstantNode node.
    def visit_shareable_constant_node(node)
      table = Table.new("ShareableConstantNode")
      id = node_id(node)

      # flags
      table.field("flags", shareable_constant_node_flags_inspect(node))

      # write
      table.field("write", port: true)
      digraph.edge("#{id}:write -> #{node_id(node.write)};")

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a SingletonClassNode node.
    def visit_singleton_class_node(node)
      table = Table.new("SingletonClassNode")
      id = node_id(node)

      # locals
      table.field("locals", node.locals.inspect)

      # class_keyword_loc
      table.field("class_keyword_loc", location_inspect(node.class_keyword_loc))

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # expression
      table.field("expression", port: true)
      digraph.edge("#{id}:expression -> #{node_id(node.expression)};")

      # body
      unless (body = node.body).nil?
        table.field("body", port: true)
        digraph.edge("#{id}:body -> #{node_id(body)};")
      end

      # end_keyword_loc
      table.field("end_keyword_loc", location_inspect(node.end_keyword_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a SourceEncodingNode node.
    def visit_source_encoding_node(node)
      table = Table.new("SourceEncodingNode")
      id = node_id(node)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a SourceFileNode node.
    def visit_source_file_node(node)
      table = Table.new("SourceFileNode")
      id = node_id(node)

      # flags
      table.field("flags", string_flags_inspect(node))

      # filepath
      table.field("filepath", node.filepath.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a SourceLineNode node.
    def visit_source_line_node(node)
      table = Table.new("SourceLineNode")
      id = node_id(node)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a SplatNode node.
    def visit_splat_node(node)
      table = Table.new("SplatNode")
      id = node_id(node)

      # operator_loc
      table.field("operator_loc", location_inspect(node.operator_loc))

      # expression
      unless (expression = node.expression).nil?
        table.field("expression", port: true)
        digraph.edge("#{id}:expression -> #{node_id(expression)};")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a StatementsNode node.
    def visit_statements_node(node)
      table = Table.new("StatementsNode")
      id = node_id(node)

      # body
      if node.body.any?
        table.field("body", port: true)

        waypoint = "#{id}_body"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:body -> #{waypoint};")
        node.body.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("body", "[]")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a StringNode node.
    def visit_string_node(node)
      table = Table.new("StringNode")
      id = node_id(node)

      # flags
      table.field("flags", string_flags_inspect(node))

      # opening_loc
      unless (opening_loc = node.opening_loc).nil?
        table.field("opening_loc", location_inspect(opening_loc))
      end

      # content_loc
      table.field("content_loc", location_inspect(node.content_loc))

      # closing_loc
      unless (closing_loc = node.closing_loc).nil?
        table.field("closing_loc", location_inspect(closing_loc))
      end

      # unescaped
      table.field("unescaped", node.unescaped.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a SuperNode node.
    def visit_super_node(node)
      table = Table.new("SuperNode")
      id = node_id(node)

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      # lparen_loc
      unless (lparen_loc = node.lparen_loc).nil?
        table.field("lparen_loc", location_inspect(lparen_loc))
      end

      # arguments
      unless (arguments = node.arguments).nil?
        table.field("arguments", port: true)
        digraph.edge("#{id}:arguments -> #{node_id(arguments)};")
      end

      # rparen_loc
      unless (rparen_loc = node.rparen_loc).nil?
        table.field("rparen_loc", location_inspect(rparen_loc))
      end

      # block
      unless (block = node.block).nil?
        table.field("block", port: true)
        digraph.edge("#{id}:block -> #{node_id(block)};")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a SymbolNode node.
    def visit_symbol_node(node)
      table = Table.new("SymbolNode")
      id = node_id(node)

      # flags
      table.field("flags", symbol_flags_inspect(node))

      # opening_loc
      unless (opening_loc = node.opening_loc).nil?
        table.field("opening_loc", location_inspect(opening_loc))
      end

      # value_loc
      unless (value_loc = node.value_loc).nil?
        table.field("value_loc", location_inspect(value_loc))
      end

      # closing_loc
      unless (closing_loc = node.closing_loc).nil?
        table.field("closing_loc", location_inspect(closing_loc))
      end

      # unescaped
      table.field("unescaped", node.unescaped.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a TrueNode node.
    def visit_true_node(node)
      table = Table.new("TrueNode")
      id = node_id(node)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a UndefNode node.
    def visit_undef_node(node)
      table = Table.new("UndefNode")
      id = node_id(node)

      # names
      if node.names.any?
        table.field("names", port: true)

        waypoint = "#{id}_names"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:names -> #{waypoint};")
        node.names.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("names", "[]")
      end

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a UnlessNode node.
    def visit_unless_node(node)
      table = Table.new("UnlessNode")
      id = node_id(node)

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      # predicate
      table.field("predicate", port: true)
      digraph.edge("#{id}:predicate -> #{node_id(node.predicate)};")

      # then_keyword_loc
      unless (then_keyword_loc = node.then_keyword_loc).nil?
        table.field("then_keyword_loc", location_inspect(then_keyword_loc))
      end

      # statements
      unless (statements = node.statements).nil?
        table.field("statements", port: true)
        digraph.edge("#{id}:statements -> #{node_id(statements)};")
      end

      # else_clause
      unless (else_clause = node.else_clause).nil?
        table.field("else_clause", port: true)
        digraph.edge("#{id}:else_clause -> #{node_id(else_clause)};")
      end

      # end_keyword_loc
      unless (end_keyword_loc = node.end_keyword_loc).nil?
        table.field("end_keyword_loc", location_inspect(end_keyword_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a UntilNode node.
    def visit_until_node(node)
      table = Table.new("UntilNode")
      id = node_id(node)

      # flags
      table.field("flags", loop_flags_inspect(node))

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      # closing_loc
      unless (closing_loc = node.closing_loc).nil?
        table.field("closing_loc", location_inspect(closing_loc))
      end

      # predicate
      table.field("predicate", port: true)
      digraph.edge("#{id}:predicate -> #{node_id(node.predicate)};")

      # statements
      unless (statements = node.statements).nil?
        table.field("statements", port: true)
        digraph.edge("#{id}:statements -> #{node_id(statements)};")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a WhenNode node.
    def visit_when_node(node)
      table = Table.new("WhenNode")
      id = node_id(node)

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      # conditions
      if node.conditions.any?
        table.field("conditions", port: true)

        waypoint = "#{id}_conditions"
        digraph.waypoint("#{waypoint};")

        digraph.edge("#{id}:conditions -> #{waypoint};")
        node.conditions.each { |child| digraph.edge("#{waypoint} -> #{node_id(child)};") }
      else
        table.field("conditions", "[]")
      end

      # then_keyword_loc
      unless (then_keyword_loc = node.then_keyword_loc).nil?
        table.field("then_keyword_loc", location_inspect(then_keyword_loc))
      end

      # statements
      unless (statements = node.statements).nil?
        table.field("statements", port: true)
        digraph.edge("#{id}:statements -> #{node_id(statements)};")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a WhileNode node.
    def visit_while_node(node)
      table = Table.new("WhileNode")
      id = node_id(node)

      # flags
      table.field("flags", loop_flags_inspect(node))

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      # closing_loc
      unless (closing_loc = node.closing_loc).nil?
        table.field("closing_loc", location_inspect(closing_loc))
      end

      # predicate
      table.field("predicate", port: true)
      digraph.edge("#{id}:predicate -> #{node_id(node.predicate)};")

      # statements
      unless (statements = node.statements).nil?
        table.field("statements", port: true)
        digraph.edge("#{id}:statements -> #{node_id(statements)};")
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a XStringNode node.
    def visit_x_string_node(node)
      table = Table.new("XStringNode")
      id = node_id(node)

      # flags
      table.field("flags", encoding_flags_inspect(node))

      # opening_loc
      table.field("opening_loc", location_inspect(node.opening_loc))

      # content_loc
      table.field("content_loc", location_inspect(node.content_loc))

      # closing_loc
      table.field("closing_loc", location_inspect(node.closing_loc))

      # unescaped
      table.field("unescaped", node.unescaped.inspect)

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    # Visit a YieldNode node.
    def visit_yield_node(node)
      table = Table.new("YieldNode")
      id = node_id(node)

      # keyword_loc
      table.field("keyword_loc", location_inspect(node.keyword_loc))

      # lparen_loc
      unless (lparen_loc = node.lparen_loc).nil?
        table.field("lparen_loc", location_inspect(lparen_loc))
      end

      # arguments
      unless (arguments = node.arguments).nil?
        table.field("arguments", port: true)
        digraph.edge("#{id}:arguments -> #{node_id(arguments)};")
      end

      # rparen_loc
      unless (rparen_loc = node.rparen_loc).nil?
        table.field("rparen_loc", location_inspect(rparen_loc))
      end

      digraph.nodes << <<~DOT
        #{id} [
          label=<#{table.to_dot.gsub(/\n/, "\n  ")}>
        ];
      DOT

      super
    end

    private

    # Generate a unique node ID for a node throughout the digraph.
    def node_id(node)
      "Node_#{node.object_id}"
    end

    # Inspect a location to display the start and end line and column numbers.
    def location_inspect(location)
      "(#{location.start_line},#{location.start_column})-(#{location.end_line},#{location.end_column})"
    end

    # Inspect a node that has arguments_node_flags flags to display the flags as a
    # comma-separated list.
    def arguments_node_flags_inspect(node)
      flags = [] #: Array[String]
      flags << "contains_forwarding" if node.contains_forwarding?
      flags << "contains_keywords" if node.contains_keywords?
      flags << "contains_keyword_splat" if node.contains_keyword_splat?
      flags << "contains_splat" if node.contains_splat?
      flags << "contains_multiple_splats" if node.contains_multiple_splats?
      flags.join(", ")
    end

    # Inspect a node that has array_node_flags flags to display the flags as a
    # comma-separated list.
    def array_node_flags_inspect(node)
      flags = [] #: Array[String]
      flags << "contains_splat" if node.contains_splat?
      flags.join(", ")
    end

    # Inspect a node that has call_node_flags flags to display the flags as a
    # comma-separated list.
    def call_node_flags_inspect(node)
      flags = [] #: Array[String]
      flags << "safe_navigation" if node.safe_navigation?
      flags << "variable_call" if node.variable_call?
      flags << "attribute_write" if node.attribute_write?
      flags << "ignore_visibility" if node.ignore_visibility?
      flags.join(", ")
    end

    # Inspect a node that has encoding_flags flags to display the flags as a
    # comma-separated list.
    def encoding_flags_inspect(node)
      flags = [] #: Array[String]
      flags << "forced_utf8_encoding" if node.forced_utf8_encoding?
      flags << "forced_binary_encoding" if node.forced_binary_encoding?
      flags.join(", ")
    end

    # Inspect a node that has integer_base_flags flags to display the flags as a
    # comma-separated list.
    def integer_base_flags_inspect(node)
      flags = [] #: Array[String]
      flags << "binary" if node.binary?
      flags << "decimal" if node.decimal?
      flags << "octal" if node.octal?
      flags << "hexadecimal" if node.hexadecimal?
      flags.join(", ")
    end

    # Inspect a node that has interpolated_string_node_flags flags to display the flags as a
    # comma-separated list.
    def interpolated_string_node_flags_inspect(node)
      flags = [] #: Array[String]
      flags << "frozen" if node.frozen?
      flags << "mutable" if node.mutable?
      flags.join(", ")
    end

    # Inspect a node that has keyword_hash_node_flags flags to display the flags as a
    # comma-separated list.
    def keyword_hash_node_flags_inspect(node)
      flags = [] #: Array[String]
      flags << "symbol_keys" if node.symbol_keys?
      flags.join(", ")
    end

    # Inspect a node that has loop_flags flags to display the flags as a
    # comma-separated list.
    def loop_flags_inspect(node)
      flags = [] #: Array[String]
      flags << "begin_modifier" if node.begin_modifier?
      flags.join(", ")
    end

    # Inspect a node that has parameter_flags flags to display the flags as a
    # comma-separated list.
    def parameter_flags_inspect(node)
      flags = [] #: Array[String]
      flags << "repeated_parameter" if node.repeated_parameter?
      flags.join(", ")
    end

    # Inspect a node that has range_flags flags to display the flags as a
    # comma-separated list.
    def range_flags_inspect(node)
      flags = [] #: Array[String]
      flags << "exclude_end" if node.exclude_end?
      flags.join(", ")
    end

    # Inspect a node that has regular_expression_flags flags to display the flags as a
    # comma-separated list.
    def regular_expression_flags_inspect(node)
      flags = [] #: Array[String]
      flags << "ignore_case" if node.ignore_case?
      flags << "extended" if node.extended?
      flags << "multi_line" if node.multi_line?
      flags << "once" if node.once?
      flags << "euc_jp" if node.euc_jp?
      flags << "ascii_8bit" if node.ascii_8bit?
      flags << "windows_31j" if node.windows_31j?
      flags << "utf_8" if node.utf_8?
      flags << "forced_utf8_encoding" if node.forced_utf8_encoding?
      flags << "forced_binary_encoding" if node.forced_binary_encoding?
      flags << "forced_us_ascii_encoding" if node.forced_us_ascii_encoding?
      flags.join(", ")
    end

    # Inspect a node that has shareable_constant_node_flags flags to display the flags as a
    # comma-separated list.
    def shareable_constant_node_flags_inspect(node)
      flags = [] #: Array[String]
      flags << "literal" if node.literal?
      flags << "experimental_everything" if node.experimental_everything?
      flags << "experimental_copy" if node.experimental_copy?
      flags.join(", ")
    end

    # Inspect a node that has string_flags flags to display the flags as a
    # comma-separated list.
    def string_flags_inspect(node)
      flags = [] #: Array[String]
      flags << "forced_utf8_encoding" if node.forced_utf8_encoding?
      flags << "forced_binary_encoding" if node.forced_binary_encoding?
      flags << "frozen" if node.frozen?
      flags << "mutable" if node.mutable?
      flags.join(", ")
    end

    # Inspect a node that has symbol_flags flags to display the flags as a
    # comma-separated list.
    def symbol_flags_inspect(node)
      flags = [] #: Array[String]
      flags << "forced_utf8_encoding" if node.forced_utf8_encoding?
      flags << "forced_binary_encoding" if node.forced_binary_encoding?
      flags << "forced_us_ascii_encoding" if node.forced_us_ascii_encoding?
      flags.join(", ")
    end
  end
end
