/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.resources;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InternalResource;
import java.io.IOException;
import java.nio.file.Path;

@InternalResource.Id(value="ruby-home", componentId="ruby", optional=true)
public final class RubyHomeResource
implements InternalResource {
    private static final Path BASE_PATH = Path.of("META-INF", "resources", "ruby", "ruby-home");
    private static final Path ARCH_SPECIFIC_PATH = BASE_PATH.resolve(InternalResource.OS.getCurrent().toString()).resolve(InternalResource.CPUArchitecture.getCurrent().toString());
    private static final Path ARCH_AGNOSTIC_PATH = BASE_PATH.resolve("common");

    public void unpackFiles(InternalResource.Env env, Path targetDirectory) throws IOException {
        env.unpackResourceFiles(ARCH_AGNOSTIC_PATH.resolve("file-list"), targetDirectory, ARCH_AGNOSTIC_PATH);
        env.unpackResourceFiles(ARCH_SPECIFIC_PATH.resolve("file-list"), targetDirectory, ARCH_SPECIFIC_PATH);
    }

    public String versionHash(InternalResource.Env env) {
        try {
            return (String)env.readResourceLines(ARCH_AGNOSTIC_PATH.resolve("sha256")).get(0) + (String)env.readResourceLines(ARCH_SPECIFIC_PATH.resolve("sha256")).get(0);
        }
        catch (IOException ioe) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)ioe);
        }
    }
}

