/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.shared;

import java.util.Locale;
import org.truffleruby.shared.BuildInformationImpl;

public abstract class Platform {
    public static final OS_TYPE OS = Platform.determineOS();
    public static final ARCH ARCHITECTURE = Platform.determineArchitecture();
    public static final String LIB_SUFFIX = Platform.determineLibSuffix();
    public static final String CEXT_SUFFIX = OS == OS_TYPE.DARWIN ? ".bundle" : LIB_SUFFIX;
    public static final boolean CEXT_SUFFIX_IS_SO = CEXT_SUFFIX.equals(".so");

    public static String getOSName() {
        return Platform.OS.rubyName;
    }

    public static String getArchName() {
        return Platform.ARCHITECTURE.rubyName;
    }

    public static OS_TYPE determineOS() {
        String osName = System.getProperty("os.name");
        String lowerOSName = osName.toLowerCase(Locale.ENGLISH);
        if (lowerOSName.startsWith("mac") || lowerOSName.startsWith("darwin")) {
            return OS_TYPE.DARWIN;
        }
        String upperOSName = osName.toUpperCase(Locale.ENGLISH);
        for (OS_TYPE os : OS_TYPE.values()) {
            if (!upperOSName.startsWith(os.name())) continue;
            return os;
        }
        throw new UnsupportedOperationException("Unsupported operating system: " + osName);
    }

    private static ARCH determineArchitecture() {
        String architecture;
        switch (architecture = System.getProperty("os.arch")) {
            case "amd64": 
            case "x86_64": {
                return ARCH.AMD64;
            }
            case "aarch64": 
            case "arm64": {
                return ARCH.AARCH64;
            }
        }
        throw new UnsupportedOperationException("Unsupported CPU architecture: " + architecture);
    }

    private static String determineLibSuffix() {
        switch (OS.ordinal()) {
            case 1: {
                return ".dylib";
            }
        }
        return ".so";
    }

    public static String getKernelMajorVersion() {
        if (OS == OS_TYPE.DARWIN) {
            return BuildInformationImpl.INSTANCE.getKernelMajorVersion();
        }
        return "";
    }

    public static enum OS_TYPE {
        LINUX("linux"),
        DARWIN("darwin");

        private final String rubyName;

        private OS_TYPE(String rubyName) {
            this.rubyName = rubyName;
        }
    }

    public static enum ARCH {
        AMD64("x86_64"),
        AARCH64("aarch64");

        private final String rubyName;

        private ARCH(String rubyName) {
            this.rubyName = rubyName;
        }
    }
}

