/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.shared.options;

import java.util.ArrayList;
import org.graalvm.options.OptionType;

public class StringArrayOptionType {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final OptionType<String[]> INSTANCE = new OptionType("String[]", StringArrayOptionType::parseStringArray);

    private static String[] parseStringArray(String string) {
        ArrayList<String> values = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        State state = State.STRING_OF_STRING;
        block12: for (int n = 0; n < string.length(); ++n) {
            if (state == State.STRING_OF_STRING) {
                builder.setLength(0);
                state = State.WITHIN_STRING;
            }
            switch (state.ordinal()) {
                case 1: {
                    switch (string.charAt(n)) {
                        case ',': {
                            values.add(builder.toString());
                            state = State.STRING_OF_STRING;
                            continue block12;
                        }
                        case '\\': {
                            state = State.ESCAPE;
                            continue block12;
                        }
                    }
                    builder.append(string.charAt(n));
                    continue block12;
                }
                case 2: {
                    state = State.WITHIN_STRING;
                    if (string.charAt(n) == ',') {
                        builder.append(string.charAt(n));
                        continue block12;
                    }
                    builder.append('\\');
                    builder.append(string.charAt(n));
                }
            }
        }
        switch (state.ordinal()) {
            case 1: {
                values.add(builder.toString());
                break;
            }
            case 2: {
                throw new IllegalArgumentException();
            }
        }
        return values.toArray(EMPTY_STRING_ARRAY);
    }

    public static String append(String currentValues, String newElement) {
        String escaped = StringArrayOptionType.escape(newElement);
        if (currentValues.isEmpty()) {
            return escaped;
        }
        return currentValues + "," + escaped;
    }

    public static String escape(String string) {
        return string.replaceAll(",", "\\\\,");
    }

    private static enum State {
        STRING_OF_STRING,
        WITHIN_STRING,
        ESCAPE;

    }
}

