/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.launcher;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.launcher.AbstractLanguageLauncher;
import org.graalvm.launcher.Launcher;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionStability;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Instrument;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotException;

public abstract class LanguageLauncherBase
extends Launcher {
    private static final String ID_HEADER = "[id]";
    private static final String NAME_HEADER = "[name]";
    private static final String WEBSITE_HEADER = "[website]";
    private static Engine tempEngine;
    private boolean seenPolyglot;
    private Launcher.VersionAction versionAction = Launcher.VersionAction.None;

    static Engine getTempEngine() {
        if (tempEngine == null) {
            tempEngine = Engine.newBuilder().useSystemProperties(false).out(OutputStream.nullOutputStream()).err(OutputStream.nullOutputStream()).option("engine.WarnInterpreterOnly", "false").build();
        }
        return tempEngine;
    }

    private static String website(Instrument instrument) {
        String website = instrument.getWebsite();
        return website.isEmpty() ? "" : " (" + website + ")";
    }

    private static String title(Language language) {
        StringBuilder title = new StringBuilder("  " + language.getName());
        String website = language.getWebsite();
        if (!"".equals(website)) {
            title.append(" (");
            title.append(website);
            title.append(")");
        }
        title.append(":");
        return title.toString();
    }

    private static List<Launcher.PrintableOption> filterOptions(OptionDescriptors descriptors, OptionCategory optionCategory, String optionPrefixDot) {
        assert (optionPrefixDot.endsWith("."));
        ArrayList<Launcher.PrintableOption> options = new ArrayList<Launcher.PrintableOption>();
        for (OptionDescriptor descriptor : descriptors) {
            if (descriptor.isDeprecated() || !LanguageLauncherBase.sameCategory(descriptor, optionCategory) || !optionPrefixDot.equals("all.") && !descriptor.getName().startsWith(optionPrefixDot)) continue;
            options.add(LanguageLauncherBase.asPrintableOption(descriptor));
        }
        options.sort(Launcher.PrintableOption::compareTo);
        return options;
    }

    private static boolean sameCategory(OptionDescriptor descriptor, OptionCategory optionCategory) {
        return descriptor.getCategory().ordinal() == optionCategory.ordinal();
    }

    private static Launcher.PrintableOption asPrintableOption(OptionDescriptor descriptor) {
        String usageSyntax;
        StringBuilder key = new StringBuilder("--");
        String name = descriptor.getName();
        key.append(name);
        if (descriptor.isOptionMap()) {
            key.append(".<key>");
        }
        if ((usageSyntax = descriptor.getUsageSyntax()) != null) {
            key.append("=");
            key.append(usageSyntax);
        }
        Object help = descriptor.getHelp();
        if (descriptor.isDeprecated()) {
            help = (String)help + " [Deprecated]";
        }
        return new Launcher.PrintableOption(name, key.toString(), (String)help, descriptor.getStability() == OptionStability.EXPERIMENTAL);
    }

    private static void addOptions(OptionDescriptors descriptors, Set<String> target) {
        for (OptionDescriptor descriptor : descriptors) {
            target.add("--" + descriptor.getName());
        }
    }

    static List<Language> sortedLanguages(Engine engine) {
        ArrayList<Language> languages = new ArrayList<Language>(engine.getLanguages().values());
        languages.sort(Comparator.comparing(Language::getId));
        return languages;
    }

    static List<Instrument> sortedInstruments(Engine engine) {
        ArrayList<Instrument> instruments = new ArrayList<Instrument>();
        for (Instrument instrument : engine.getInstruments().values()) {
            if (!instrument.getOptions().iterator().hasNext()) continue;
            instruments.add(instrument);
        }
        instruments.sort(Comparator.comparing(Instrument::getId));
        return instruments;
    }

    final boolean isPolyglot() {
        return this.seenPolyglot;
    }

    final void setPolyglot(boolean polyglot) {
        this.seenPolyglot = polyglot;
    }

    final void setupContextBuilder(Context.Builder builder) {
        Path logFile = this.getLogFile();
        if (logFile != null) {
            try {
                builder.logHandler(LanguageLauncherBase.newLogStream(logFile));
            }
            catch (IOException ioe) {
                throw this.abort(ioe);
            }
        }
        if (System.err != this.getError()) {
            builder.err((OutputStream)this.getError());
        }
        if (System.out != this.getOutput()) {
            builder.out((OutputStream)this.getOutput());
        }
    }

    protected void argumentsProcessingDone() {
        if (tempEngine != null) {
            tempEngine.close();
            tempEngine = null;
        }
    }

    @Override
    protected boolean runLauncherAction() {
        switch (this.versionAction) {
            case PrintAndExit: {
                this.printPolyglotVersions();
                return true;
            }
            case PrintAndContinue: {
                this.printPolyglotVersions();
                break;
            }
        }
        return super.runLauncherAction();
    }

    @Override
    protected boolean parseCommonOption(String defaultOptionPrefix, Map<String, String> polyglotOptions, boolean experimentalOptions, String arg) {
        switch (arg) {
            case "--polyglot": {
                this.seenPolyglot = true;
                break;
            }
            case "--version:graalvm": {
                this.versionAction = Launcher.VersionAction.PrintAndExit;
                break;
            }
            case "--show-version:graalvm": {
                this.versionAction = Launcher.VersionAction.PrintAndContinue;
                break;
            }
            default: {
                return super.parseCommonOption(defaultOptionPrefix, polyglotOptions, experimentalOptions, arg);
            }
        }
        return true;
    }

    void handlePolyglotException(PolyglotException e) {
        String message = null;
        if (e.getMessage() != null) {
            message = e.getMessage();
        } else if (e.isInternalError()) {
            message = "Unknown error";
        }
        if (message != null) {
            System.err.println("ERROR: " + message);
        }
        if (e.isInternalError()) {
            e.printStackTrace();
        }
        if (e.isExit()) {
            System.exit(e.getExitStatus());
        } else {
            System.exit(1);
        }
    }

    @Override
    protected void printDefaultHelp(OptionCategory helpCategory) {
        super.printDefaultHelp(helpCategory);
        this.launcherOption("--help:engine", "Print engine options.");
        this.launcherOption("--help:compiler", "Print engine compiler options.");
        this.launcherOption("--help:all", "Print all options.");
        this.launcherOption("--version:graalvm", "Print GraalVM version information and exit.");
        this.launcherOption("--show-version:graalvm", "Print GraalVM version information and continue execution.");
        this.println("");
        this.printInstalledComponents();
        this.println("");
        this.println("  Use --help:[id] for component options.");
    }

    private void printInstalledComponents() {
        List<Language> languages = LanguageLauncherBase.sortedLanguages(LanguageLauncherBase.getTempEngine());
        int maxId = ID_HEADER.length();
        int maxName = NAME_HEADER.length();
        for (Language language : languages) {
            maxId = Math.max(maxId, language.getId().length());
            maxName = Integer.max(maxName, language.getName().length());
        }
        List<Instrument> instruments = LanguageLauncherBase.sortedInstruments(LanguageLauncherBase.getTempEngine());
        for (Instrument instrument : instruments) {
            maxId = Integer.max(maxId, instrument.getId().length());
            maxName = Integer.max(maxName, instrument.getName().length());
        }
        if (!languages.isEmpty()) {
            this.println("Languages:");
            this.printInstalled(maxId, maxName, ID_HEADER, NAME_HEADER, WEBSITE_HEADER);
            for (Language language : languages) {
                this.printInstalled(maxId, maxName, language.getId(), language.getName(), language.getWebsite());
            }
        }
        this.println("");
        if (!instruments.isEmpty()) {
            this.println("Tools:");
            this.printInstalled(maxId, maxName, ID_HEADER, NAME_HEADER, WEBSITE_HEADER);
            for (Instrument instrument : instruments) {
                this.printInstalled(maxId, maxName, instrument.getId(), instrument.getName(), instrument.getWebsite());
            }
        }
    }

    private void printInstalled(int maxId, int maxName, String id, String name, String website) {
        this.println(String.format("  %-" + maxId + "s %-" + maxName + "s %s", id, name, website, id));
    }

    @Override
    protected void maybePrintAdditionalHelp(OptionCategory helpCategory) {
        if (this.helpArg == null || "".equals(this.helpArg)) {
            return;
        }
        boolean all = "all".equals(this.helpArg);
        if (all || "languages".equals(this.helpArg)) {
            this.helpPrinted = this.printLanguageOptions(LanguageLauncherBase.getTempEngine(), null);
        }
        if (all || "tools".equals(this.helpArg)) {
            this.helpPrinted = this.printInstrumentOptions(LanguageLauncherBase.getTempEngine(), null);
        }
        if (all || "engine".equals(this.helpArg) || "compiler".equals(this.helpArg)) {
            this.helpPrinted = this.printEngineOptions(LanguageLauncherBase.getTempEngine(), this.helpArg);
        }
        if (this.helpPrinted) {
            return;
        }
        this.helpPrinted = this.printLanguageOptions(LanguageLauncherBase.getTempEngine(), this.helpArg);
        this.helpPrinted |= this.printInstrumentOptions(LanguageLauncherBase.getTempEngine(), this.helpArg);
    }

    protected void printPolyglotVersions() {
        Engine engine = LanguageLauncherBase.getTempEngine();
        String mode = LanguageLauncherBase.isAOT() ? "Native" : "JVM";
        this.println(engine.getImplementationName() + " " + mode + " Polyglot Engine Version " + engine.getVersion());
        this.println("Java Version " + System.getProperty("java.version"));
        this.println("Java VM Version " + System.getProperty("java.vm.version"));
        Path graalVMHome = Engine.findHome();
        if (graalVMHome != null) {
            this.println("GraalVM Home " + graalVMHome);
        }
        this.printLanguages(engine, true);
        this.printInstruments(engine, true);
    }

    @Override
    protected OptionDescriptor findOptionDescriptor(String group, String key) {
        OptionDescriptors descriptors = null;
        switch (group) {
            case "engine": 
            case "compiler": {
                descriptors = LanguageLauncherBase.getTempEngine().getOptions();
                break;
            }
            default: {
                Engine engine = LanguageLauncherBase.getTempEngine();
                if (engine.getLanguages().containsKey(group)) {
                    descriptors = ((Language)engine.getLanguages().get(group)).getOptions();
                    break;
                }
                if (!engine.getInstruments().containsKey(group)) break;
                descriptors = ((Instrument)engine.getInstruments().get(group)).getOptions();
            }
        }
        if (descriptors == null) {
            return null;
        }
        return descriptors.get(key);
    }

    private boolean printEngineOptions(Engine engine, String optionPrefix) {
        Map<OptionCategory, List<Launcher.PrintableOption>> options = this.getCategories(engine.getOptions(), optionPrefix);
        if (options != null) {
            this.println(LanguageLauncherBase.optionsTitle("Engine", null));
            this.printCategory(options, OptionCategory.USER, "User options:");
            this.printCategory(options, OptionCategory.EXPERT, "Expert options:");
            this.printCategory(options, OptionCategory.INTERNAL, "Internal options:");
            return true;
        }
        return false;
    }

    private boolean printInstrumentOptions(Engine engine, String id) {
        HashMap<Instrument, Map<OptionCategory, List<Launcher.PrintableOption>>> instrumentsOptions = new HashMap<Instrument, Map<OptionCategory, List<Launcher.PrintableOption>>>();
        List<Instrument> instruments = LanguageLauncherBase.sortedInstruments(engine);
        for (Instrument instrument : instruments) {
            Map<OptionCategory, List<Launcher.PrintableOption>> categories;
            if (id != null && !instrument.getId().equals(id) || (categories = this.getCategories(instrument.getOptions())) == null) continue;
            instrumentsOptions.put(instrument, categories);
        }
        if (!instrumentsOptions.isEmpty()) {
            this.println(new String[0]);
            this.println(LanguageLauncherBase.optionsTitle("Tool", null));
            for (Instrument instrument : instruments) {
                Map options = (Map)instrumentsOptions.get(instrument);
                if (options == null) continue;
                this.println("");
                this.println("  " + instrument.getName() + LanguageLauncherBase.website(instrument) + ":");
                this.printCategory(options, OptionCategory.USER, "User options:");
                this.printCategory(options, OptionCategory.EXPERT, "Expert options:");
                this.printCategory(options, OptionCategory.INTERNAL, "Internal options:");
                this.println("");
                this.println("   Use --help:" + instrument.getId() + ":internal to also show internal options.");
            }
            return true;
        }
        return false;
    }

    private boolean printLanguageOptions(Engine engine, String id) {
        HashMap<Language, Map<OptionCategory, List<Launcher.PrintableOption>>> languagesOptions = new HashMap<Language, Map<OptionCategory, List<Launcher.PrintableOption>>>();
        List<Language> languages = LanguageLauncherBase.sortedLanguages(engine);
        for (Language language : languages) {
            Map<OptionCategory, List<Launcher.PrintableOption>> categories;
            if (id != null && !language.getId().equals(id) || (categories = this.getCategories(language.getOptions())) == null) continue;
            languagesOptions.put(language, categories);
        }
        if (!languagesOptions.isEmpty()) {
            this.println(new String[0]);
            this.println(LanguageLauncherBase.optionsTitle("Language", null));
            for (Language language : languages) {
                Map options = (Map)languagesOptions.get(language);
                if (options == null) continue;
                this.println("");
                this.println(LanguageLauncherBase.title(language));
                this.printCategory(options, OptionCategory.USER, "User options:");
                this.printCategory(options, OptionCategory.EXPERT, "Expert options:");
                this.printCategory(options, OptionCategory.INTERNAL, "Internal options:");
                this.println("");
                if (!((List)options.get(OptionCategory.INTERNAL)).isEmpty()) continue;
                this.println("   Use --help:" + language.getId() + ":internal to also show internal options.");
            }
            return true;
        }
        return false;
    }

    private Map<OptionCategory, List<Launcher.PrintableOption>> getCategories(OptionDescriptors options) {
        return this.getCategories(options, "all");
    }

    private Map<OptionCategory, List<Launcher.PrintableOption>> getCategories(OptionDescriptors options, String optionPrefix) {
        String optionPrefixDot = optionPrefix + ".";
        List<Launcher.PrintableOption> userOptions = LanguageLauncherBase.filterOptions(options, OptionCategory.USER, optionPrefixDot);
        List<Launcher.PrintableOption> expertOptions = LanguageLauncherBase.filterOptions(options, OptionCategory.EXPERT, optionPrefixDot);
        List internalOptions = this.helpInternal ? LanguageLauncherBase.filterOptions(options, OptionCategory.INTERNAL, optionPrefixDot) : Collections.emptyList();
        HashMap<OptionCategory, List<Launcher.PrintableOption>> categories = null;
        if (!(userOptions.isEmpty() && expertOptions.isEmpty() && internalOptions.isEmpty())) {
            categories = new HashMap<OptionCategory, List<Launcher.PrintableOption>>();
            categories.put(OptionCategory.USER, userOptions);
            categories.put(OptionCategory.EXPERT, expertOptions);
            categories.put(OptionCategory.INTERNAL, internalOptions);
        }
        return categories;
    }

    private void printCategory(Map<OptionCategory, List<Launcher.PrintableOption>> options, OptionCategory category, String title) {
        List<Launcher.PrintableOption> printableOptions = options.get(category);
        if (printableOptions != null && !printableOptions.isEmpty()) {
            this.println(new String[0]);
            this.printOptions(printableOptions, title, 3);
        }
    }

    private void printLanguages(Engine engine, boolean printWhenEmpty) {
        if (engine.getLanguages().isEmpty()) {
            if (printWhenEmpty) {
                this.println("  Installed Languages: none");
            }
        } else {
            this.println("  Installed Languages:");
            ArrayList<Language> languages = new ArrayList<Language>(engine.getLanguages().size());
            int nameLength = 0;
            for (Language language : engine.getLanguages().values()) {
                languages.add(language);
                nameLength = Integer.max(nameLength, language.getName().length());
            }
            languages.sort(Comparator.comparing(Language::getId));
            String langFormat = "    %-" + nameLength + "s%s version %s%n";
            for (Language language : languages) {
                String host = "";
                String version = language.getVersion();
                if (version == null || version.length() == 0) {
                    version = "";
                }
                System.out.printf(langFormat, language.getName().isEmpty() ? "Unnamed" : language.getName(), host, version);
            }
        }
    }

    private void printInstruments(Engine engine, boolean printWhenEmpty) {
        if (engine.getInstruments().isEmpty()) {
            if (printWhenEmpty) {
                this.println("  Installed Tools: none");
            }
        } else {
            this.println("  Installed Tools:");
            List<Instrument> instruments = LanguageLauncherBase.sortedInstruments(engine);
            int nameLength = 0;
            for (Instrument instrument : instruments) {
                nameLength = Integer.max(nameLength, instrument.getName().length());
            }
            String instrumentFormat = "    %-" + nameLength + "s version %s%n";
            for (Instrument instrument : instruments) {
                String version = instrument.getVersion();
                if (version == null || version.length() == 0) {
                    version = "";
                }
                System.out.printf(instrumentFormat, instrument.getName().isEmpty() ? instrument.getId() : instrument.getName(), version);
            }
        }
    }

    @Override
    protected void collectArguments(Set<String> options) {
        options.add("--help:languages");
        options.add("--help:tools");
        options.add("--version:graalvm");
        options.add("--show-version:graalvm");
        Engine engine = LanguageLauncherBase.getTempEngine();
        LanguageLauncherBase.addOptions(engine.getOptions(), options);
        for (Instrument instrument : engine.getInstruments().values()) {
            LanguageLauncherBase.addOptions(instrument.getOptions(), options);
        }
        String languageId = null;
        if (this instanceof AbstractLanguageLauncher) {
            languageId = ((AbstractLanguageLauncher)this).getLanguageId();
        }
        for (Language language : engine.getLanguages().values()) {
            if (language.getId().equals(languageId)) {
                for (OptionDescriptor descriptor : language.getOptions()) {
                    options.add("--" + descriptor.getName().substring(languageId.length() + 1));
                }
            }
            LanguageLauncherBase.addOptions(language.getOptions(), options);
        }
    }
}

