/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.maven.downloader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ProcessProperties;

class OptionProperties {
    static final String DEFAULT_RELATIVE_OUTPUT_DIR = "modules";
    static final String RELATIVE_OUTPUT_DIR = System.getProperty("org.graalvm.maven.downloader.relative_output_dir", "modules");
    static final String DEFAULT_VERSION = System.getProperty("org.graalvm.maven.downloader.default_version");
    static final String VERSION_PROP = "org.graalvm.maven.downloader.version";
    static final String DEFAULT_MAVEN_REPO = "https://repo1.maven.org/maven2/";
    static final String MAVEN_PROP = "org.graalvm.maven.downloader.repository";
    static final String DEFAULT_GROUP_ID = "org.graalvm.polyglot";

    OptionProperties() {
    }

    public static String getDefaultGroup() {
        return DEFAULT_GROUP_ID;
    }

    public static String getDefaultRepo() {
        String repo = System.getenv(MAVEN_PROP);
        if (repo == null) {
            return DEFAULT_MAVEN_REPO;
        }
        return repo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDefaultVersion() {
        String ver = System.getenv(VERSION_PROP);
        if (ver != null) return ver;
        if (DEFAULT_VERSION != null) {
            return DEFAULT_VERSION;
        }
        InputStream in = OptionProperties.class.getResourceAsStream("/META-INF/graalvm/org.graalvm.maven.downloader/version");
        if (in == null) return "not specified";
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String version = r.readLine();
            if (version == null) return "not specified";
            String string = version;
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "not specified";
    }

    public static String getExeName() {
        if (ImageInfo.inImageRuntimeCode() && ProcessProperties.getArgumentVectorBlockSize() > 0) {
            return ProcessProperties.getArgumentVectorProgramName();
        }
        return "maven downloader";
    }

    public static String getDefaultOutputDir() {
        if (ImageInfo.inImageRuntimeCode()) {
            String progName = ProcessProperties.getExecutableName();
            if (progName != null) {
                Path standaloneHome = Paths.get(progName, new String[0]).resolve("..").resolve("..");
                return standaloneHome.resolve(RELATIVE_OUTPUT_DIR).normalize().toString();
            }
        } else {
            Path standaloneHome;
            Path modules;
            Path javaHome;
            String javaHomeProperty = System.getProperty("java.home");
            if (javaHomeProperty != null && Files.isDirectory(javaHome = Paths.get(javaHomeProperty, new String[0]), new LinkOption[0]) && Files.exists(javaHome.resolve("lib").resolve(DEFAULT_RELATIVE_OUTPUT_DIR), new LinkOption[0]) && Files.isDirectory(modules = (standaloneHome = javaHome.resolve("..")).resolve(RELATIVE_OUTPUT_DIR).normalize(), new LinkOption[0])) {
                return modules.toString();
            }
        }
        return DEFAULT_RELATIVE_OUTPUT_DIR;
    }
}

