/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.maven.downloader;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.graalvm.maven.downloader.MVNDownloader;
import org.graalvm.maven.downloader.OptionProperties;
import org.xml.sax.SAXException;

public class Main {
    static final Logger LOGGER = Logger.getLogger(Main.class.getName());
    static final String LOGGING_PROP = "org.graalvm.maven.downloader.logLevel";

    static Arguments parseArguments(String ... args) {
        if (args.length == 0 || "--help".equals(args[0])) {
            Main.printHelp();
            System.exit(0);
        }
        Object repoUrl = null;
        String outputDir = null;
        String groupId = null;
        String artifactId = null;
        String version = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].length() < 2) {
                    Main.exitErr("Invalid argument: " + args[i]);
                }
                if (args.length - 1 == i) {
                    Main.exitErr("Expected argument value after: " + args[i]);
                }
                switch (args[i].charAt(1)) {
                    case 'r': {
                        repoUrl = args[i + 1];
                        break;
                    }
                    case 'o': {
                        outputDir = args[i + 1];
                        break;
                    }
                    case 'g': {
                        groupId = args[i + 1];
                        break;
                    }
                    case 'a': {
                        artifactId = args[i + 1];
                        break;
                    }
                    case 'v': {
                        version = args[i + 1];
                        break;
                    }
                    default: {
                        Main.exitErr("Invalid argument: " + args[i]);
                    }
                }
                ++i;
                continue;
            }
            if (args.length == 1) {
                artifactId = args[i];
                continue;
            }
            Main.exitErr("Invalid argument: " + args[i]);
        }
        if (repoUrl == null) {
            repoUrl = OptionProperties.getDefaultRepo();
        }
        if (!((String)repoUrl).endsWith("/")) {
            repoUrl = (String)repoUrl + "/";
        }
        if (outputDir == null) {
            outputDir = OptionProperties.getDefaultOutputDir();
        }
        if (groupId == null) {
            groupId = OptionProperties.getDefaultGroup();
        }
        if (artifactId == null) {
            Main.exitErr("Missing artifactId argument -a");
        }
        if (version == null) {
            version = OptionProperties.getDefaultVersion();
        }
        return new Arguments((String)repoUrl, outputDir, groupId, artifactId, version);
    }

    public static void main(String ... args) throws IOException, URISyntaxException, ClassCastException, ParserConfigurationException, SAXException, NoSuchAlgorithmException {
        Path outputPath;
        Arguments parsedArgs = Main.parseArguments(args);
        if (parsedArgs.outputDir == null) {
            Main.exitErr("Missing output directory argument -o");
        }
        if (!Files.exists(outputPath = Paths.get(parsedArgs.outputDir, new String[0]), new LinkOption[0])) {
            Files.createDirectory(outputPath, new FileAttribute[0]);
        } else if (!Files.isDirectory(outputPath, new LinkOption[0])) {
            Main.exitErr("Output folder has to be a directory.");
        }
        LOGGER.info(String.format("downloading %s:%s:%s from %s to %s", parsedArgs.groupId, parsedArgs.artifactId, parsedArgs.version, parsedArgs.repoUrl, parsedArgs.outputDir));
        new MVNDownloader(parsedArgs.outputDir).downloadDependencies(parsedArgs.repoUrl, parsedArgs.groupId, parsedArgs.artifactId, parsedArgs.version);
    }

    private static void exitErr(String err) {
        System.err.println(err + "\n");
        Main.printHelp();
        System.exit(1);
    }

    private static void printHelp() {
        System.out.println(String.format("Usage: %s [OPTION...]\n\nThis tool downloads maven artifacts and their dependencies to a single directory.\n\nThere are two operating modes.\n\nSpecifying everything needed for download and resolution:\n  -r maven-repository-url [default: %s]\n  -o output-directory [default: %s]\n  -g group-id [default: %s]\n  -v artifact-version [default: %s]\n  -a artifact-id\n\nPassing just a single argument:\n  This is treated as an artifact ID. The other options then use their defaults.\n\n\nEnvironment options:\n  'http_proxy' and 'https_proxy' are observed for proxy configuration\n  %s can be used to set the default version\n  %s is observed to configure the default maven repo\n  %s is observed to configure logging level\n", OptionProperties.getExeName(), OptionProperties.getDefaultRepo(), OptionProperties.getDefaultOutputDir(), OptionProperties.getDefaultGroup(), OptionProperties.getDefaultVersion(), "org.graalvm.maven.downloader.version", "org.graalvm.maven.downloader.repository", LOGGING_PROP));
    }

    static {
        String logLevel = System.getenv(LOGGING_PROP);
        if (logLevel != null) {
            Handler[] handlers;
            Level level = Level.parse(logLevel.toUpperCase(Locale.ROOT));
            LOGGER.setLevel(level);
            for (Handler h : handlers = Logger.getLogger("").getHandlers()) {
                h.setLevel(level);
            }
        }
    }

    record Arguments(String repoUrl, String outputDir, String groupId, String artifactId, String version) {
    }
}

