/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.maven.downloader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleFinder;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.graalvm.maven.downloader.Main;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MVNDownloader {
    private final Set<String> downloadedJars = new HashSet<String>();
    private final Set<String> existingModules;
    private final Path outputDir;
    private final Path downloadDir;

    public MVNDownloader(String outputDir) throws IOException {
        this.outputDir = Paths.get(outputDir, new String[0]);
        this.existingModules = MVNDownloader.getModuleNamesInDirectory(this.outputDir);
        this.downloadDir = Files.createTempDirectory(MVNDownloader.class.getSimpleName(), new FileAttribute[0]);
        Runtime.getRuntime().addShutdownHook(new Thread(new DeleteDownloadDir()));
    }

    private static Set<String> getModuleNamesInDirectory(Path dir) {
        return ModuleFinder.of(dir).findAll().stream().map(mr -> mr.descriptor().name()).collect(Collectors.toUnmodifiableSet());
    }

    public void downloadDependencies(String repoUrl, String groupId, String artifactId, String version) throws IOException, URISyntaxException, ParserConfigurationException, SAXException, ClassCastException, NoSuchAlgorithmException {
        String packaging;
        String artifactName = MVNDownloader.toMavenPath(groupId, artifactId, version, "pom");
        boolean mvnCentralFallback = !repoUrl.startsWith("https://repo1.maven.org/maven2/");
        byte[] bytes = MVNDownloader.downloadMavenFile(repoUrl, artifactName, mvnCentralFallback);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new ByteArrayInputStream(bytes));
        Element projectNode = (Element)document.getElementsByTagName("project").item(0);
        if (projectNode == null) {
            Main.LOGGER.severe(String.format("Malformed pom %s does not have <project> tag", artifactName));
            System.exit(1);
        }
        Main.LOGGER.fine(String.format("loaded model for %s", artifactName));
        Node packagingNode = projectNode.getElementsByTagName("packaging").item(0);
        String string = packaging = packagingNode == null ? "jar" : packagingNode.getTextContent();
        if (!packaging.equals("pom")) {
            artifactName = MVNDownloader.toMavenPath(groupId, artifactId, version, packaging);
            if (this.downloadedJars.contains(artifactName)) {
                Main.LOGGER.finer(String.format("skipped already downloaded artifact %s", artifactName));
                return;
            }
            bytes = MVNDownloader.downloadMavenFile(repoUrl, artifactName, mvnCentralFallback);
            Path tmpfile = MVNDownloader.store(this.downloadDir, groupId, artifactId, version, bytes, packaging);
            Set<String> definedModules = MVNDownloader.getModuleNamesInDirectory(this.downloadDir);
            if (definedModules.size() > 1) {
                Main.LOGGER.severe(String.format("Internal error: more than one module in temporary directory %s", this.downloadDir));
                System.exit(1);
            } else {
                if (definedModules.size() == 1 && this.existingModules.containsAll(definedModules)) {
                    Main.LOGGER.finer(String.format("skipped artifact %s, which defines module %s, because it matches an existing module in the output dir %s", artifactName, definedModules.toArray()[0], this.outputDir));
                    Files.delete(tmpfile);
                    return;
                }
                Files.move(tmpfile, this.outputDir.resolve(tmpfile.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
            this.downloadedJars.add(artifactName);
        }
        NodeList dependenciesNodes = document.getDocumentElement().getElementsByTagName("dependencies");
        for (int i = 0; i < dependenciesNodes.getLength(); ++i) {
            Element dependenciesNode = (Element)dependenciesNodes.item(i);
            NodeList dependencyNodes = dependenciesNode.getElementsByTagName("dependency");
            for (int j = 0; j < dependencyNodes.getLength(); ++j) {
                String scope;
                Element dependencyNode = (Element)dependencyNodes.item(j);
                Node gidNode = dependencyNode.getElementsByTagName("groupId").item(0);
                if (gidNode == null) {
                    Main.LOGGER.severe(String.format("Malformed pom %s, dependency does not have <groupId> tag", artifactName));
                    System.exit(1);
                }
                String gid = gidNode.getTextContent();
                Node aidNode = dependencyNode.getElementsByTagName("artifactId").item(0);
                if (aidNode == null) {
                    Main.LOGGER.severe(String.format("Malformed pom %s, dependency does not have <artifactId> tag", artifactName));
                    System.exit(1);
                }
                String aid = aidNode.getTextContent();
                Node versionNode = dependencyNode.getElementsByTagName("version").item(0);
                if (versionNode == null) {
                    Main.LOGGER.severe(String.format("missing version for dependency %s:%s in %s", gid, aid, artifactName));
                    System.exit(1);
                }
                String ver = versionNode.getTextContent();
                Node scopeNode = dependencyNode.getElementsByTagName("scope").item(0);
                if (scopeNode != null && ("test".equals(scope = scopeNode.getTextContent()) || "provided".equals(scope))) continue;
                this.downloadDependencies(repoUrl, gid, aid, ver);
            }
        }
    }

    private static byte[] downloadMavenFile(String repoUrl, String artefactName, boolean fallback) throws IOException, URISyntaxException {
        String url = repoUrl + artefactName;
        try {
            File file;
            if (url.startsWith("file:") && !(file = new File(new URI(url))).exists()) {
                throw new IOException(String.format("does not exist %s", url));
            }
            URL u = new URI(url).toURL();
            byte[] bytes = MVNDownloader.downloadFromServer(u);
            Main.LOGGER.info(String.format("downloaded file %s", url));
            return bytes;
        }
        catch (IOException ioe) {
            if (fallback) {
                Main.LOGGER.log(Level.WARNING, String.format("could not download maven file from %s, because of: %s. Falling back on %s", url, ioe, "https://repo1.maven.org/maven2/"));
                return MVNDownloader.downloadMavenFile("https://repo1.maven.org/maven2/", artefactName, false);
            }
            Main.LOGGER.log(Level.SEVERE, String.format("exception while downloading maven file from %s", url), ioe);
            throw ioe;
        }
        catch (URISyntaxException ex) {
            Main.LOGGER.log(Level.SEVERE, String.format("wrong url", url), ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] downloadFromServer(URL url) throws IOException {
        URLConnection conn = url.openConnection(MVNDownloader.getProxy());
        int code = 200;
        if (conn instanceof HttpURLConnection) {
            code = ((HttpURLConnection)conn).getResponseCode();
        }
        if (code != 200) {
            throw new IOException("Skipping download from " + String.valueOf(url) + " due to response code " + code);
        }
        try (InputStream is = conn.getInputStream();){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int read;
                byte[] buf = new byte[4096];
                while ((read = is.read(buf)) != -1) {
                    baos.write(buf, 0, read);
                }
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException ex) {
            throw new IOException("Cannot download: " + String.valueOf(url) + " due to: " + String.valueOf(ex), ex);
        }
    }

    private static Proxy getProxy() {
        int port;
        String httpProxy = MVNDownloader.getProxyVar("https_proxy");
        if (httpProxy == null || "".equals(httpProxy.trim())) {
            httpProxy = MVNDownloader.getProxyVar("http_proxy");
        }
        if (httpProxy == null || "".equals(httpProxy.trim())) {
            Main.LOGGER.info(String.format("using no proxy", new Object[0]));
            return Proxy.NO_PROXY;
        }
        int idx = (httpProxy = httpProxy.trim()).lastIndexOf(":");
        if (idx < 0 || idx > httpProxy.length() - 1) {
            Main.LOGGER.warning(String.format("http_proxy env variable has to be in format host:url, but was '%s'", httpProxy));
            return Proxy.NO_PROXY;
        }
        String host = httpProxy.substring(0, idx);
        try {
            port = Integer.parseInt(httpProxy.substring(idx + 1));
        }
        catch (NumberFormatException e) {
            Main.LOGGER.severe(String.format("can't parse port number in '%s'", httpProxy));
            throw e;
        }
        Main.LOGGER.info(String.format("using proxy '%s:%s'", host, port));
        if (host.startsWith("http://")) {
            host = host.substring("http://".length());
        } else if (host.startsWith("https://")) {
            host = host.substring("https://".length());
        }
        InetSocketAddress address = InetSocketAddress.createUnresolved(host, port);
        return new Proxy(Proxy.Type.HTTP, address);
    }

    private static String getProxyVar(String key) {
        String var = System.getenv(key);
        if (var == null) {
            var = System.getenv(key.toUpperCase(Locale.ROOT));
        }
        return var;
    }

    private static String toMavenPath(String groupId, String artifactId, String version, String extension) {
        return String.format("%s/%s/%s/%s", groupId.replace(".", "/"), artifactId, version, MVNDownloader.toArtifactFilename(artifactId, version, extension));
    }

    private static String toArtifactFilename(String artifactId, String version, String extension) {
        return String.format("%s-%s.%s", artifactId, version, extension);
    }

    private static Path store(Path dir, String groupId, String artifactId, String version, byte[] bytes, String extension) throws IOException {
        String fileName = String.format("%s-%s", groupId, MVNDownloader.toArtifactFilename(artifactId, version, extension));
        Path path = dir.resolve(fileName);
        Files.write(path, bytes, new OpenOption[0]);
        return path;
    }

    private final class DeleteDownloadDir
    implements Runnable {
        private DeleteDownloadDir() {
        }

        @Override
        public void run() {
            try {
                Files.deleteIfExists(MVNDownloader.this.downloadDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

