/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import org.graalvm.nativebridge.NativeIsolate;

public final class NativeIsolateThread {
    private static final int CLOSING_MASK = 1;
    private final NativeIsolate isolate;
    private final WeakReference<Thread> thread;
    private final AtomicInteger enteredCount;
    private final boolean nativeThread;
    final long isolateThread;
    private boolean executesShutDown;

    NativeIsolateThread(Thread thread, NativeIsolate isolate, boolean nativeThread, long isolateThreadId) {
        this.thread = new WeakReference<Thread>(thread);
        this.isolate = isolate;
        this.nativeThread = nativeThread;
        this.isolateThread = isolateThreadId;
        this.enteredCount = new AtomicInteger();
    }

    public long getIsolateThreadId() {
        assert (this.verifyThread());
        if (!this.isActive()) {
            throw new IllegalStateException("Isolate 0x" + Long.toHexString(this.isolate.getIsolateId()) + " is not entered.");
        }
        return this.isolateThread;
    }

    public NativeIsolate getIsolate() {
        return this.isolate;
    }

    public void leave() {
        assert (this.verifyThread());
        this.decrementAttached();
    }

    boolean enter() {
        assert (this.verifyThread());
        return this.incrementAttached();
    }

    boolean invalidate() {
        int numberOfAttached;
        boolean inactive;
        int newValue;
        int value;
        do {
            if ((value = this.enteredCount.get()) != -1) continue;
            return true;
        } while (!this.enteredCount.compareAndSet(value, newValue = (inactive = (numberOfAttached = value >>> 1) == 0) ? -1 : value | 1));
        return inactive;
    }

    boolean isActive() {
        if (this.executesShutDown) {
            return true;
        }
        int value = this.enteredCount.get();
        return value != -1 && value >>> 1 > 0;
    }

    boolean isNativeThread() {
        return this.nativeThread;
    }

    void setShutDownRequest(boolean shutDown) {
        this.executesShutDown = shutDown;
    }

    private boolean verifyThread() {
        assert (this.thread.get() == Thread.currentThread()) : String.format("NativeIsolateThread used by other thread. Expected thread %s, actual thread %s.", this.thread.get(), Thread.currentThread());
        return true;
    }

    private boolean incrementAttached() {
        int closing;
        int newValue;
        int value;
        do {
            if ((value = this.enteredCount.get()) != -1) continue;
            return this.executesShutDown;
        } while (!this.enteredCount.compareAndSet(value, newValue = (value >>> 1) + 1 << 1 | (closing = value & 1)));
        return true;
    }

    private void decrementAttached() {
        block3: {
            int numberOfAttached;
            int closing;
            boolean lastLeaving;
            int newValue;
            int value;
            do {
                if ((value = this.enteredCount.get()) == -1) {
                    if (this.executesShutDown) {
                        return;
                    }
                    throw new IllegalStateException("Isolate 0x" + Long.toHexString(this.isolate.getIsolateId()) + " was closed while being active.");
                }
                closing = value & 1;
                numberOfAttached = (value >>> 1) - 1;
            } while (!this.enteredCount.compareAndSet(value, newValue = (lastLeaving = closing == 1 && numberOfAttached == 0) ? -1 : numberOfAttached << 1 | closing));
            if (!lastLeaving) break block3;
            this.isolate.lastLeave();
        }
    }
}

