/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.tck;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.tck.DefaultResultVerifier;
import org.graalvm.polyglot.tck.IdentityFunctionResultVerifier;
import org.graalvm.polyglot.tck.Snippet;

public interface ResultVerifier
extends Consumer<SnippetRun> {
    @Override
    public void accept(SnippetRun var1) throws PolyglotException;

    public static ResultVerifier getDefaultResultVerifier() {
        return DefaultResultVerifier.INSTANCE;
    }

    public static ResultVerifier getIdentityFunctionDefaultResultVerifier() {
        return IdentityFunctionResultVerifier.INSTANCE;
    }

    public static final class SnippetRun {
        private final Snippet snippet;
        private final List<? extends Value> parameters;
        private final Value result;
        private final PolyglotException exception;

        private SnippetRun(Snippet snippet, List<? extends Value> parameters, Value result, PolyglotException exception) {
            this.snippet = snippet;
            this.parameters = parameters;
            this.result = result;
            this.exception = exception;
        }

        public List<? extends Value> getParameters() {
            return this.parameters;
        }

        public Value getResult() {
            return this.result;
        }

        public PolyglotException getException() {
            return this.exception;
        }

        Snippet getSnippet() {
            return this.snippet;
        }

        public static SnippetRun create(Snippet snippet, List<? extends Value> parameters, Value result) {
            Objects.requireNonNull(snippet, "Snippet has to be given.");
            Objects.requireNonNull(parameters, "Parameters has to be given.");
            Objects.requireNonNull(result, "Result has to be given.");
            return new SnippetRun(snippet, parameters, result, null);
        }

        public static SnippetRun create(Snippet snippet, List<? extends Value> parameters, PolyglotException exception) {
            return new SnippetRun(Objects.requireNonNull(snippet, "Snippet has to be given."), Objects.requireNonNull(parameters, "Parameters has to be given."), null, Objects.requireNonNull(exception, "Exception has to be given."));
        }
    }
}

