/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.tck;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.polyglot.Value;

public final class TypeDescriptor {
    private static final TypeDescriptor NOTYPE = new TypeDescriptor(new IntersectionImpl(Collections.emptySet()));
    public static final TypeDescriptor NULL = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.NULL));
    public static final TypeDescriptor BOOLEAN = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.BOOLEAN));
    public static final TypeDescriptor NUMBER = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.NUMBER));
    public static final TypeDescriptor STRING = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.STRING));
    public static final TypeDescriptor ITERABLE = new TypeDescriptor(new IterableImpl(null));
    public static final TypeDescriptor ITERATOR = new TypeDescriptor(new IteratorImpl(null));
    public static final TypeDescriptor HASH = new TypeDescriptor(new HashImpl(null, null));
    public static final TypeDescriptor OBJECT = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.OBJECT));
    public static final TypeDescriptor ARRAY;
    public static final TypeDescriptor HOST_OBJECT;
    public static final TypeDescriptor NATIVE_POINTER;
    public static final TypeDescriptor DATE;
    public static final TypeDescriptor TIME;
    public static final TypeDescriptor TIME_ZONE;
    public static final TypeDescriptor DURATION;
    public static final TypeDescriptor META_OBJECT;
    public static final TypeDescriptor EXCEPTION;
    public static final TypeDescriptor EXECUTABLE;
    public static final TypeDescriptor EXECUTABLE_ANY;
    public static final TypeDescriptor INSTANTIABLE;
    public static final TypeDescriptor INSTANTIABLE_ANY;
    public static final TypeDescriptor ANY;
    private static final TypeDescriptor[] PREDEFINED_TYPES;
    private final TypeDescriptorImpl impl;

    private TypeDescriptor(TypeDescriptorImpl impl) {
        Objects.requireNonNull(impl);
        this.impl = impl;
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != TypeDescriptor.class) {
            return false;
        }
        return this.impl.equals(((TypeDescriptor)obj).impl);
    }

    public String toString() {
        return this.impl.toString();
    }

    public boolean isAssignable(TypeDescriptor fromType) {
        return this.impl.isAssignable(this.impl, fromType.impl);
    }

    public boolean isUnion() {
        return this.impl.getClass() == UnionImpl.class;
    }

    public boolean isIntersection() {
        return this.impl.getClass() == IntersectionImpl.class;
    }

    public static TypeDescriptor union(TypeDescriptor ... types) {
        Objects.requireNonNull(types);
        HashSet typesSet = new HashSet();
        Collections.addAll(typesSet, types);
        switch (typesSet.size()) {
            case 0: {
                throw new IllegalArgumentException("No types.");
            }
            case 1: {
                return types[0];
            }
        }
        HashSet<TypeDescriptorImpl> typeImpls = new HashSet<TypeDescriptorImpl>();
        for (TypeDescriptor type : typesSet) {
            typeImpls.add(type.impl);
        }
        TypeDescriptorImpl unionImpl = TypeDescriptor.unionImpl(typeImpls);
        TypeDescriptor result = TypeDescriptor.isPredefined(unionImpl);
        return result != null ? result : new TypeDescriptor(unionImpl);
    }

    private static TypeDescriptorImpl unionImpl(Collection<? extends TypeDescriptorImpl> typeImpls) {
        HashSet<TypeDescriptorImpl> subtypes = new HashSet<TypeDescriptorImpl>();
        for (TypeDescriptorImpl typeDescriptorImpl : typeImpls) {
            if (typeDescriptorImpl.getClass() == UnionImpl.class) {
                subtypes.addAll(((UnionImpl)typeDescriptorImpl).types);
                continue;
            }
            subtypes.add(typeDescriptorImpl);
        }
        HashSet<TypeDescriptorImpl> impls = new HashSet<TypeDescriptorImpl>();
        HashMap<Class, List> hashMap = new HashMap<Class, List>();
        for (TypeDescriptorImpl part : subtypes) {
            if (TypeDescriptor.isArray(part)) {
                List arrays = hashMap.computeIfAbsent(ArrayImpl.class, k -> new ArrayList());
                arrays.add(part);
                continue;
            }
            if (part.getClass() == IterableImpl.class || part.getClass() == IteratorImpl.class || part.getClass() == HashImpl.class) {
                Class<?> clz = part.getClass();
                List parameterized = hashMap.computeIfAbsent(clz, k -> new ArrayList());
                parameterized.add(part);
                continue;
            }
            impls.add(part);
        }
        block6: for (List parameterizedTypes : hashMap.values()) {
            switch (parameterizedTypes.size()) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    impls.add((TypeDescriptorImpl)parameterizedTypes.get(0));
                    continue block6;
                }
            }
            ArrayList<Set<TypeDescriptorImpl>> typeParameters = new ArrayList<Set<TypeDescriptorImpl>>();
            BitSet seenWildCard = new BitSet();
            for (TypeDescriptorImpl type : parameterizedTypes) {
                ParameterizedTypeDescriptorImpl parameterizedType = TypeDescriptor.asParameterizedTypeImpl(type);
                for (int i = 0; i < parameterizedType.typeParameters.size(); ++i) {
                    Set<TypeDescriptorImpl> typeParametersAtIndex;
                    if (seenWildCard.get(i)) continue;
                    if (i < typeParameters.size()) {
                        typeParametersAtIndex = (Set)typeParameters.get(i);
                    } else {
                        typeParametersAtIndex = new HashSet();
                        typeParameters.add(typeParametersAtIndex);
                        assert (typeParametersAtIndex == typeParameters.get(i));
                    }
                    TypeDescriptorImpl typeParameterAtIndex = parameterizedType.typeParameters.get(i);
                    if (typeParameterAtIndex == null || TypeDescriptor.isAny(typeParameterAtIndex)) {
                        seenWildCard.set(i);
                        typeParametersAtIndex.clear();
                        typeParametersAtIndex.add(TypeDescriptor.ANY.impl);
                        continue;
                    }
                    typeParametersAtIndex.add(typeParameterAtIndex);
                }
            }
            ParameterizedTypeDescriptorImpl parameterizedType = TypeDescriptor.asParameterizedTypeImpl((TypeDescriptorImpl)parameterizedTypes.get(0));
            impls.add(parameterizedType.create(typeParameters.stream().map(tps -> TypeDescriptor.unionImpl(tps)).collect(Collectors.toList())));
        }
        return impls.size() == 1 ? (TypeDescriptorImpl)impls.iterator().next() : new UnionImpl(impls);
    }

    public static TypeDescriptor intersection(TypeDescriptor ... types) {
        Objects.requireNonNull(types);
        HashSet typesSet = new HashSet();
        Collections.addAll(typesSet, types);
        switch (typesSet.size()) {
            case 0: {
                return NOTYPE;
            }
            case 1: {
                return types[0];
            }
        }
        HashSet<TypeDescriptorImpl> typeImpls = new HashSet<TypeDescriptorImpl>();
        for (TypeDescriptor type : typesSet) {
            typeImpls.add(type.impl);
        }
        TypeDescriptorImpl intersectionImpl = TypeDescriptor.intersectionImpl(typeImpls);
        TypeDescriptor result = TypeDescriptor.isPredefined(intersectionImpl);
        return result != null ? result : new TypeDescriptor(intersectionImpl);
    }

    private static TypeDescriptorImpl intersectionImpl(Collection<? extends TypeDescriptorImpl> typeImpls) {
        HashSet<UnionImpl> unions = new HashSet<UnionImpl>();
        HashSet<TypeDescriptorImpl> nonUnionCompoments = new HashSet<TypeDescriptorImpl>();
        for (TypeDescriptorImpl typeDescriptorImpl : typeImpls) {
            if (typeDescriptorImpl.getClass() == UnionImpl.class) {
                unions.add((UnionImpl)typeDescriptorImpl);
                continue;
            }
            if (typeDescriptorImpl.getClass() == IntersectionImpl.class) {
                nonUnionCompoments.addAll(((IntersectionImpl)typeDescriptorImpl).types);
                continue;
            }
            nonUnionCompoments.add(typeDescriptorImpl);
        }
        HashSet dnfComponents = new HashSet();
        TypeDescriptorImpl[][] typeDescriptorImplArray = new TypeDescriptorImpl[unions.size()][];
        Iterator it = unions.iterator();
        int i = 0;
        while (it.hasNext()) {
            UnionImpl union = (UnionImpl)it.next();
            typeDescriptorImplArray[i] = union.types.toArray(new TypeDescriptorImpl[union.types.size()]);
            ++i;
        }
        TypeDescriptor.collectDNFComponents(typeDescriptorImplArray, nonUnionCompoments, new int[unions.size()], 0, dnfComponents);
        return dnfComponents.size() == 1 ? (TypeDescriptorImpl)dnfComponents.iterator().next() : TypeDescriptor.unionImpl(dnfComponents);
    }

    private static void collectDNFComponents(TypeDescriptorImpl[][] unionTypes, Collection<? extends TypeDescriptorImpl> tail, int[] indexes, int currentIndex, Collection<? super TypeDescriptorImpl> collector) {
        if (currentIndex == indexes.length) {
            HashSet<TypeDescriptorImpl> currentComponent = new HashSet<TypeDescriptorImpl>();
            BitSet wildCards = new BitSet();
            for (int i = 0; i < unionTypes.length; ++i) {
                TypeDescriptorImpl typeDescriptorImpl = unionTypes[i][indexes[i]];
                TypeDescriptor.findWildCards(wildCards, typeDescriptorImpl);
                currentComponent.add(typeDescriptorImpl);
            }
            for (TypeDescriptorImpl typeDescriptorImpl : tail) {
                TypeDescriptor.findWildCards(wildCards, typeDescriptorImpl);
                currentComponent.add(typeDescriptorImpl);
            }
            if (!wildCards.isEmpty()) {
                Iterator it = currentComponent.iterator();
                while (it.hasNext()) {
                    TypeDescriptorImpl typeDescriptorImpl = (TypeDescriptorImpl)it.next();
                    if (!(wildCards.get(0) && TypeDescriptor.isIncludedInWildCard(typeDescriptorImpl, TypeDescriptor.asArrayImpl(TypeDescriptor.ARRAY.impl)) || wildCards.get(1) && TypeDescriptor.isIncludedInWildCard(typeDescriptorImpl, TypeDescriptor.ITERABLE.impl) || wildCards.get(2) && TypeDescriptor.isIncludedInWildCard(typeDescriptorImpl, TypeDescriptor.ITERATOR.impl) || wildCards.get(3) && TypeDescriptor.isIncludedInWildCard(typeDescriptorImpl, TypeDescriptor.EXECUTABLE.impl) || wildCards.get(4) && TypeDescriptor.isIncludedInWildCard(typeDescriptorImpl, TypeDescriptor.INSTANTIABLE.impl)) && (!wildCards.get(5) || !TypeDescriptor.isIncludedInWildCard(typeDescriptorImpl, TypeDescriptor.HASH.impl))) continue;
                    it.remove();
                }
            }
            collector.add((TypeDescriptorImpl)(currentComponent.size() == 1 ? currentComponent.iterator().next() : new IntersectionImpl(currentComponent)));
        } else {
            int i = 0;
            while (i < unionTypes[currentIndex].length) {
                indexes[currentIndex] = i++;
                TypeDescriptor.collectDNFComponents(unionTypes, tail, indexes, currentIndex + 1, collector);
            }
        }
    }

    private static void findWildCards(BitSet wildcards, TypeDescriptorImpl component) {
        if (component.equals(TypeDescriptor.asArrayImpl(TypeDescriptor.ARRAY.impl))) {
            wildcards.set(0);
        } else if (component.equals(TypeDescriptor.ITERABLE.impl)) {
            wildcards.set(1);
        } else if (component.equals(TypeDescriptor.ITERATOR.impl)) {
            wildcards.set(2);
        } else if (component.equals(TypeDescriptor.EXECUTABLE.impl)) {
            wildcards.set(3);
        } else if (component.equals(TypeDescriptor.INSTANTIABLE.impl)) {
            wildcards.set(4);
        } else if (component.equals(TypeDescriptor.HASH.impl)) {
            wildcards.set(5);
        }
    }

    private static boolean isIncludedInWildCard(TypeDescriptorImpl typeDescriptor, TypeDescriptorImpl wildCard) {
        return typeDescriptor.getClass() == wildCard.getClass() && typeDescriptor != wildCard;
    }

    private static boolean isAny(TypeDescriptorImpl type) {
        return type.isAssignable(type, TypeDescriptor.ANY.impl);
    }

    private static boolean isArray(TypeDescriptorImpl type) {
        return TypeDescriptor.ARRAY.impl.isAssignable(TypeDescriptor.ARRAY.impl, type);
    }

    private static ArrayImpl asArrayImpl(TypeDescriptorImpl type) {
        if (!TypeDescriptor.isArray(type)) {
            throw new IllegalArgumentException("Non an array type " + type);
        }
        for (TypeDescriptorImpl part : ((IntersectionImpl)type).types) {
            if (!(part instanceof ArrayImpl)) continue;
            return (ArrayImpl)part;
        }
        throw new IllegalStateException("Missing array component " + type);
    }

    private static ParameterizedTypeDescriptorImpl asParameterizedTypeImpl(TypeDescriptorImpl type) {
        return TypeDescriptor.isArray(type) ? TypeDescriptor.asArrayImpl(type) : (ParameterizedTypeDescriptorImpl)type;
    }

    public TypeDescriptor subtract(TypeDescriptor toRemove) {
        TypeDescriptorImpl res = TypeDescriptor.subtractImpl(this.impl, toRemove.impl);
        TypeDescriptor result = TypeDescriptor.isPredefined(res);
        return result != null ? result : new TypeDescriptor(res);
    }

    private static TypeDescriptorImpl subtractImpl(TypeDescriptorImpl originalType, TypeDescriptorImpl toRemove) {
        if (CompositeTypeDescriptorImpl.class.isAssignableFrom(originalType.getClass())) {
            Set<TypeDescriptorImpl> originalTypes = ((CompositeTypeDescriptorImpl)originalType).types;
            Set<TypeDescriptorImpl> toRemoveTypes = originalType.getClass() == toRemove.getClass() ? ((CompositeTypeDescriptorImpl)toRemove).types : Collections.singleton(toRemove);
            return ((CompositeTypeDescriptorImpl)originalType).create(TypeDescriptor.subtractImpl(originalTypes, toRemoveTypes));
        }
        Set<TypeDescriptorImpl> reduced = TypeDescriptor.subtractImpl(Collections.singleton(originalType), Collections.singleton(toRemove));
        return reduced.isEmpty() ? TypeDescriptor.NOTYPE.impl : reduced.iterator().next();
    }

    private static Set<TypeDescriptorImpl> subtractImpl(Set<TypeDescriptorImpl> originalTypes, Set<TypeDescriptorImpl> toRemove) {
        HashSet<TypeDescriptorImpl> result = new HashSet<TypeDescriptorImpl>(originalTypes);
        HashSet<TypeDescriptorImpl> todo = new HashSet<TypeDescriptorImpl>(toRemove);
        Iterator it = todo.iterator();
        while (it.hasNext()) {
            if (!result.remove(it.next())) continue;
            it.remove();
        }
        if (todo.isEmpty()) {
            return result;
        }
        HashMap originalTypesByClz = new HashMap();
        for (TypeDescriptorImpl td : result) {
            originalTypesByClz.put(td.getClass(), td);
        }
        HashMap toRemoveByClz = new HashMap();
        for (TypeDescriptorImpl typeDescriptorImpl : todo) {
            toRemoveByClz.put(typeDescriptorImpl.getClass(), typeDescriptorImpl);
        }
        for (Map.Entry entry : toRemoveByClz.entrySet()) {
            TypeDescriptorImpl typeDescriptorToReduce = (TypeDescriptorImpl)originalTypesByClz.get(entry.getKey());
            if (typeDescriptorToReduce == null) continue;
            if (ParameterizedTypeDescriptorImpl.class.isAssignableFrom((Class)entry.getKey())) {
                result.remove(typeDescriptorToReduce);
                result.add(TypeDescriptor.subtractParameterized((ParameterizedTypeDescriptorImpl)typeDescriptorToReduce, (ParameterizedTypeDescriptorImpl)entry.getValue()));
                continue;
            }
            if (!CompositeTypeDescriptorImpl.class.isAssignableFrom((Class)entry.getKey())) continue;
            result.remove(typeDescriptorToReduce);
            result.add(TypeDescriptor.subtractComposite((CompositeTypeDescriptorImpl)typeDescriptorToReduce, (CompositeTypeDescriptorImpl)entry.getValue()));
        }
        return result;
    }

    private static TypeDescriptorImpl subtractParameterized(ParameterizedTypeDescriptorImpl originalType, ParameterizedTypeDescriptorImpl toRemove) {
        assert (originalType.typeParameters.size() == toRemove.typeParameters.size()) : "Incompatible parameterized types " + originalType + "," + toRemove;
        ArrayList<TypeDescriptorImpl> reducedTypeParameters = new ArrayList<TypeDescriptorImpl>();
        for (int i = 0; i < originalType.typeParameters.size(); ++i) {
            reducedTypeParameters.add(TypeDescriptor.subtractImpl(originalType.typeParameters.get(i), toRemove.typeParameters.get(i)));
        }
        return originalType.create(reducedTypeParameters);
    }

    private static TypeDescriptorImpl subtractComposite(CompositeTypeDescriptorImpl originalType, CompositeTypeDescriptorImpl toRemove) {
        Set<TypeDescriptorImpl> reduced = TypeDescriptor.subtractImpl(originalType.types, toRemove.types);
        return originalType.create(reduced);
    }

    public static TypeDescriptor array(TypeDescriptor componentType) {
        Objects.requireNonNull(componentType, "Component type must be non null");
        if (TypeDescriptor.isAny(componentType.impl)) {
            return ARRAY;
        }
        HashSet<TypeDescriptorImpl> types = new HashSet<TypeDescriptorImpl>();
        Collections.addAll(types, new ArrayImpl(componentType.impl), new IterableImpl(componentType.impl));
        return new TypeDescriptor(new IntersectionImpl(types));
    }

    public static TypeDescriptor iterable(TypeDescriptor componentType) {
        Objects.requireNonNull(componentType, "Component type must be non null");
        if (TypeDescriptor.isAny(componentType.impl)) {
            return ITERABLE;
        }
        return new TypeDescriptor(new IterableImpl(componentType.impl));
    }

    public static TypeDescriptor iterator(TypeDescriptor componentType) {
        Objects.requireNonNull(componentType, "Component type must be non null");
        if (TypeDescriptor.isAny(componentType.impl)) {
            return ITERATOR;
        }
        return new TypeDescriptor(new IteratorImpl(componentType.impl));
    }

    public static TypeDescriptor hash(TypeDescriptor keyType, TypeDescriptor valueType) {
        Objects.requireNonNull(keyType, "Key type must be non null");
        Objects.requireNonNull(valueType, "Value type must be non null");
        if (TypeDescriptor.isAny(keyType.impl) && TypeDescriptor.isAny(valueType.impl)) {
            return HASH;
        }
        return new TypeDescriptor(new HashImpl(keyType.impl, valueType.impl));
    }

    public static TypeDescriptor executable(TypeDescriptor returnType, TypeDescriptor ... parameterTypes) {
        return TypeDescriptor.executable(returnType, true, parameterTypes);
    }

    public static TypeDescriptor executable(TypeDescriptor returnType, boolean vararg, TypeDescriptor ... parameterTypes) {
        Objects.requireNonNull(returnType, "Return type cannot be null");
        Objects.requireNonNull(parameterTypes, "Parameter types cannot be null");
        if (TypeDescriptor.isAny(returnType.impl) && parameterTypes.length == 0 && vararg) {
            return EXECUTABLE;
        }
        ArrayList<TypeDescriptorImpl> paramTypeImpls = new ArrayList<TypeDescriptorImpl>(parameterTypes.length);
        for (TypeDescriptor td : parameterTypes) {
            Objects.requireNonNull(td, "Parameter types cannot contain null");
            paramTypeImpls.add(td.impl);
        }
        return new TypeDescriptor(new ExecutableImpl(ExecutableImpl.Kind.UNIT, TypeDescriptor.isAny(returnType.impl) ? null : returnType.impl, vararg, paramTypeImpls));
    }

    public static TypeDescriptor instantiable(TypeDescriptor instanceType, boolean vararg, TypeDescriptor ... parameterTypes) {
        Objects.requireNonNull(instanceType, "Instance type cannot be null");
        Objects.requireNonNull(parameterTypes, "Parameter types cannot be null");
        if (TypeDescriptor.isAny(instanceType.impl) && parameterTypes.length == 0 && vararg) {
            return INSTANTIABLE;
        }
        ArrayList<TypeDescriptorImpl> paramTypeImpls = new ArrayList<TypeDescriptorImpl>(parameterTypes.length);
        for (TypeDescriptor td : parameterTypes) {
            Objects.requireNonNull(td, "Parameter types cannot contain null");
            paramTypeImpls.add(td.impl);
        }
        return new TypeDescriptor(new InstantiableImpl(ExecutableImpl.Kind.UNIT, TypeDescriptor.isAny(instanceType.impl) ? null : instanceType.impl, vararg, paramTypeImpls));
    }

    public static TypeDescriptor forValue(Value value) {
        ArrayList<TypeDescriptor> descs = new ArrayList<TypeDescriptor>();
        if (value.isNull()) {
            descs.add(NULL);
        }
        if (value.isBoolean()) {
            descs.add(BOOLEAN);
        }
        if (value.isNumber()) {
            descs.add(NUMBER);
        }
        if (value.isString()) {
            descs.add(STRING);
        }
        if (value.isNativePointer()) {
            descs.add(NATIVE_POINTER);
        }
        if (value.isDate()) {
            descs.add(DATE);
        }
        if (value.isTime()) {
            descs.add(TIME);
        }
        if (value.isTimeZone()) {
            descs.add(TIME_ZONE);
        }
        if (value.isDuration()) {
            descs.add(DURATION);
        }
        if (value.isMetaObject()) {
            descs.add(META_OBJECT);
        }
        if (value.isException()) {
            descs.add(EXCEPTION);
        }
        if (value.hasArrayElements()) {
            descs.add(TypeDescriptor.array(TypeDescriptor.detectContentType(new ArrayValueIterator(value))));
        }
        if (value.hasMembers()) {
            descs.add(OBJECT);
        }
        if (value.isHostObject()) {
            descs.add(HOST_OBJECT);
        }
        if (value.canExecute()) {
            descs.add(EXECUTABLE);
        }
        if (value.canInstantiate()) {
            descs.add(INSTANTIABLE);
        }
        if (value.hasIterator()) {
            descs.add(TypeDescriptor.iterable(TypeDescriptor.detectContentType(new IteratorValueIterator(value.getIterator()))));
        }
        if (value.isIterator()) {
            descs.add(ITERATOR);
        }
        if (value.hasHashEntries()) {
            TypeDescriptor keyType = TypeDescriptor.detectContentType(new HashIterator(value, HashIterator.Kind.KEY));
            TypeDescriptor valueType = TypeDescriptor.detectContentType(new HashIterator(value, HashIterator.Kind.VALUE));
            descs.add(TypeDescriptor.hash(keyType, valueType));
        }
        switch (descs.size()) {
            case 1: {
                return (TypeDescriptor)descs.get(0);
            }
        }
        return TypeDescriptor.intersection(descs.toArray(new TypeDescriptor[descs.size()]));
    }

    private static TypeDescriptor detectContentType(Iterator<Value> content) {
        HashSet<TypeDescriptor> contentTypes = new HashSet<TypeDescriptor>();
        while (content.hasNext()) {
            TypeDescriptor contentType = TypeDescriptor.forValue(content.next());
            if (contentType == NULL) continue;
            contentTypes.add(contentType);
        }
        switch (contentTypes.size()) {
            case 0: {
                return TypeDescriptor.intersection(NOTYPE, NULL, BOOLEAN, NUMBER, STRING, HOST_OBJECT, NATIVE_POINTER, OBJECT, ARRAY, EXECUTABLE, INSTANTIABLE, ITERABLE, ITERATOR, DATE, TIME, TIME_ZONE, DURATION, META_OBJECT, EXCEPTION, HASH);
            }
            case 1: {
                return (TypeDescriptor)contentTypes.iterator().next();
            }
        }
        return TypeDescriptor.union(contentTypes.toArray(new TypeDescriptor[contentTypes.size()]));
    }

    private static TypeDescriptor isPredefined(TypeDescriptorImpl impl) {
        for (TypeDescriptor predef : PREDEFINED_TYPES) {
            if (!impl.equals(predef.impl)) continue;
            return predef;
        }
        return null;
    }

    static {
        HashSet<TypeDescriptorImpl> types = new HashSet<TypeDescriptorImpl>();
        Collections.addAll(types, new ArrayImpl(null), TypeDescriptor.ITERABLE.impl);
        ARRAY = new TypeDescriptor(new IntersectionImpl(types));
        HOST_OBJECT = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.HOST_OBJECT));
        NATIVE_POINTER = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.NATIVE_POINTER));
        DATE = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.DATE));
        TIME = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.TIME));
        TIME_ZONE = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.TIME_ZONE));
        DURATION = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.DURATION));
        META_OBJECT = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.META_OBJECT));
        EXCEPTION = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.EXCEPTION));
        EXECUTABLE = new TypeDescriptor(new ExecutableImpl(ExecutableImpl.Kind.BOTTOM, null, true, Collections.emptyList()));
        EXECUTABLE_ANY = new TypeDescriptor(new ExecutableImpl(ExecutableImpl.Kind.TOP, null, true, Collections.emptyList()));
        INSTANTIABLE = new TypeDescriptor(new InstantiableImpl(ExecutableImpl.Kind.BOTTOM, null, true, Collections.emptyList()));
        INSTANTIABLE_ANY = new TypeDescriptor(new InstantiableImpl(ExecutableImpl.Kind.TOP, null, true, Collections.emptyList()));
        ANY = new TypeDescriptor(new UnionImpl(new HashSet<TypeDescriptorImpl>(Arrays.asList(TypeDescriptor.NOTYPE.impl, TypeDescriptor.NULL.impl, TypeDescriptor.BOOLEAN.impl, TypeDescriptor.NUMBER.impl, TypeDescriptor.STRING.impl, TypeDescriptor.HOST_OBJECT.impl, TypeDescriptor.NATIVE_POINTER.impl, TypeDescriptor.OBJECT.impl, TypeDescriptor.ARRAY.impl, TypeDescriptor.EXECUTABLE_ANY.impl, TypeDescriptor.INSTANTIABLE_ANY.impl, TypeDescriptor.DATE.impl, TypeDescriptor.TIME.impl, TypeDescriptor.TIME_ZONE.impl, TypeDescriptor.DURATION.impl, TypeDescriptor.META_OBJECT.impl, TypeDescriptor.ITERABLE.impl, TypeDescriptor.ITERATOR.impl, TypeDescriptor.EXCEPTION.impl, TypeDescriptor.HASH.impl))));
        PREDEFINED_TYPES = new TypeDescriptor[]{NOTYPE, NULL, BOOLEAN, NUMBER, STRING, HOST_OBJECT, DATE, TIME, TIME_ZONE, DURATION, META_OBJECT, EXCEPTION, NATIVE_POINTER, OBJECT, ARRAY, EXECUTABLE, EXECUTABLE_ANY, INSTANTIABLE, ITERABLE, ITERATOR, HASH, INSTANTIABLE_ANY, ANY};
    }

    private static final class UnionImpl
    extends CompositeTypeDescriptorImpl {
        private UnionImpl(Set<TypeDescriptorImpl> types) {
            super(types);
        }

        @Override
        boolean isAssignable(TypeDescriptorImpl origType, TypeDescriptorImpl byType) {
            TypeDescriptorImpl other = this.other(origType, byType);
            Class<?> otherClz = other.getClass();
            if (otherClz == PrimitiveImpl.class || other instanceof ParameterizedTypeDescriptorImpl || other instanceof ExecutableImpl) {
                if (other == byType) {
                    for (TypeDescriptorImpl type : this.types) {
                        if (!type.isAssignable(type, other)) continue;
                        return true;
                    }
                }
                return false;
            }
            if (otherClz == IntersectionImpl.class) {
                if (other == byType) {
                    UnionImpl origUnion = (UnionImpl)origType;
                    for (TypeDescriptorImpl unionSubType : origUnion.types) {
                        if (!unionSubType.isAssignable(unionSubType, byType)) continue;
                        return true;
                    }
                    return false;
                }
                UnionImpl byUnion = (UnionImpl)byType;
                for (TypeDescriptorImpl unionSubType : byUnion.types) {
                    if (origType.isAssignable(origType, unionSubType)) continue;
                    return false;
                }
                return true;
            }
            if (otherClz == UnionImpl.class) {
                UnionImpl origUnion = (UnionImpl)origType;
                UnionImpl byUnion = (UnionImpl)byType;
                HashSet<TypeDescriptorImpl> copy = new HashSet<TypeDescriptorImpl>(byUnion.types.size());
                block3: for (TypeDescriptorImpl type : byUnion.types) {
                    if (origUnion.types.contains(type)) {
                        copy.add(type);
                        continue;
                    }
                    if (!(type instanceof ParameterizedTypeDescriptorImpl) && !(type instanceof ExecutableImpl) && type.getClass() != IntersectionImpl.class) continue;
                    for (TypeDescriptorImpl filteredType : origUnion.types) {
                        if (!filteredType.isAssignable(filteredType, type)) continue;
                        copy.add(type);
                        continue block3;
                    }
                }
                return byUnion.types.equals(copy);
            }
            return other.isAssignable(origType, byType);
        }

        @Override
        TypeDescriptorImpl create(Set<TypeDescriptorImpl> subTypes) {
            switch (subTypes.size()) {
                case 0: {
                    return TypeDescriptor.NOTYPE.impl;
                }
                case 1: {
                    return subTypes.iterator().next();
                }
            }
            HashSet<TypeDescriptorImpl> useSubTypes = new HashSet<TypeDescriptorImpl>();
            for (TypeDescriptorImpl subType : subTypes) {
                if (subType.getClass() == UnionImpl.class) {
                    useSubTypes.addAll(((UnionImpl)subType).types);
                    continue;
                }
                useSubTypes.add(subType);
            }
            return new UnionImpl(subTypes);
        }

        public int hashCode() {
            return this.types.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != UnionImpl.class) {
                return false;
            }
            return this.types.equals(((UnionImpl)obj).types);
        }

        public String toString() {
            return this.types.stream().map(Object::toString).collect(Collectors.joining(" | ", "[", "]"));
        }
    }

    private static final class IntersectionImpl
    extends CompositeTypeDescriptorImpl {
        IntersectionImpl(Set<TypeDescriptorImpl> types) {
            super(types);
        }

        @Override
        boolean isAssignable(TypeDescriptorImpl origType, TypeDescriptorImpl byType) {
            TypeDescriptorImpl other = this.other(origType, byType);
            Class<?> otherClz = other.getClass();
            if (otherClz == PrimitiveImpl.class || other instanceof ParameterizedTypeDescriptorImpl || other instanceof ExecutableImpl) {
                if (other == origType) {
                    for (TypeDescriptorImpl type : this.types) {
                        if (!other.isAssignable(other, type)) continue;
                        return true;
                    }
                    return false;
                }
                if (this.types.isEmpty()) {
                    return false;
                }
                for (TypeDescriptorImpl type : this.types) {
                    if (type.isAssignable(type, other)) continue;
                    return false;
                }
                return true;
            }
            if (otherClz == IntersectionImpl.class) {
                IntersectionImpl origIntersection = (IntersectionImpl)origType;
                IntersectionImpl byIntersection = (IntersectionImpl)byType;
                if (origIntersection.types.isEmpty()) {
                    return byIntersection.types.isEmpty();
                }
                for (TypeDescriptorImpl subType : origIntersection.types) {
                    boolean included;
                    if (byIntersection.types.contains(subType)) continue;
                    if (subType instanceof ParameterizedTypeDescriptorImpl) {
                        included = false;
                        for (TypeDescriptorImpl bySubType : byIntersection.types) {
                            if (!(bySubType instanceof ParameterizedTypeDescriptorImpl) || !subType.isAssignable(subType, bySubType)) continue;
                            included = true;
                            break;
                        }
                        if (included) continue;
                        return false;
                    }
                    if (subType instanceof ExecutableImpl) {
                        included = false;
                        for (TypeDescriptorImpl bySubType : byIntersection.types) {
                            if (!(bySubType instanceof ExecutableImpl) || !subType.isAssignable(subType, bySubType)) continue;
                            included = true;
                            break;
                        }
                        if (included) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return other.isAssignable(origType, byType);
        }

        @Override
        TypeDescriptorImpl create(Set<TypeDescriptorImpl> subTypes) {
            switch (subTypes.size()) {
                case 0: {
                    return TypeDescriptor.NOTYPE.impl;
                }
                case 1: {
                    return subTypes.iterator().next();
                }
            }
            HashSet<TypeDescriptorImpl> useSubTypes = new HashSet<TypeDescriptorImpl>();
            for (TypeDescriptorImpl subType : subTypes) {
                if (subType.getClass() == IntersectionImpl.class) {
                    useSubTypes.addAll(((IntersectionImpl)subType).types);
                    continue;
                }
                useSubTypes.add(subType);
            }
            return new IntersectionImpl(useSubTypes);
        }

        public int hashCode() {
            return this.types.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != IntersectionImpl.class) {
                return false;
            }
            return this.types.equals(((IntersectionImpl)obj).types);
        }

        public String toString() {
            return this.types.isEmpty() ? "<none>" : this.types.stream().map(Object::toString).collect(Collectors.joining(" & ", "[", "]"));
        }
    }

    private static abstract class CompositeTypeDescriptorImpl
    extends TypeDescriptorImpl {
        final Set<TypeDescriptorImpl> types;

        CompositeTypeDescriptorImpl(Set<TypeDescriptorImpl> types) {
            this.types = Collections.unmodifiableSet(types);
        }

        abstract TypeDescriptorImpl create(Set<TypeDescriptorImpl> var1);
    }

    private static final class HashImpl
    extends ParameterizedTypeDescriptorImpl {
        HashImpl(TypeDescriptorImpl keyType, TypeDescriptorImpl valueType) {
            super(Arrays.asList(keyType, valueType), Arrays.asList(ArrayImpl.class, IterableImpl.class, IteratorImpl.class));
        }

        @Override
        String getName() {
            return "Hash";
        }

        @Override
        TypeDescriptorImpl create(List<TypeDescriptorImpl> typeParams) {
            if (typeParams.size() != 2) {
                throw new IllegalArgumentException("Hash has two type parameters, given: " + typeParams);
            }
            return TypeDescriptor.isAny(typeParams.get(0)) && TypeDescriptor.isAny(typeParams.get(1)) ? TypeDescriptor.HASH.impl : TypeDescriptor.hash((TypeDescriptor)new TypeDescriptor((TypeDescriptorImpl)typeParams.get((int)0)), (TypeDescriptor)new TypeDescriptor((TypeDescriptorImpl)typeParams.get((int)1))).impl;
        }
    }

    private static final class IteratorImpl
    extends ParameterizedTypeDescriptorImpl {
        IteratorImpl(TypeDescriptorImpl contentType) {
            super(contentType, Arrays.asList(ArrayImpl.class, IterableImpl.class));
        }

        @Override
        String getName() {
            return "Iterator";
        }

        @Override
        TypeDescriptorImpl create(List<TypeDescriptorImpl> typeParams) {
            if (typeParams.size() != 1) {
                throw new IllegalArgumentException("Iterator has single type parameter, given: " + typeParams);
            }
            return TypeDescriptor.isAny(typeParams.get(0)) ? TypeDescriptor.ITERATOR.impl : TypeDescriptor.iterator((TypeDescriptor)new TypeDescriptor((TypeDescriptorImpl)typeParams.get((int)0))).impl;
        }
    }

    private static final class IterableImpl
    extends ParameterizedTypeDescriptorImpl {
        IterableImpl(TypeDescriptorImpl contentType) {
            super(contentType, Collections.singleton(ArrayImpl.class));
        }

        @Override
        String getName() {
            return "Iterable";
        }

        @Override
        TypeDescriptorImpl create(List<TypeDescriptorImpl> typeParams) {
            if (typeParams.size() != 1) {
                throw new IllegalArgumentException("Iterable has single type parameter, given: " + typeParams);
            }
            return TypeDescriptor.isAny(typeParams.get(0)) ? TypeDescriptor.ITERABLE.impl : TypeDescriptor.iterable((TypeDescriptor)new TypeDescriptor((TypeDescriptorImpl)typeParams.get((int)0))).impl;
        }
    }

    private static final class ArrayImpl
    extends ParameterizedTypeDescriptorImpl {
        ArrayImpl(TypeDescriptorImpl contentType) {
            super(contentType, Collections.emptySet());
        }

        @Override
        String getName() {
            return "Array";
        }

        @Override
        TypeDescriptorImpl create(List<TypeDescriptorImpl> typeParams) {
            if (typeParams.size() != 1) {
                throw new IllegalArgumentException("Array has single type parameter, given: " + typeParams);
            }
            return TypeDescriptor.isAny(typeParams.get(0)) ? TypeDescriptor.ARRAY.impl : TypeDescriptor.array((TypeDescriptor)new TypeDescriptor((TypeDescriptorImpl)typeParams.get((int)0))).impl;
        }
    }

    private static abstract class ParameterizedTypeDescriptorImpl
    extends TypeDescriptorImpl {
        final List<? extends TypeDescriptorImpl> typeParameters;
        private final Set<Class<? extends TypeDescriptorImpl>> exclude;

        ParameterizedTypeDescriptorImpl(TypeDescriptorImpl typeParameter, Collection<Class<? extends ParameterizedTypeDescriptorImpl>> exclude) {
            this(Collections.singletonList(typeParameter), exclude);
        }

        ParameterizedTypeDescriptorImpl(List<? extends TypeDescriptorImpl> typeParameters, Collection<Class<? extends ParameterizedTypeDescriptorImpl>> exclude) {
            this.typeParameters = typeParameters;
            this.exclude = new HashSet<Class<? extends TypeDescriptorImpl>>();
            Collections.addAll(this.exclude, PrimitiveImpl.class, ExecutableImpl.class, InstantiableImpl.class);
            this.exclude.addAll(exclude);
        }

        abstract String getName();

        abstract TypeDescriptorImpl create(List<TypeDescriptorImpl> var1);

        public final int hashCode() {
            return this.typeParameters.hashCode();
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.typeParameters.equals(((ParameterizedTypeDescriptorImpl)obj).typeParameters);
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder(this.getName());
            sb.append("<");
            boolean first = true;
            for (TypeDescriptorImpl typeDescriptorImpl : this.typeParameters) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                if (typeDescriptorImpl == null) {
                    sb.append("<any>");
                    continue;
                }
                sb.append(typeDescriptorImpl.toString());
            }
            sb.append(">");
            return sb.toString();
        }

        @Override
        final boolean isAssignable(TypeDescriptorImpl origType, TypeDescriptorImpl byType) {
            TypeDescriptorImpl other = this.other(origType, byType);
            Class<?> otherClz = other.getClass();
            if (this.exclude.contains(otherClz)) {
                return false;
            }
            if (otherClz == this.getClass()) {
                ParameterizedTypeDescriptorImpl origParameterizedType = (ParameterizedTypeDescriptorImpl)origType;
                ParameterizedTypeDescriptorImpl byParameterizedType = (ParameterizedTypeDescriptorImpl)byType;
                assert (origParameterizedType.typeParameters.size() == byParameterizedType.typeParameters.size());
                for (int i = 0; i < origParameterizedType.typeParameters.size(); ++i) {
                    TypeDescriptorImpl byContentType;
                    TypeDescriptorImpl origContentType = ParameterizedTypeDescriptorImpl.resolveContentType(origParameterizedType.typeParameters.get(i));
                    if (origContentType.isAssignable(origContentType, byContentType = ParameterizedTypeDescriptorImpl.resolveContentType(byParameterizedType.typeParameters.get(i)))) continue;
                    return false;
                }
                return true;
            }
            return other.isAssignable(origType, byType);
        }

        static TypeDescriptorImpl resolveContentType(TypeDescriptorImpl type) {
            return type != null ? type : TypeDescriptor.ANY.impl;
        }
    }

    private static final class InstantiableImpl
    extends ExecutableImpl {
        InstantiableImpl(ExecutableImpl.Kind kind, TypeDescriptorImpl instanceType, boolean vararg, List<? extends TypeDescriptorImpl> paramTypes) {
            super(kind, instanceType, vararg, paramTypes);
        }

        @Override
        boolean isAssignable(TypeDescriptorImpl origType, TypeDescriptorImpl byType) {
            TypeDescriptorImpl other = this.other(origType, byType);
            Class<?> otherClz = other.getClass();
            if (otherClz == PrimitiveImpl.class || otherClz == ExecutableImpl.class) {
                return false;
            }
            return super.isAssignable(origType, byType);
        }

        @Override
        String getName() {
            return "Instantiable";
        }
    }

    private static class ExecutableImpl
    extends TypeDescriptorImpl {
        private final Kind kind;
        private final TypeDescriptorImpl retType;
        private final boolean vararg;
        private final List<? extends TypeDescriptorImpl> paramTypes;

        ExecutableImpl(Kind kind, TypeDescriptorImpl retType, boolean vararg, List<? extends TypeDescriptorImpl> paramTypes) {
            assert (kind != null);
            assert (paramTypes != null);
            assert (kind == Kind.UNIT || retType == null && paramTypes.isEmpty());
            this.kind = kind;
            this.retType = retType;
            this.vararg = vararg;
            this.paramTypes = paramTypes;
        }

        @Override
        boolean isAssignable(TypeDescriptorImpl origType, TypeDescriptorImpl byType) {
            TypeDescriptorImpl other = this.other(origType, byType);
            Class<?> otherClz = other.getClass();
            if (otherClz == PrimitiveImpl.class) {
                return false;
            }
            if (otherClz == this.getClass()) {
                ExecutableImpl origExec = (ExecutableImpl)origType;
                ExecutableImpl byExec = (ExecutableImpl)byType;
                if (origExec.kind == Kind.TOP) {
                    return true;
                }
                if (byExec.kind == Kind.TOP) {
                    return false;
                }
                if (!origExec.resolveRetType().isAssignable(origExec.resolveRetType(), byExec.resolveRetType())) {
                    return false;
                }
                if (origExec.paramTypes.size() < byExec.paramTypes.size()) {
                    return false;
                }
                if (!byExec.vararg && origExec.paramTypes.size() != byExec.paramTypes.size()) {
                    return false;
                }
                for (int i = 0; i < byExec.paramTypes.size(); ++i) {
                    TypeDescriptorImpl pt = origExec.paramTypes.get(i);
                    TypeDescriptorImpl opt = byExec.paramTypes.get(i);
                    if (opt.isAssignable(opt, pt)) continue;
                    return false;
                }
                return true;
            }
            return other.isAssignable(origType, byType);
        }

        public int hashCode() {
            int res = 17;
            res = res * 31 + (this.vararg ? 1 : 0);
            res = res * 31 + this.kind.hashCode();
            res = res * 31 + (this.retType == null ? 0 : this.retType.hashCode());
            for (TypeDescriptorImpl typeDescriptorImpl : this.paramTypes) {
                res = res * 31 + typeDescriptorImpl.hashCode();
            }
            return res;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ExecutableImpl other = (ExecutableImpl)obj;
            return this.vararg == other.vararg && this.kind == other.kind && Objects.equals(this.retType, other.retType) && this.paramTypes.equals(other.paramTypes);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getName()).append("(");
            switch (this.kind) {
                case TOP: {
                    sb.append("? extends");
                    break;
                }
                case BOTTOM: {
                    sb.append("? super");
                    break;
                }
                case UNIT: {
                    boolean first = true;
                    for (TypeDescriptorImpl typeDescriptorImpl : this.paramTypes) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append(typeDescriptorImpl);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown kind: " + this.kind);
                }
            }
            if (this.vararg) {
                sb.append(", *");
            }
            sb.append("):");
            sb.append(this.retType == null ? "<any>" : this.retType);
            return sb.toString();
        }

        String getName() {
            return "Executable";
        }

        private TypeDescriptorImpl resolveRetType() {
            return this.retType != null ? this.retType : TypeDescriptor.ANY.impl;
        }

        static enum Kind {
            TOP,
            BOTTOM,
            UNIT;

        }
    }

    private static final class PrimitiveImpl
    extends TypeDescriptorImpl {
        private final PrimitiveKind kind;

        PrimitiveImpl(PrimitiveKind kind) {
            Objects.requireNonNull(kind);
            this.kind = kind;
        }

        @Override
        boolean isAssignable(TypeDescriptorImpl origType, TypeDescriptorImpl byType) {
            TypeDescriptorImpl other = this.other(origType, byType);
            if (other.getClass() == PrimitiveImpl.class) {
                return this.kind == ((PrimitiveImpl)other).kind;
            }
            return other.isAssignable(origType, byType);
        }

        public int hashCode() {
            return this.kind.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != PrimitiveImpl.class) {
                return false;
            }
            return this.kind == ((PrimitiveImpl)obj).kind;
        }

        public String toString() {
            return this.kind.getDisplayName();
        }
    }

    private static abstract class TypeDescriptorImpl {
        private TypeDescriptorImpl() {
        }

        abstract boolean isAssignable(TypeDescriptorImpl var1, TypeDescriptorImpl var2);

        TypeDescriptorImpl other(TypeDescriptorImpl td1, TypeDescriptorImpl td2) {
            if (td1 == this) {
                return td2;
            }
            if (td2 == this) {
                return td1;
            }
            throw new IllegalArgumentException();
        }
    }

    private static enum PrimitiveKind {
        NULL("null"),
        BOOLEAN("boolean"),
        NUMBER("number"),
        STRING("string"),
        HOST_OBJECT("hostObject"),
        NATIVE_POINTER("nativePointer"),
        DATE("date"),
        TIME("time"),
        TIME_ZONE("timeZone"),
        DURATION("duration"),
        META_OBJECT("metaObject"),
        OBJECT("object"),
        EXCEPTION("exception");

        private final String displayName;

        private PrimitiveKind(String displayName) {
            this.displayName = displayName;
        }

        String getDisplayName() {
            return this.displayName;
        }
    }

    private static final class HashIterator
    extends IteratorValueIterator {
        private final Kind kind;

        HashIterator(Value hash, Kind kind) {
            super(hash.getHashEntriesIterator());
            this.kind = kind;
        }

        @Override
        protected Value map(Value value) {
            if (value.hasArrayElements()) {
                return value.getArrayElement(this.kind.index);
            }
            throw new AssertionError((Object)"Must have array elements.");
        }

        static enum Kind {
            KEY(0L),
            VALUE(1L);

            private final long index;

            private Kind(long index) {
                this.index = index;
            }
        }
    }

    private static final class ArrayValueIterator
    implements Iterator<Value> {
        private final Value arrayValue;
        private int index;

        ArrayValueIterator(Value arrayValue) {
            assert (arrayValue.hasArrayElements());
            this.arrayValue = arrayValue;
        }

        @Override
        public boolean hasNext() {
            return (long)this.index < this.arrayValue.getArraySize();
        }

        @Override
        public Value next() {
            try {
                return this.arrayValue.getArrayElement((long)this.index++);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }

    private static class IteratorValueIterator
    implements Iterator<Value> {
        private final Value iteratorValue;

        IteratorValueIterator(Value iterableValue) {
            assert (iterableValue.isIterator());
            this.iteratorValue = iterableValue;
        }

        @Override
        public boolean hasNext() {
            return this.iteratorValue.hasIteratorNextElement();
        }

        @Override
        public Value next() {
            return this.map(this.iteratorValue.getIteratorNextElement());
        }

        protected Value map(Value value) {
            return value;
        }
    }
}

