/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.org.jcodings.provider;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TranscodingErrorHandler;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.provider.JCodingsProvider;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.Function;
import org.graalvm.shadowed.org.jcodings.Encoding;
import org.graalvm.shadowed.org.jcodings.EncodingDB;
import org.graalvm.shadowed.org.jcodings.Ptr;
import org.graalvm.shadowed.org.jcodings.transcode.EConv;
import org.graalvm.shadowed.org.jcodings.transcode.EConvResult;
import org.graalvm.shadowed.org.jcodings.transcode.TranscoderDB;
import org.graalvm.shadowed.org.jcodings.util.CaseInsensitiveBytesHash;

public final class JCodingsProviderImpl
implements JCodingsProvider {
    private static final int MAX_BYTE_ARRAY_LENGTH = 0x7FFFFFF7;

    public JCodingsProvider.Encoding get(String encodingName) {
        return new EncodingWrapper(encodingName);
    }

    private static EConv getEconvTranscoder(JCodingsProvider.Encoding jCodingSrc, JCodingsProvider.Encoding jCodingDst, boolean customErrorHandler) {
        CompilerAsserts.neverPartOfCompilation();
        return TranscoderDB.open(jCodingSrc.getName(), jCodingDst.getName(), customErrorHandler ? 0 : 34);
    }

    private static void econvSetReplacement(JCodingsProvider.Encoding jCodingDst, EConv econv, byte[] replacement) {
        CompilerAsserts.neverPartOfCompilation();
        econv.setReplacement(replacement, 0, replacement.length, jCodingDst.getName());
    }

    private static EConvResult econvConvert(byte[] arrayA, byte[] buffer, EConv econv, Ptr srcPtr, Ptr dstPtr, int inStop) {
        CompilerAsserts.neverPartOfCompilation();
        return econv.convert(arrayA, srcPtr, inStop, buffer, dstPtr, buffer.length, 0);
    }

    private static void econvInsertOutput(EConv econv, byte[] replacementBytes, JCodingsProvider.Encoding jCodingDst) {
        CompilerAsserts.neverPartOfCompilation();
        econv.insertOutput(replacementBytes, 0, replacementBytes.length, jCodingDst.getName());
    }

    @CompilerDirectives.TruffleBoundary
    public JCodingsProvider.TranscodeResult transcode(AbstractTruffleString a, int codePointLengthA, int byteArrayOffset, int byteLength, TruffleString.Encoding targetEncoding, JCodingsProvider.Encoding jCodingSrc, JCodingsProvider.Encoding jCodingDst, byte[] builtinReplacement, TranscodingErrorHandler errorHandler, Function<AbstractTruffleString, byte[]> asBytesMaterializeNative, Function<AbstractTruffleString, JCodingsProvider.Encoding> getBytesEncoding) {
        boolean isBuiltinErrorHandler = errorHandler == TranscodingErrorHandler.DEFAULT || errorHandler == TranscodingErrorHandler.DEFAULT_KEEP_SURROGATES_IN_UTF8;
        byte[] buffer = new byte[(int)Math.min(0x7FFFFFF7L, (long)codePointLengthA * (long)jCodingDst.maxLength())];
        int length = 0;
        boolean undefinedConversion = false;
        EConv econv = JCodingsProviderImpl.getEconvTranscoder(jCodingSrc, jCodingDst, !isBuiltinErrorHandler);
        if (econv == null) {
            undefinedConversion = true;
            int replacementCodepoint = builtinReplacement.length == 1 ? 63 : 65533;
            for (int i = 0; i < codePointLengthA; ++i) {
                int ret = jCodingDst.codeToMbc(replacementCodepoint, buffer, length);
                assert (ret > 0);
                length += ret;
            }
        } else {
            Ptr srcPtr = new Ptr();
            Ptr dstPtr = new Ptr();
            srcPtr.p = byteArrayOffset;
            dstPtr.p = 0;
            int inStop = byteArrayOffset + byteLength;
            byte[] bytes = asBytesMaterializeNative.apply(a);
            EConvResult result = JCodingsProviderImpl.econvConvert(bytes, buffer, econv, srcPtr, dstPtr, inStop);
            while (!result.isFinished()) {
                if (result.isDestinationBufferFull()) {
                    if (buffer.length == 0x7FFFFFF7) {
                        throw new OutOfMemoryError();
                    }
                    buffer = Arrays.copyOf(buffer, (int)Math.min(0x7FFFFFF7L, (long)buffer.length << 1));
                } else if (result.isUndefinedConversion() || result.isInvalidByteSequence() || result.isIncompleteInput()) {
                    undefinedConversion = true;
                    if (isBuiltinErrorHandler) {
                        JCodingsProviderImpl.econvSetReplacement(jCodingDst, econv, builtinReplacement);
                    } else {
                        TruffleString.Encoding errorEncoding;
                        int errorBytesLength;
                        int errorBytesP;
                        byte[] errorBytes = econv.lastError.getErrorBytes();
                        TruffleString errorString = TruffleString.fromByteArrayUncached((byte[])errorBytes, (int)(errorBytesP = econv.lastError.getErrorBytesP()), (int)(errorBytesLength = econv.lastError.getErrorBytesLength()), (TruffleString.Encoding)(errorEncoding = TruffleString.Encoding.fromJCodingName((String)JCodingsProviderImpl.stringFromLatin1Bytes(econv.lastError.getErrorTranscoding().transcoder.getSource()))), (boolean)false);
                        TranscodingErrorHandler.ReplacementString customReplacement = errorHandler.apply((AbstractTruffleString)errorString, 0, errorBytesLength, errorEncoding, targetEncoding);
                        if (customReplacement.byteLength() >= 0) {
                            throw new UnsupportedOperationException("Custom replacement region sizes are not supported in JCodings-backed encodings");
                        }
                        TruffleString replacementString = customReplacement.replacement();
                        byte[] replacementBytes = asBytesMaterializeNative.apply((AbstractTruffleString)replacementString);
                        JCodingsProvider.Encoding replacementEnc = getBytesEncoding.apply((AbstractTruffleString)replacementString);
                        JCodingsProviderImpl.econvInsertOutput(econv, replacementBytes, replacementEnc);
                    }
                } else {
                    throw CompilerDirectives.shouldNotReachHere();
                }
                result = JCodingsProviderImpl.econvConvert(bytes, buffer, econv, srcPtr, dstPtr, inStop);
            }
            length = dstPtr.p;
        }
        return new JCodingsProvider.TranscodeResult(buffer, length, undefinedConversion);
    }

    private static String stringFromLatin1Bytes(byte[] source) {
        return new String(source, StandardCharsets.ISO_8859_1);
    }

    private static final class EncodingWrapper
    implements JCodingsProvider.Encoding {
        private final Encoding encoding;

        private EncodingWrapper(String jcodingsName) {
            this.encoding = Lazy.load(jcodingsName);
        }

        public String getCharsetName() {
            return this.encoding.getCharsetName();
        }

        public byte[] getName() {
            return this.encoding.getName();
        }

        public int minLength() {
            return this.encoding.minLength();
        }

        public int maxLength() {
            return this.encoding.maxLength();
        }

        public boolean isUnicode() {
            return this.encoding.isUnicode();
        }

        public boolean isSingleByte() {
            return this.encoding.isSingleByte();
        }

        public boolean isFixedWidth() {
            return this.encoding.isFixedWidth();
        }

        public int length(byte[] array, int index, int arrayLength) {
            return this.encoding.length(array, index, arrayLength);
        }

        public int codeToMbcLength(int codepoint) {
            return this.encoding.codeToMbcLength(codepoint);
        }

        public int codeToMbc(int codepoint, byte[] array, int index) {
            return this.encoding.codeToMbc(codepoint, array, index);
        }

        public int mbcToCode(byte[] array, int index, int arrayEnd) {
            return this.encoding.mbcToCode(array, index, arrayEnd);
        }

        public int prevCharHead(byte[] array, int arrayBegin, int index, int arrayEnd) {
            return this.encoding.prevCharHead(array, arrayBegin, index, arrayEnd);
        }
    }

    private static final class Lazy {
        private Lazy() {
        }

        static Encoding load(String jcodingsName) {
            CompilerAsserts.neverPartOfCompilation();
            CaseInsensitiveBytesHash<EncodingDB.Entry> encodings = EncodingDB.getEncodings();
            EncodingDB.Entry entry = encodings.get(jcodingsName.getBytes(StandardCharsets.ISO_8859_1));
            if (entry == null) {
                throw new IllegalArgumentException("JCodings Encoding '%s' not found".formatted(jcodingsName));
            }
            Encoding encoding = entry.getEncoding();
            assert (jcodingsName.equals(encoding.toString())) : jcodingsName + " != " + String.valueOf(encoding);
            return encoding;
        }

        static {
            CaseInsensitiveBytesHash<EncodingDB.Entry> encodings = EncodingDB.getEncodings();
            assert (encodings.size() <= 127) : String.format("Assumption broken: jcodings has more than %d encodings (actual: %d)!", 127, encodings.size());
            for (EncodingDB.Entry entry : encodings) {
                Encoding enc = entry.getEncoding();
                int i = enc.getIndex();
                assert (i >= 0 && i < encodings.size()) : String.format("Assumption broken: index of jcodings encoding \"%s\" is greater than number of encodings (index: %d, number of encodings: %d)!", enc, i, encodings.size());
            }
        }
    }
}

