/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.org.jline.terminal.impl.ffm;

import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.StructLayout;
import java.lang.foreign.ValueLayout;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeForeignAccess;
import org.graalvm.shadowed.org.jline.terminal.impl.ffm.FFMTerminalProviderLoader;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class FFMTerminalProviderFeature
implements Feature {
    private static StructLayout WIN_COORD_LAYOUT = MemoryLayout.structLayout(ValueLayout.JAVA_SHORT.withName("x"), ValueLayout.JAVA_SHORT.withName("y"));

    FFMTerminalProviderFeature() {
    }

    private static DowncallDesc[] getUnixDowncalls() {
        return new DowncallDesc[]{new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS), Linker.Option.firstVariadicArg(2)), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0])};
    }

    private static DowncallDesc[] getWindowsDowncalls() {
        return new DowncallDesc[]{new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.JAVA_INT), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_SHORT), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, WIN_COORD_LAYOUT), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_CHAR, ValueLayout.JAVA_INT, WIN_COORD_LAYOUT, ValueLayout.ADDRESS), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_SHORT, ValueLayout.JAVA_INT, WIN_COORD_LAYOUT, ValueLayout.ADDRESS), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, WIN_COORD_LAYOUT, ValueLayout.ADDRESS), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, new MemoryLayout[0]), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS), new Linker.Option[0]), new DowncallDesc(FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.JAVA_INT), new Linker.Option[0])};
    }

    private static DowncallDesc[] getDowncalls() {
        if (Platform.includedIn(Platform.WINDOWS.class)) {
            return FFMTerminalProviderFeature.getWindowsDowncalls();
        }
        return FFMTerminalProviderFeature.getUnixDowncalls();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        if (FFMTerminalProviderLoader.DISABLED) {
            return;
        }
        for (DowncallDesc downcall : FFMTerminalProviderFeature.getDowncalls()) {
            RuntimeForeignAccess.registerForDowncall((Object)downcall.fd(), (Object[])downcall.options());
        }
    }

    private record DowncallDesc(FunctionDescriptor fd, Linker.Option[] options) {
    }
}

