/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.org.jline.builtins;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;

public interface Source {
    public String getName();

    public InputStream read() throws IOException;

    public Long lines();

    public static class ResourceSource
    implements Source {
        final String resource;
        final String name;

        public ResourceSource(String resource) {
            this(resource, resource);
        }

        public ResourceSource(String resource, String name) {
            this.resource = Objects.requireNonNull(resource);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream read() throws IOException {
            return this.getClass().getResourceAsStream(this.resource);
        }

        @Override
        public Long lines() {
            return null;
        }
    }

    public static class StdInSource
    extends InputStreamSource {
        public StdInSource() {
            this(System.in);
        }

        public StdInSource(InputStream in) {
            super(in, false, null);
        }
    }

    public static class InputStreamSource
    implements Source {
        final InputStream in;
        final String name;

        public InputStreamSource(InputStream in, boolean close, String name) {
            Objects.requireNonNull(in);
            this.in = close ? in : new FilterInputStream(in){

                @Override
                public void close() throws IOException {
                }
            };
            if (this.in.markSupported()) {
                this.in.mark(Integer.MAX_VALUE);
            }
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream read() throws IOException {
            if (this.in.markSupported()) {
                this.in.reset();
            }
            return this.in;
        }

        @Override
        public Long lines() {
            return null;
        }
    }

    public static class PathSource
    implements Source {
        final Path path;
        final String name;

        public PathSource(File file, String name) {
            this(Objects.requireNonNull(file).toPath(), name);
        }

        public PathSource(Path path, String name) {
            this.path = Objects.requireNonNull(path);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream read() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }

        @Override
        public Long lines() {
            Long out = null;
            try (Stream<String> lines = Files.lines(this.path);){
                out = lines.count();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return out;
        }
    }

    public static class URLSource
    implements Source {
        final URL url;
        final String name;

        public URLSource(URL url, String name) {
            this.url = Objects.requireNonNull(url);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream read() throws IOException {
            return this.url.openStream();
        }

        @Override
        public Long lines() {
            Long out = null;
            try (Stream<String> lines = Files.lines(new File(this.url.toURI()).toPath());){
                out = lines.count();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return out;
        }
    }
}

