/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.org.joni;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import org.graalvm.shadowed.org.jcodings.CaseFoldCodeItem;
import org.graalvm.shadowed.org.jcodings.Encoding;
import org.graalvm.shadowed.org.jcodings.EncodingDB;
import org.graalvm.shadowed.org.jcodings.specific.ASCIIEncoding;
import org.graalvm.shadowed.org.jcodings.specific.UTF8Encoding;
import org.graalvm.shadowed.org.jcodings.util.BytesHash;
import org.graalvm.shadowed.org.joni.Analyser;
import org.graalvm.shadowed.org.joni.BitStatus;
import org.graalvm.shadowed.org.joni.Config;
import org.graalvm.shadowed.org.joni.Matcher;
import org.graalvm.shadowed.org.joni.MatcherFactory;
import org.graalvm.shadowed.org.joni.MinMaxLen;
import org.graalvm.shadowed.org.joni.NameEntry;
import org.graalvm.shadowed.org.joni.OptAnchorInfo;
import org.graalvm.shadowed.org.joni.OptExactInfo;
import org.graalvm.shadowed.org.joni.OptMapInfo;
import org.graalvm.shadowed.org.joni.Option;
import org.graalvm.shadowed.org.joni.Region;
import org.graalvm.shadowed.org.joni.Search;
import org.graalvm.shadowed.org.joni.Syntax;
import org.graalvm.shadowed.org.joni.WarnCallback;
import org.graalvm.shadowed.org.joni.exception.InternalException;
import org.graalvm.shadowed.org.joni.exception.ValueException;

public final class Regex {
    int[] code;
    int codeLength;
    boolean requireStack;
    int numMem;
    int numRepeat;
    int numNullCheck;
    int numCombExpCheck;
    int numCall;
    int captureHistory;
    int btMemStart;
    int btMemEnd;
    int stackPopLevel;
    int[] repeatRangeLo;
    int[] repeatRangeHi;
    MatcherFactory factory;
    final Encoding enc;
    int options;
    int userOptions;
    Object userObject;
    final int caseFoldFlag;
    private BytesHash<NameEntry> nameTable;
    Search.Forward forward;
    Search.Backward backward;
    int thresholdLength;
    int anchor;
    int anchorDmin;
    int anchorDmax;
    int subAnchor;
    byte[] exact;
    int exactP;
    int exactEnd;
    byte[] map;
    int[] intMap;
    int[] intMapBackward;
    int dMin;
    int dMax;
    byte[][] templates;
    int templateNum;
    private static final Encoding DEFAULT_ENCODING;

    public Regex(CharSequence cs) {
        this(cs.toString());
    }

    public Regex(CharSequence cs, Encoding enc) {
        this(cs.toString(), enc);
    }

    public Regex(String str) {
        this(str.getBytes(), 0, str.length(), 0, (Encoding)UTF8Encoding.INSTANCE);
    }

    public Regex(String str, Encoding enc) {
        this(str.getBytes(), 0, str.length(), 0, enc);
    }

    public Regex(byte[] bytes) {
        this(bytes, 0, bytes.length, 0, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public Regex(byte[] bytes, int p, int end) {
        this(bytes, p, end, 0, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public Regex(byte[] bytes, int p, int end, int option) {
        this(bytes, p, end, option, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public Regex(byte[] bytes, int p, int end, int option, Encoding enc) {
        this(bytes, p, end, option, enc, Syntax.RUBY, WarnCallback.DEFAULT);
    }

    public Regex(byte[] bytes, int p, int end, int option, Encoding enc, Syntax syntax) {
        this(bytes, p, end, option, 0x40000000, enc, syntax, WarnCallback.DEFAULT);
    }

    public Regex(byte[] bytes, int p, int end, int option, Encoding enc, WarnCallback warnings) {
        this(bytes, p, end, option, enc, Syntax.RUBY, warnings);
    }

    public Regex(byte[] bytes, int p, int end, int option, Encoding enc, Syntax syntax, WarnCallback warnings) {
        this(bytes, p, end, option, 0x40000000, enc, syntax, warnings);
    }

    public Regex(byte[] bytes, int p, int end, int option, int caseFoldFlag, Encoding enc, Syntax syntax, WarnCallback warnings) {
        if ((option & 0x180) == 384) {
            throw new ValueException("invalid combination of options");
        }
        if ((option & 0x40) != 0) {
            option |= syntax.options;
            option &= 0xFFFFFFF7;
        } else {
            option |= syntax.options;
        }
        this.enc = enc;
        this.options = option;
        this.caseFoldFlag = caseFoldFlag;
        new Analyser(this, syntax, bytes, p, end, warnings).compile();
    }

    public Matcher matcher(byte[] bytes) {
        return this.matcher(bytes, 0, bytes.length);
    }

    public Matcher matcherNoRegion(byte[] bytes) {
        return this.matcherNoRegion(bytes, 0, bytes.length);
    }

    public Matcher matcher(byte[] bytes, int p, int end) {
        return this.factory.create(this, this.numMem == 0 ? null : Region.newRegion(this.numMem + 1), bytes, p, end);
    }

    public Matcher matcherNoRegion(byte[] bytes, int p, int end) {
        return this.factory.create(this, null, bytes, p, end);
    }

    public int numberOfCaptures() {
        return this.numMem;
    }

    public int numberOfCaptureHistories() {
        if (Config.USE_CAPTURE_HISTORY) {
            int n = 0;
            for (int i = 0; i <= Config.MAX_CAPTURE_HISTORY_GROUP; ++i) {
                if (!BitStatus.bsAt(this.captureHistory, i)) continue;
                ++n;
            }
            return n;
        }
        return 0;
    }

    private NameEntry nameFind(byte[] name, int nameP, int nameEnd) {
        if (this.nameTable != null) {
            return (NameEntry)this.nameTable.get(name, nameP, nameEnd);
        }
        return null;
    }

    void renumberNameTable(int[] map) {
        if (this.nameTable != null) {
            for (NameEntry e : this.nameTable) {
                if (e.backNum > 1) {
                    for (int i = 0; i < e.backNum; ++i) {
                        e.backRefs[i] = map[e.backRefs[i]];
                    }
                    continue;
                }
                if (e.backNum != 1) continue;
                e.backRef1 = map[e.backRef1];
            }
        }
    }

    void nameAdd(byte[] name, int nameP, int nameEnd, int backRef, Syntax syntax) {
        if (nameEnd - nameP <= 0) {
            throw new ValueException("group name is empty");
        }
        NameEntry e = null;
        if (this.nameTable == null) {
            this.nameTable = new BytesHash();
        } else {
            e = this.nameFind(name, nameP, nameEnd);
        }
        if (e == null) {
            e = new NameEntry(name, nameP, nameEnd);
            this.nameTable.putDirect(name, nameP, nameEnd, (Object)e);
        } else if (e.backNum >= 1 && !syntax.allowMultiplexDefinitionName()) {
            throw new ValueException("multiplex defined name <%n>", new String(name, nameP, nameEnd - nameP));
        }
        e.addBackref(backRef);
    }

    NameEntry nameToGroupNumbers(byte[] name, int nameP, int nameEnd) {
        return this.nameFind(name, nameP, nameEnd);
    }

    public int nameToBackrefNumber(byte[] name, int nameP, int nameEnd, Region region) {
        return this.nameToBackrefNumber(name, nameP, nameEnd, DEFAULT_ENCODING, region);
    }

    public int nameToBackrefNumber(byte[] name, int nameP, int nameEnd, Encoding nameEncoding, Region region) {
        NameEntry e = this.nameToGroupNumbers(name, nameP, nameEnd);
        if (e == null) {
            throw new ValueException("undefined name <%n> reference", new String(name, nameP, nameEnd - nameP, nameEncoding.getCharset()));
        }
        switch (e.backNum) {
            case 0: {
                throw new InternalException("internal parser error (bug)");
            }
            case 1: {
                return e.backRef1;
            }
        }
        if (region != null) {
            for (int i = e.backNum - 1; i >= 0; --i) {
                if (region.getBeg(e.backRefs[i]) == -1) continue;
                return e.backRefs[i];
            }
        }
        return e.backRefs[e.backNum - 1];
    }

    String nameTableToString() {
        StringBuilder sb = new StringBuilder();
        if (this.nameTable != null) {
            sb.append("name table\n");
            for (NameEntry ne : this.nameTable) {
                sb.append("  ").append(ne).append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public Iterator<NameEntry> namedBackrefIterator() {
        return this.nameTable == null ? Collections.emptyIterator() : this.nameTable.iterator();
    }

    public int numberOfNames() {
        return this.nameTable == null ? 0 : this.nameTable.size();
    }

    public boolean noNameGroupIsActive(Syntax syntax) {
        if (Option.isDontCaptureGroup(this.options)) {
            return false;
        }
        return !Config.USE_NAMED_GROUP || this.numberOfNames() <= 0 || !syntax.captureOnlyNamedGroup() || Option.isCaptureGroup(this.options);
    }

    boolean setupBMSkipMap(boolean ignoreCase) {
        int ilen;
        byte[] bytes = this.exact;
        int s = this.exactP;
        int end = this.exactEnd;
        int len = end - s;
        CaseFoldCodeItem[] items = CaseFoldCodeItem.EMPTY_FOLD_CODES;
        byte[] buf = new byte[234];
        int n = ilen = Config.USE_SUNDAY_QUICK_SEARCH ? len : len - 1;
        if (Config.USE_BYTE_MAP || len < Config.CHAR_TABLE_SIZE) {
            int clen;
            int i;
            if (this.map == null) {
                this.map = new byte[Config.CHAR_TABLE_SIZE];
            }
            for (i = 0; i < Config.CHAR_TABLE_SIZE; ++i) {
                this.map[i] = (byte)(Config.USE_SUNDAY_QUICK_SEARCH ? len + 1 : len);
            }
            for (i = 0; i < ilen; i += clen) {
                if (ignoreCase) {
                    items = this.enc.caseFoldCodesByString(this.caseFoldFlag, bytes, s + i, end);
                }
                if ((clen = this.setupBMSkipMapCheck(bytes, s + i, end, items, buf)) == 0) {
                    return true;
                }
                for (int j = 0; j < clen; ++j) {
                    this.map[bytes[s + i + j] & 0xFF] = (byte)(ilen - i - j);
                    for (int k = 0; k < items.length; ++k) {
                        this.map[buf[k * 13 + j] & 0xFF] = (byte)(ilen - i - j);
                    }
                }
            }
        } else {
            int clen;
            int i;
            if (this.intMap == null) {
                this.intMap = new int[Config.CHAR_TABLE_SIZE];
            }
            for (i = 0; i < Config.CHAR_TABLE_SIZE; ++i) {
                this.intMap[i] = Config.USE_SUNDAY_QUICK_SEARCH ? len + 1 : len;
            }
            for (i = 0; i < ilen; i += clen) {
                if (ignoreCase) {
                    items = this.enc.caseFoldCodesByString(this.caseFoldFlag, bytes, s + i, end);
                }
                if ((clen = this.setupBMSkipMapCheck(bytes, s + i, end, items, buf)) == 0) {
                    return true;
                }
                for (int j = 0; j < clen; ++j) {
                    this.intMap[bytes[s + i + j] & 0xFF] = ilen - i - j;
                    for (int k = 0; k < items.length; ++k) {
                        this.intMap[buf[k * 13 + j] & 0xFF] = ilen - i - j;
                    }
                }
            }
        }
        return false;
    }

    private int setupBMSkipMapCheck(byte[] bytes, int p, int end, CaseFoldCodeItem[] items, byte[] buf) {
        int clen = this.enc.length(bytes, p, end);
        if (p + clen > end) {
            clen = end - p;
        }
        for (int j = 0; j < items.length; ++j) {
            if (items[j].code.length != 1 || items[j].byteLen != clen) {
                return 0;
            }
            int flen = this.enc.codeToMbc(items[j].code[0], buf, j * 13);
            if (flen == clen) continue;
            return 0;
        }
        return clen;
    }

    void setOptimizeExactInfo(OptExactInfo e) {
        if (e.length == 0) {
            return;
        }
        this.exact = e.bytes;
        this.exactP = 0;
        this.exactEnd = e.length;
        boolean allowReverse = this.enc.isReverseMatchAllowed(this.exact, this.exactP, this.exactEnd);
        if (e.ignoreCase > 0) {
            if (e.length >= 3 || e.length >= 2 && allowReverse) {
                Search.Forward forward = this.forward = this.enc.toLowerCaseTable() != null ? Search.SLOW_IC_SB_FORWARD : Search.SLOW_IC_FORWARD;
                this.forward = !this.setupBMSkipMap(true) ? (allowReverse ? (this.enc.toLowerCaseTable() != null ? Search.SLOW_IC_SB_FORWARD : Search.SLOW_IC_FORWARD) : Search.BM_NOT_REV_IC_FORWARD) : (this.enc.toLowerCaseTable() != null ? Search.SLOW_IC_SB_FORWARD : Search.SLOW_IC_FORWARD);
            } else {
                this.forward = this.enc.toLowerCaseTable() != null ? Search.SLOW_IC_SB_FORWARD : Search.SLOW_IC_FORWARD;
            }
            this.backward = this.enc.toLowerCaseTable() != null ? Search.SLOW_IC_SB_BACKWARD : Search.SLOW_IC_BACKWARD;
        } else {
            this.forward = e.length >= 3 || e.length >= 2 && allowReverse ? (!this.setupBMSkipMap(false) ? (allowReverse ? Search.BM_FORWARD : Search.BM_NOT_REV_FORWARD) : (this.enc.isSingleByte() ? Search.SLOW_SB_FORWARD : Search.SLOW_FORWARD)) : (this.enc.isSingleByte() ? Search.SLOW_SB_FORWARD : Search.SLOW_FORWARD);
            this.backward = this.enc.isSingleByte() ? Search.SLOW_SB_BACKWARD : Search.SLOW_BACKWARD;
        }
        this.dMin = e.mmd.min;
        this.dMax = e.mmd.max;
        if (this.dMin != Integer.MAX_VALUE) {
            this.thresholdLength = this.dMin + (this.exactEnd - this.exactP);
        }
    }

    void setOptimizeMapInfo(OptMapInfo m) {
        this.map = m.map;
        if (this.enc.isSingleByte()) {
            this.forward = Search.MAP_SB_FORWARD;
            this.backward = Search.MAP_SB_BACKWARD;
        } else {
            this.forward = Search.MAP_FORWARD;
            this.backward = Search.MAP_BACKWARD;
        }
        this.dMin = m.mmd.min;
        this.dMax = m.mmd.max;
        if (this.dMin != Integer.MAX_VALUE) {
            this.thresholdLength = this.dMin + 1;
        }
    }

    void setSubAnchor(OptAnchorInfo anc) {
        this.subAnchor |= anc.leftAnchor & 2;
        this.subAnchor |= anc.rightAnchor & 0x20;
    }

    void clearOptimizeInfo() {
        this.forward = null;
        this.backward = null;
        this.anchor = 0;
        this.anchorDmax = 0;
        this.anchorDmin = 0;
        this.subAnchor = 0;
        this.exact = null;
        this.exactEnd = 0;
        this.exactP = 0;
    }

    public String optimizeInfoToString() {
        Object s = "";
        s = (String)s + "optimize: " + (this.forward != null ? this.forward.getName() : "NONE") + "\n";
        s = (String)s + "  anchor:     " + OptAnchorInfo.anchorToString(this.anchor);
        if ((this.anchor & 0x18) != 0) {
            s = (String)s + MinMaxLen.distanceRangeToString(this.anchorDmin, this.anchorDmax);
        }
        s = (String)s + "\n";
        if (this.forward != null) {
            s = (String)s + "  sub anchor: " + OptAnchorInfo.anchorToString(this.subAnchor) + "\n";
        }
        s = (String)s + "dmin: " + this.dMin + " dmax: " + this.dMax + "\n";
        s = (String)s + "threshold length: " + this.thresholdLength + "\n";
        if (this.exact != null) {
            s = (String)s + "exact: [" + new String(this.exact, this.exactP, this.exactEnd - this.exactP) + "]: length: " + (this.exactEnd - this.exactP) + "\n";
        } else if (this.forward == Search.MAP_FORWARD || this.forward == Search.MAP_SB_FORWARD) {
            int n = 0;
            for (int i = 0; i < Config.CHAR_TABLE_SIZE; ++i) {
                if (this.map[i] == 0) continue;
                ++n;
            }
            s = (String)s + "map: n = " + n + "\n";
            if (n > 0) {
                int c = 0;
                s = (String)s + "[";
                for (int i = 0; i < Config.CHAR_TABLE_SIZE; ++i) {
                    if (this.map[i] == 0) continue;
                    if (c > 0) {
                        s = (String)s + ", ";
                    }
                    ++c;
                    s = this.enc.maxLength() == 1 && this.enc.isPrint(i) ? (String)s + (char)i : (String)s + i;
                }
                s = (String)s + "]\n";
            }
        }
        return s;
    }

    public Encoding getEncoding() {
        return this.enc;
    }

    public int getOptions() {
        return this.options;
    }

    public void setUserOptions(int options) {
        this.userOptions = options;
    }

    public int getUserOptions() {
        return this.userOptions;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    static {
        EncodingDB.Entry entry = (EncodingDB.Entry)EncodingDB.getEncodings().get(Charset.defaultCharset().name().getBytes());
        Object defaultEncoding = entry == null ? UTF8Encoding.INSTANCE : entry.getEncoding();
        DEFAULT_ENCODING = defaultEncoding;
    }
}

