/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.org.joni.ast;

import org.graalvm.shadowed.org.joni.Config;
import org.graalvm.shadowed.org.joni.ScanEnvironment;
import org.graalvm.shadowed.org.joni.ast.StateNode;
import org.graalvm.shadowed.org.joni.exception.ValueException;

public final class BackRefNode
extends StateNode {
    public final int[] back;
    public int backNum;
    public int nestLevel;

    private BackRefNode(int backNum, int[] backRefs, boolean byName, ScanEnvironment env) {
        super(4);
        this.backNum = backNum;
        if (byName) {
            this.setNameRef();
        }
        for (int i = 0; i < backNum; ++i) {
            if (backRefs[i] > env.numMem || env.memNodes[backRefs[i]] != null) continue;
            this.setRecursion();
            break;
        }
        this.back = backRefs;
    }

    public BackRefNode(int backNum, int[] backRefs, boolean byName, boolean existLevel, int nestLevel, ScanEnvironment env) {
        this(backNum, backRefs, byName, env);
        if (Config.USE_BACKREF_WITH_LEVEL && existLevel) {
            this.setNestLevel();
            this.nestLevel = nestLevel;
        }
    }

    public void renumber(int[] map) {
        if (!this.isNameRef()) {
            throw new ValueException("numbered backref/call is not allowed. (use name)");
        }
        int oldNum = this.backNum;
        int pos = 0;
        for (int i = 0; i < oldNum; ++i) {
            int n = map[this.back[i]];
            if (n <= 0) continue;
            this.back[pos] = n;
            ++pos;
        }
        this.backNum = pos;
    }

    @Override
    public String getName() {
        return "Back Ref";
    }

    @Override
    public String toString(int level) {
        StringBuilder sb = new StringBuilder(super.toString(level));
        sb.append("\n  backNum: " + this.backNum);
        Object backs = "";
        for (int i = 0; i < this.back.length; ++i) {
            backs = (String)backs + this.back[i] + ", ";
        }
        sb.append("\n  back: " + (String)backs);
        sb.append("\n  nextLevel: " + this.nestLevel);
        return sb.toString();
    }
}

