/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.org.joni;

import java.util.Arrays;
import org.graalvm.shadowed.org.joni.Region;

public final class MultiRegion
extends Region {
    private final int[] begEnd;

    public MultiRegion(int num) {
        this.begEnd = new int[num * 2];
    }

    public MultiRegion(int begin, int end) {
        this.begEnd = new int[]{begin, end};
    }

    @Override
    public final int getNumRegs() {
        return this.begEnd.length / 2;
    }

    @Override
    public MultiRegion clone() {
        MultiRegion region = new MultiRegion(this.getNumRegs());
        System.arraycopy(this.begEnd, 0, region.begEnd, 0, this.begEnd.length);
        if (this.getCaptureTree() != null) {
            region.setCaptureTree(this.getCaptureTree().cloneTree());
        }
        return region;
    }

    @Override
    public int getBeg(int index) {
        return this.begEnd[index * 2];
    }

    @Override
    public int setBeg(int index, int value) {
        int n = value;
        this.begEnd[index * 2] = n;
        return n;
    }

    @Override
    public int getEnd(int index) {
        return this.begEnd[index * 2 + 1];
    }

    @Override
    public int setEnd(int index, int value) {
        int n = value;
        this.begEnd[index * 2 + 1] = n;
        return n;
    }

    @Override
    void clear() {
        Arrays.fill(this.begEnd, -1);
    }
}

