/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.org.joni;

import org.graalvm.shadowed.org.jcodings.ApplyAllCaseFoldFunction;
import org.graalvm.shadowed.org.jcodings.Encoding;
import org.graalvm.shadowed.org.joni.ApplyCaseFoldArg;
import org.graalvm.shadowed.org.joni.BitSet;
import org.graalvm.shadowed.org.joni.Config;
import org.graalvm.shadowed.org.joni.ScanEnvironment;
import org.graalvm.shadowed.org.joni.ast.CClassNode;
import org.graalvm.shadowed.org.joni.ast.ListNode;
import org.graalvm.shadowed.org.joni.ast.StringNode;

final class ApplyCaseFold
implements ApplyAllCaseFoldFunction {
    static final ApplyCaseFold INSTANCE = new ApplyCaseFold();

    ApplyCaseFold() {
    }

    public void apply(int from, int[] to, int length, Object o) {
        boolean addFlag;
        ApplyCaseFoldArg arg = (ApplyCaseFoldArg)o;
        ScanEnvironment env = arg.env;
        Encoding enc = env.enc;
        CClassNode cc = arg.cc;
        CClassNode ascCc = arg.ascCc;
        BitSet bs = cc.bs;
        if (ascCc == null) {
            addFlag = false;
        } else if (Encoding.isAscii((int)from) == Encoding.isAscii((int)to[0])) {
            addFlag = true;
        } else {
            addFlag = ascCc.isCodeInCC(enc, from);
            if (ascCc.isNot()) {
                boolean bl = addFlag = !addFlag;
            }
        }
        if (length == 1) {
            boolean inCC = cc.isCodeInCC(enc, from);
            if (Config.CASE_FOLD_IS_APPLIED_INSIDE_NEGATIVE_CCLASS) {
                if ((inCC && !cc.isNot() || !inCC && cc.isNot()) && addFlag) {
                    if (enc.minLength() > 1 || to[0] >= 256 || enc.codeToMbcLength(to[0]) > 1) {
                        cc.addCodeRange(env, to[0], to[0], false);
                    } else {
                        bs.set(to[0]);
                    }
                }
            } else if (inCC && addFlag) {
                if (enc.minLength() > 1 || to[0] >= 256) {
                    if (cc.isNot()) {
                        cc.clearNotFlag(env);
                    }
                    cc.addCodeRange(env, to[0], to[0], false);
                } else if (cc.isNot()) {
                    bs.clear(to[0]);
                } else {
                    bs.set(to[0]);
                }
            }
        } else if (!(!cc.isCodeInCC(enc, from) || Config.CASE_FOLD_IS_APPLIED_INSIDE_NEGATIVE_CCLASS && cc.isNot())) {
            StringNode node = null;
            for (int i = 0; i < length; ++i) {
                if (i == 0) {
                    node = new StringNode();
                    node.setAmbig();
                }
                node.catCode(to[i], enc);
            }
            ListNode alt = ListNode.newAlt(node, null);
            if (arg.tail == null) {
                arg.altRoot = alt;
            } else {
                arg.tail.setTail(alt);
            }
            arg.tail = alt;
        }
    }
}

