/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.server;

import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import com.oracle.truffle.tools.chromeinspector.instrument.InspectorWSConnection;
import com.oracle.truffle.tools.chromeinspector.instrument.KeyStoreOptions;
import com.oracle.truffle.tools.chromeinspector.instrument.Token;
import com.oracle.truffle.tools.chromeinspector.server.ConnectionWatcher;
import com.oracle.truffle.tools.chromeinspector.server.InspectServerSession;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLServerSocketFactory;
import org.graalvm.polyglot.io.MessageEndpoint;
import org.nanohttpd.protocols.http.ClientHandler;
import org.nanohttpd.protocols.http.IHTTPSession;
import org.nanohttpd.protocols.http.NanoHTTPD;
import org.nanohttpd.protocols.http.content.ContentType;
import org.nanohttpd.protocols.http.request.Method;
import org.nanohttpd.protocols.http.response.IStatus;
import org.nanohttpd.protocols.http.response.Response;
import org.nanohttpd.protocols.http.response.Status;
import org.nanohttpd.protocols.websockets.CloseCode;
import org.nanohttpd.protocols.websockets.NanoWSD;
import org.nanohttpd.protocols.websockets.WebSocket;
import org.nanohttpd.protocols.websockets.WebSocketFrame;
import org.nanohttpd.util.IHandler;
import sun.net.util.IPAddressUtil;

public final class InspectorServer
extends NanoWSD
implements InspectorWSConnection {
    private static final Map<InetSocketAddress, InspectorServer> SERVERS = new HashMap<InetSocketAddress, InspectorServer>();
    private final int port;
    private final Map<Token, ServerPathSession> sessions = new ConcurrentHashMap<Token, ServerPathSession>();

    private InspectorServer(InetSocketAddress isa) {
        super(isa.getHostName(), isa.getPort());
        this.port = isa.getPort();
        this.addHTTPInterceptor(new DNSRebindProtectionHandler());
        this.addHTTPInterceptor(new JSONHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InspectorServer get(InetSocketAddress isa, Token token, String pathContainingToken, InspectorExecutionContext context, boolean debugBrk, boolean secure, KeyStoreOptions keyStoreOptions, ConnectionWatcher connectionWatcher, InspectServerSession initialSession) throws IOException {
        InspectorServer wss;
        boolean startServer = false;
        Map<InetSocketAddress, InspectorServer> map = SERVERS;
        synchronized (map) {
            wss = SERVERS.get(isa);
            if (wss == null) {
                wss = new InspectorServer(isa);
                context.logMessage("", "New WebSocketServer at " + isa);
                if (secure) {
                    if (TruffleOptions.AOT) {
                        throw new IOException("Secure connection is not available in the native-image yet.");
                    }
                    wss.makeSecure(InspectorServer.createSSLFactory(keyStoreOptions), null);
                }
                startServer = true;
                SERVERS.put(isa, wss);
            }
            if (wss.sessions.containsKey(token)) {
                throw new IOException("Inspector session with the same path exists already on " + isa.getHostString() + ":" + isa.getPort());
            }
            wss.sessions.put(token, new ServerPathSession(context, initialSession, debugBrk, connectionWatcher, pathContainingToken));
        }
        if (startServer) {
            wss.start(Integer.MAX_VALUE);
        }
        return wss;
    }

    private static SSLServerSocketFactory createSSLFactory(KeyStoreOptions keyStoreOptions) throws IOException {
        String keyStoreFile = keyStoreOptions.getKeyStore();
        if (keyStoreFile != null) {
            try {
                String filePasswordProperty = keyStoreOptions.getKeyStorePassword();
                char[] filePassword = filePasswordProperty == null ? "".toCharArray() : filePasswordProperty.toCharArray();
                String keystoreType = keyStoreOptions.getKeyStoreType();
                if (keystoreType == null) {
                    keystoreType = KeyStore.getDefaultType();
                }
                KeyStore keystore = KeyStore.getInstance(keystoreType);
                File keyFile = new File(keyStoreFile);
                try (FileInputStream keyIn = new FileInputStream(keyFile);){
                    keystore.load(keyIn, filePassword);
                }
                String keyRecoverPasswordProperty = keyStoreOptions.getKeyPassword();
                char[] keyRecoverPassword = keyRecoverPasswordProperty == null ? filePassword : keyRecoverPasswordProperty.toCharArray();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keystore, keyRecoverPassword);
                return NanoHTTPD.makeSSLSocketFactory(keystore, kmf);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
                throw new IOException(ex);
            }
        }
        throw new IOException("Use options to specify the keystore");
    }

    private static Response handleDnsRebind(IHTTPSession ihttpSession) {
        if (!InspectorServer.isHostOk(ihttpSession.getHeaders().get("host"))) {
            return Response.newFixedLengthResponse((IStatus)Status.BAD_REQUEST, "text/plain; charset=UTF-8", "Bad host. Please use IP address. This request cannot be served because it looks like DNS rebind attack.");
        }
        return null;
    }

    private static boolean isHostOk(String host) {
        if (host == null) {
            return false;
        }
        String bareHost = host.replaceFirst(":([0-9]+)$", "");
        return bareHost.equals("localhost") || InspectorServer.isValidIp(bareHost);
    }

    private static boolean isValidIp(String host) {
        return IPAddressUtil.isIPv4LiteralAddress(host) || InspectorServer.isValidIpv6(host);
    }

    private static boolean isValidIpv6(String host) {
        return host.startsWith("[") && host.endsWith("]") && IPAddressUtil.isIPv6LiteralAddress(host.substring(1, host.length() - 1));
    }

    @Override
    protected WebSocket openWebSocket(IHTTPSession handshake) {
        String uri = handshake.getUri();
        Token token = Token.createHashedTokenFromString(uri);
        ServerPathSession session = this.sessions.get(token);
        if (session != null) {
            InspectWebSocket iws;
            InspectServerSession iss = session.getServerSession();
            if (iss == null) {
                boolean debugBreak = Boolean.TRUE.equals(session.getDebugBrkAndReset());
                iss = InspectServerSession.create(session.getContext(), debugBreak, session.getConnectionWatcher());
            }
            session.activeWS = iws = new InspectWebSocket(handshake, iss, session.getConnectionWatcher());
            iss.context.logMessage("CLIENT ws connection opened, token = ", token);
            return iws;
        }
        return new ClosedWebSocket(handshake);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ClientHandler createClientHandler(final Socket finalAccept, InputStream inputStream) {
        final PushbackInputStream pbInputStream = new PushbackInputStream(inputStream, 3);
        try {
            String text;
            byte[] buf = new byte[3];
            pbInputStream.read(buf);
            try {
                text = new String(buf, "US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                text = null;
            }
            finally {
                pbInputStream.unread(buf);
            }
            if (!"GET".equals(text)) {
                return new ClientHandler(this, pbInputStream, finalAccept){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try (OutputStream outputStream = finalAccept.getOutputStream();){
                            ContentType contentType = new ContentType("text/plain");
                            PrintWriter pw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, contentType.getEncoding())), false);
                            pw.append("HTTP/1.1 ").append(Status.BAD_REQUEST.getDescription()).append(" \r\n");
                            String mimeType = contentType.getContentTypeHeader();
                            if (mimeType != null) {
                                pw.append("Content-Type: ").append(mimeType).append("\r\n");
                            }
                            pw.append("\r\n");
                            pw.append("WebSockets request was expected");
                            pw.flush();
                        }
                        catch (IOException ex) {
                            Iterator sessionIterator = InspectorServer.this.sessions.values().iterator();
                            if (sessionIterator.hasNext()) {
                                ((ServerPathSession)sessionIterator.next()).context.logException(ex);
                            }
                        }
                        finally {
                            NanoHTTPD.safeClose(pbInputStream);
                            NanoHTTPD.safeClose(finalAccept);
                        }
                    }
                };
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ClientHandler(this, pbInputStream, finalAccept);
    }

    @Override
    public int getPort() {
        int p = this.getListeningPort();
        if (p == -1) {
            p = this.port;
        }
        return p;
    }

    @Override
    public void close(Token token) throws IOException {
        InspectWebSocket iws;
        ServerPathSession sps = this.sessions.remove(token);
        if (sps != null && (iws = sps.activeWS) != null) {
            iws.close(CloseCode.GoingAway, "", false);
        }
        if (this.sessions.isEmpty()) {
            this.stop();
        }
    }

    @Override
    public void consoleAPICall(Token token, String type, Object text) {
        InspectWebSocket iws;
        ServerPathSession sps = this.sessions.get(token);
        if (sps != null && (iws = sps.activeWS) != null) {
            iws.iss.consoleAPICall(type, text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        Map<InetSocketAddress, InspectorServer> map = SERVERS;
        synchronized (map) {
            Iterator<Map.Entry<InetSocketAddress, InspectorServer>> entries = SERVERS.entrySet().iterator();
            while (entries.hasNext()) {
                if (entries.next().getValue() != this) continue;
                entries.remove();
                break;
            }
        }
    }

    private class ClosedWebSocket
    extends WebSocket {
        ClosedWebSocket(IHTTPSession handshakeRequest) {
            super(handshakeRequest);
            try {
                this.close(CloseCode.UnsupportedData, "Bad path.", false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        protected void onOpen() {
        }

        @Override
        protected void onClose(CloseCode cc, String string, boolean bln) {
        }

        @Override
        protected void onMessage(WebSocketFrame wsf) {
        }

        @Override
        protected void onPong(WebSocketFrame wsf) {
        }

        @Override
        protected void onException(IOException ioe) {
        }
    }

    private class InspectWebSocket
    extends WebSocket {
        private final Token token;
        private final InspectServerSession iss;
        private final ConnectionWatcher connectionWatcher;

        InspectWebSocket(IHTTPSession handshake, InspectServerSession iss, ConnectionWatcher connectionWatcher) {
            super(handshake);
            this.token = Token.createHashedTokenFromString(handshake.getUri());
            this.iss = iss;
            this.connectionWatcher = connectionWatcher;
        }

        @Override
        public void onOpen() {
            this.iss.context.logMessage("CLIENT web socket connection opened.", "");
            this.connectionWatcher.notifyOpen();
            this.iss.setMessageListener(new MessageEndpoint(){

                public void sendText(String message) throws IOException {
                    ((InspectWebSocket)InspectWebSocket.this).iss.context.logMessage("SERVER: ", message);
                    InspectWebSocket.this.send(message);
                }

                public void sendBinary(ByteBuffer data) throws IOException {
                    throw new UnsupportedOperationException("Binary messages are not supported.");
                }

                public void sendPing(ByteBuffer data) throws IOException {
                }

                public void sendPong(ByteBuffer data) throws IOException {
                }

                public void sendClose() throws IOException {
                    InspectWebSocket.this.close(CloseCode.NormalClosure, "", true);
                }
            });
        }

        @Override
        public void onClose(CloseCode code, String reason, boolean initiatedByRemote) {
            this.iss.context.logMessage("CLIENT web socket connection closed.", "");
            this.connectionWatcher.notifyClosing();
            ServerPathSession sps = (ServerPathSession)InspectorServer.this.sessions.get(this.token);
            if (sps != null) {
                sps.activeWS = null;
            }
            this.iss.sendClose();
        }

        @Override
        public void close(CloseCode code, String reason, boolean initiatedByRemote) throws IOException {
            try {
                super.close(code, reason, initiatedByRemote);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }

        @Override
        public void onMessage(WebSocketFrame frame) {
            String message = frame.getTextPayload();
            this.iss.context.logMessage("CLIENT: ", message);
            this.iss.sendText(message);
        }

        @Override
        protected void onPong(WebSocketFrame pong) {
            this.iss.context.logMessage("CLIENT PONG: ", pong);
        }

        @Override
        protected void onException(IOException exception) {
            this.iss.context.logException("CLIENT: ", exception);
        }
    }

    private static class ServerPathSession {
        private final InspectorExecutionContext context;
        private final AtomicReference<InspectServerSession> serverSession;
        private final AtomicBoolean debugBrk;
        private final ConnectionWatcher connectionWatcher;
        private final String pathContainingToken;
        volatile InspectWebSocket activeWS;

        ServerPathSession(InspectorExecutionContext context, InspectServerSession serverSession, boolean debugBrk, ConnectionWatcher connectionWatcher, String pathContainingToken) {
            this.context = context;
            this.serverSession = new AtomicReference<InspectServerSession>(serverSession);
            this.debugBrk = new AtomicBoolean(debugBrk);
            this.connectionWatcher = connectionWatcher;
            this.pathContainingToken = pathContainingToken;
        }

        InspectorExecutionContext getContext() {
            return this.context;
        }

        InspectServerSession getServerSession() {
            return this.serverSession.getAndSet(null);
        }

        boolean getDebugBrkAndReset() {
            return this.debugBrk.getAndSet(false);
        }

        ConnectionWatcher getConnectionWatcher() {
            return this.connectionWatcher;
        }
    }

    private class JSONHandler
    implements IHandler<IHTTPSession, Response> {
        private JSONHandler() {
        }

        @Override
        public Response handle(IHTTPSession session) {
            if (Method.GET == session.getMethod()) {
                String uri = session.getUri();
                String responseJson = null;
                if ("/json/version".equals(uri)) {
                    JSONObject version = new JSONObject();
                    version.put("Browser", (Object)"GraalVM");
                    version.put("Protocol-Version", (Object)"1.2");
                    responseJson = version.toString();
                }
                if ("/json".equals(uri)) {
                    JSONArray json = new JSONArray();
                    for (ServerPathSession serverPathSession : InspectorServer.this.sessions.values()) {
                        String path = serverPathSession.pathContainingToken;
                        JSONObject info = new JSONObject();
                        info.put("description", (Object)"GraalVM");
                        info.put("faviconUrl", (Object)"https://assets-cdn.github.com/images/icons/emoji/unicode/1f680.png");
                        String ws = InspectorServer.this.getHostname() + ":" + InspectorServer.this.getListeningPort() + path;
                        info.put("devtoolsFrontendUrl", (Object)("chrome-devtools://devtools/bundled/js_app.html?ws=" + ws));
                        info.put("id", (Object)path.substring(1));
                        info.put("title", (Object)"GraalVM");
                        info.put("type", (Object)"node");
                        info.put("webSocketDebuggerUrl", (Object)("ws://" + ws));
                        json.put((Object)info);
                    }
                    responseJson = json.toString();
                }
                if (responseJson != null) {
                    Response response = Response.newFixedLengthResponse((IStatus)Status.OK, "application/json; charset=UTF-8", responseJson);
                    response.addHeader("Cache-Control", "no-cache,no-store,must-revalidate");
                    response.addHeader("Pragma", "no-cache");
                    response.addHeader("X-Content-Type-Options", "nosniff");
                    return response;
                }
            }
            return null;
        }
    }

    private class DNSRebindProtectionHandler
    implements IHandler<IHTTPSession, Response> {
        private DNSRebindProtectionHandler() {
        }

        @Override
        public Response handle(IHTTPSession ihttpSession) {
            return InspectorServer.handleDnsRebind(ihttpSession);
        }
    }
}

