// CheckStyle: start generated
package com.oracle.truffle.tools.chromeinspector.objects;

import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.tools.chromeinspector.objects.AbstractInspectorObject.MethodExecutable;

@GeneratedBy(MethodExecutable.class)
final class MethodExecutableGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(MethodExecutable.class, new InteropLibraryExports());
    }

    private MethodExecutableGen() {
    }

    @GeneratedBy(MethodExecutable.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private static final Uncached UNCACHED = new Uncached();

        private InteropLibraryExports() {
            super(InteropLibrary.class, MethodExecutable.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof MethodExecutable;
            InteropLibrary uncached = InteropLibraryExports.UNCACHED;
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof MethodExecutable;
            return new Cached(receiver);
        }

        @GeneratedBy(MethodExecutable.class)
        private static final class Cached extends InteropLibrary {

            @Child private InteropLibrary receiverInspectorInteropLibrary_;

            Cached(Object originalReceiver) {
                MethodExecutable receiver = ((MethodExecutable) originalReceiver) ;
                this.receiverInspectorInteropLibrary_ = super.insert(INTEROP_LIBRARY_.create((receiver.inspector)));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof MethodExecutable) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof MethodExecutable)) {
                    return false;
                } else if (!this.receiverInspectorInteropLibrary_.accepts((((MethodExecutable) receiver).inspector))) {
                    return false;
                } else {
                    return true;
                }
            }

            @Override
            public boolean isExecutable(Object receiver) {
                assert receiver instanceof MethodExecutable : "Invalid library usage. Library does not accept given receiver.";
                return (((MethodExecutable) receiver)).isExecutable();
            }

            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert arg0Value_ instanceof MethodExecutable : "Invalid library usage. Library does not accept given receiver.";
                MethodExecutable arg0Value = ((MethodExecutable) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverInspectorInteropLibrary_;
                    return arg0Value.execute(arg1Value, interop__);
                }
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
        @GeneratedBy(MethodExecutable.class)
        private static final class Uncached extends InteropLibrary {

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof MethodExecutable) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof MethodExecutable;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((MethodExecutable) receiver) .isExecutable();
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                MethodExecutable arg0Value = ((MethodExecutable) arg0Value_);
                return arg0Value.execute(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.inspector)));
            }

        }
    }
}
