/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.tools.chromeinspector.types.RuntimeCallFrame;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.List;

public final class ProfileNode {
    private final int id;
    private final RuntimeCallFrame callFrame;
    private final long hitCount;
    private final List<Integer> children;

    public ProfileNode(int id, RuntimeCallFrame callFrame, long hitCount) {
        this.id = id;
        this.callFrame = callFrame;
        this.hitCount = hitCount;
        this.children = new ArrayList<Integer>();
    }

    public int getId() {
        return this.id;
    }

    public RuntimeCallFrame getCallFrame() {
        return this.callFrame;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public void addChild(int childId) {
        this.children.add(childId);
    }

    private JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("id", this.id);
        json.put("callFrame", (Object)this.callFrame.toJSON());
        json.put("hitCount", this.hitCount);
        JSONArray array = new JSONArray();
        this.children.forEach(i -> array.put(i.intValue()));
        json.put("children", (Object)array);
        return json;
    }

    static JSONArray toJSON(ProfileNode[] nodes) {
        JSONArray array = new JSONArray();
        for (ProfileNode node : nodes) {
            array.put((Object)node.toJSON());
        }
        return array;
    }
}

