/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector;

import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.instrumentation.LoadSourceEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceListener;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.chromeinspector.types.Script;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ScriptsHandler
implements LoadSourceListener {
    private final Map<Source, Integer> sourceIDs = new HashMap<Source, Integer>(100);
    private final List<Script> scripts = new ArrayList<Script>(100);
    private final Map<String, Integer> uniqueSourceNames = new HashMap<String, Integer>();
    private final List<LoadScriptListener> listeners = new ArrayList<LoadScriptListener>();
    private final boolean reportInternal;
    private final TruffleInstrument.Env env;
    private volatile DebuggerSession debuggerSession;

    ScriptsHandler(TruffleInstrument.Env env, boolean reportInternal) {
        this.env = env;
        this.reportInternal = reportInternal;
    }

    void setDebuggerSession(DebuggerSession debuggerSession) {
        this.debuggerSession = debuggerSession;
    }

    DebuggerSession getDebuggerSession() {
        return this.debuggerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScriptId(Source source) {
        Map<Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            Integer id = this.sourceIDs.get(source);
            if (id != null) {
                return id;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Script getScript(int id) {
        Map<Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            return this.scripts.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Script> getScripts() {
        Map<Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            return Collections.unmodifiableList(this.scripts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLoadScriptListener(LoadScriptListener listener) {
        ArrayList<Script> scriptsToNotify;
        Map<Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            scriptsToNotify = new ArrayList<Script>(this.scripts);
            this.listeners.add(listener);
        }
        for (Script scr : scriptsToNotify) {
            listener.loadedScript(scr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLoadScriptListener(LoadScriptListener listener) {
        Map<Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int assureLoaded(Source sourceLoaded) {
        DebuggerSession ds = this.debuggerSession;
        Source sourceResolved = sourceLoaded;
        if (ds != null) {
            sourceResolved = ds.resolveSource(sourceLoaded);
        }
        Source source = sourceResolved != null ? sourceResolved : sourceLoaded;
        LoadScriptListener[] loadScriptListenerArray = this.sourceIDs;
        synchronized (this.sourceIDs) {
            Integer eid = this.sourceIDs.get(source);
            if (eid != null) {
                // ** MonitorExit[var8_5] (shouldn't be in output)
                return eid;
            }
            int id = this.scripts.size();
            String sourceUrl = this.getSourceURL(source);
            Script scr = new Script(id, sourceUrl, source, sourceLoaded);
            this.sourceIDs.put(source, id);
            this.sourceIDs.put(sourceLoaded, id);
            this.scripts.add(scr);
            LoadScriptListener[] listenersToNotify = this.listeners.toArray(new LoadScriptListener[this.listeners.size()]);
            // ** MonitorExit[var8_5] (shouldn't be in output)
            for (LoadScriptListener l : listenersToNotify) {
                l.loadedScript(scr);
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSourceURL(Source source) {
        URL url = source.getURL();
        if (url != null) {
            return url.toExternalForm();
        }
        String path = source.getPath();
        if (path != null) {
            if (source.getURI().isAbsolute()) {
                return source.getURI().toString();
            }
            try {
                return this.env.getTruffleFile(path).getAbsoluteFile().toUri().toString();
            }
            catch (SecurityException ex) {
                if (File.separatorChar == '/') {
                    return path;
                }
                return path.replace(File.separatorChar, '/');
            }
        }
        String name = source.getName();
        if (name != null) {
            String uniqueName;
            Map<String, Integer> map = this.uniqueSourceNames;
            synchronized (map) {
                int count = this.uniqueSourceNames.getOrDefault(name, 0);
                if (++count == 1) {
                    uniqueName = name;
                } else {
                    while (this.uniqueSourceNames.containsKey(uniqueName = count + "/" + name) && count++ > 0) {
                    }
                }
                this.uniqueSourceNames.put(name, count);
            }
            return uniqueName;
        }
        return source.getURI().toString();
    }

    public void onLoad(LoadSourceEvent event) {
        Source source = event.getSource();
        if (this.reportInternal || !source.isInternal()) {
            this.assureLoaded(source);
        }
    }

    static boolean compareURLs(String url1, String url2) {
        String surl2;
        String surl1 = ScriptsHandler.stripScheme(url1);
        return surl1.equals(surl2 = ScriptsHandler.stripScheme(url2)) || surl1.startsWith("/") && surl1.substring(1).equals(surl2);
    }

    private static String stripScheme(String url) {
        if (url.startsWith("file://")) {
            return url.substring("file://".length());
        }
        return url;
    }

    static interface LoadScriptListener {
        public void loadedScript(Script var1);
    }
}

