/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.instrument;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;

public final class Token {
    private static final String HASH_FUNCTION = "SHA-256";
    private final byte[] token;

    private Token(byte[] token) {
        this.token = token;
    }

    public static Token createHashedTokenFromString(String secret) {
        try {
            return new Token(MessageDigest.getInstance(HASH_FUNCTION).digest(secret.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token1 = (Token)o;
        return MessageDigest.isEqual(this.token, token1.token);
    }

    public int hashCode() {
        return Arrays.hashCode(this.token);
    }

    public String toString() {
        return "Token{token=SHA-256:" + Base64.getEncoder().encodeToString(this.token) + "}";
    }
}

