// CheckStyle: start generated
package com.oracle.truffle.tools.dap.instrument;

import com.oracle.truffle.api.TruffleOptionDescriptors;
import com.oracle.truffle.api.dsl.GeneratedBy;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionStability;
import org.graalvm.polyglot.SandboxPolicy;

@GeneratedBy(DAPInstrument.class)
final class DAPInstrumentOptionDescriptors implements TruffleOptionDescriptors {

    @Override
    public OptionDescriptor get(String optionName) {
        switch (optionName) {
            case "dap" :
                return OptionDescriptor.newBuilder(DAPInstrument.Dap, "dap").deprecated(false).help("Start the Debug Protocol Server on [[host:]port] (default: <loopback address>:4711)").usageSyntax("[[<host>:]<port>]").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "dap.Initialization" :
                return OptionDescriptor.newBuilder(DAPInstrument.Initialization, "dap.Initialization").deprecated(false).help("Debug language initialization.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "dap.Internal" :
                return OptionDescriptor.newBuilder(DAPInstrument.Internal, "dap.Internal").deprecated(false).help("Debug internal sources.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "dap.SocketBacklogSize" :
                return OptionDescriptor.newBuilder(DAPInstrument.SocketBacklogSize, "dap.SocketBacklogSize").deprecated(false).help("Requested maximum length of the Socket queue of incoming connections (default: unspecified).").usageSyntax("[0, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "dap.SourcePath" :
                return OptionDescriptor.newBuilder(DAPInstrument.SourcePath, "dap.SourcePath").deprecated(false).help("Specifies list of directories or ZIP/JAR files representing source path (default: empty list).").usageSyntax("<path>,<path>,...").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "dap.Suspend" :
                return OptionDescriptor.newBuilder(DAPInstrument.Suspend, "dap.Suspend").deprecated(false).help("Suspend the execution at first executed source line (default: true).").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "dap.WaitAttached" :
                return OptionDescriptor.newBuilder(DAPInstrument.WaitAttached, "dap.WaitAttached").deprecated(false).help("Do not execute any source code until debugger client is attached.").usageSyntax("").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
        }
        return null;
    }

    @Override
    public SandboxPolicy getSandboxPolicy(String optionName) {
        assert get(optionName) != null : "Unknown option " + optionName;
        return SandboxPolicy.TRUSTED;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return Arrays.asList(
            OptionDescriptor.newBuilder(DAPInstrument.Dap, "dap").deprecated(false).help("Start the Debug Protocol Server on [[host:]port] (default: <loopback address>:4711)").usageSyntax("[[<host>:]<port>]").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(DAPInstrument.Initialization, "dap.Initialization").deprecated(false).help("Debug language initialization.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(DAPInstrument.Internal, "dap.Internal").deprecated(false).help("Debug internal sources.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(DAPInstrument.SocketBacklogSize, "dap.SocketBacklogSize").deprecated(false).help("Requested maximum length of the Socket queue of incoming connections (default: unspecified).").usageSyntax("[0, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(DAPInstrument.SourcePath, "dap.SourcePath").deprecated(false).help("Specifies list of directories or ZIP/JAR files representing source path (default: empty list).").usageSyntax("<path>,<path>,...").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(DAPInstrument.Suspend, "dap.Suspend").deprecated(false).help("Suspend the execution at first executed source line (default: true).").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(DAPInstrument.WaitAttached, "dap.WaitAttached").deprecated(false).help("Do not execute any source code until debugger client is attached.").usageSyntax("").category(OptionCategory.USER).stability(OptionStability.STABLE).build())
        .iterator();
    }

}
