/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class BreakpointLocation
extends JSONBase {
    BreakpointLocation(JSONObject jsonData) {
        super(jsonData);
    }

    public int getLine() {
        return this.jsonData.getInt("line");
    }

    public BreakpointLocation setLine(int line) {
        this.jsonData.put("line", line);
        return this;
    }

    public Integer getColumn() {
        return this.jsonData.has("column") ? Integer.valueOf(this.jsonData.getInt("column")) : null;
    }

    public BreakpointLocation setColumn(Integer column) {
        this.jsonData.putOpt("column", (Object)column);
        return this;
    }

    public Integer getEndLine() {
        return this.jsonData.has("endLine") ? Integer.valueOf(this.jsonData.getInt("endLine")) : null;
    }

    public BreakpointLocation setEndLine(Integer endLine) {
        this.jsonData.putOpt("endLine", (Object)endLine);
        return this;
    }

    public Integer getEndColumn() {
        return this.jsonData.has("endColumn") ? Integer.valueOf(this.jsonData.getInt("endColumn")) : null;
    }

    public BreakpointLocation setEndColumn(Integer endColumn) {
        this.jsonData.putOpt("endColumn", (Object)endColumn);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BreakpointLocation other = (BreakpointLocation)obj;
        if (this.getLine() != other.getLine()) {
            return false;
        }
        if (!Objects.equals(this.getColumn(), other.getColumn())) {
            return false;
        }
        if (!Objects.equals(this.getEndLine(), other.getEndLine())) {
            return false;
        }
        return Objects.equals(this.getEndColumn(), other.getEndColumn());
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + Integer.hashCode(this.getLine());
        if (this.getColumn() != null) {
            hash = 23 * hash + Integer.hashCode(this.getColumn());
        }
        if (this.getEndLine() != null) {
            hash = 23 * hash + Integer.hashCode(this.getEndLine());
        }
        if (this.getEndColumn() != null) {
            hash = 23 * hash + Integer.hashCode(this.getEndColumn());
        }
        return hash;
    }

    public static BreakpointLocation create(Integer line) {
        JSONObject json = new JSONObject();
        json.put("line", (Object)line);
        return new BreakpointLocation(json);
    }
}

