/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Capabilities;
import com.oracle.truffle.tools.dap.types.Event;
import com.oracle.truffle.tools.dap.types.JSONBase;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class CapabilitiesEvent
extends Event {
    CapabilitiesEvent(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public EventBody getBody() {
        return new EventBody(this.jsonData.getJSONObject("body"));
    }

    public CapabilitiesEvent setBody(EventBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CapabilitiesEvent other = (CapabilitiesEvent)obj;
        if (!Objects.equals(this.getEvent(), other.getEvent())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.getEvent());
        hash = 59 * hash + Objects.hashCode(this.getBody());
        hash = 59 * hash + Objects.hashCode(this.getType());
        hash = 59 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static CapabilitiesEvent create(EventBody body, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("event", (Object)"capabilities");
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"event");
        json.put("seq", (Object)seq);
        return new CapabilitiesEvent(json);
    }

    public static class EventBody
    extends JSONBase {
        EventBody(JSONObject jsonData) {
            super(jsonData);
        }

        public Capabilities getCapabilities() {
            return new Capabilities(this.jsonData.getJSONObject("capabilities"));
        }

        public EventBody setCapabilities(Capabilities capabilities) {
            this.jsonData.put("capabilities", (Object)capabilities.jsonData);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventBody other = (EventBody)obj;
            return Objects.equals(this.getCapabilities(), other.getCapabilities());
        }

        public int hashCode() {
            int hash = 7;
            hash = 23 * hash + Objects.hashCode(this.getCapabilities());
            return hash;
        }

        public static EventBody create(Capabilities capabilities) {
            JSONObject json = new JSONObject();
            json.put("capabilities", (Object)capabilities.jsonData);
            return new EventBody(json);
        }
    }
}

