/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import com.oracle.truffle.tools.dap.types.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public class DataBreakpointInfoResponse
extends Response {
    DataBreakpointInfoResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public DataBreakpointInfoResponse setBody(ResponseBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataBreakpointInfoResponse other = (DataBreakpointInfoResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Objects.hashCode(this.getBody());
        hash = 37 * hash + Objects.hashCode(this.getType());
        hash = 37 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 37 * hash + Boolean.hashCode(this.isSuccess());
        hash = 37 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 37 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 37 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static DataBreakpointInfoResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"response");
        json.put("request_seq", (Object)requestSeq);
        json.put("success", (Object)success);
        json.put("command", (Object)command);
        json.put("seq", (Object)seq);
        return new DataBreakpointInfoResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public String getDataId() {
            Object obj = this.jsonData.get("dataId");
            return JSONObject.NULL.equals(obj) ? null : (String)obj;
        }

        public ResponseBody setDataId(String dataId) {
            this.jsonData.put("dataId", dataId == null ? JSONObject.NULL : dataId);
            return this;
        }

        public String getDescription() {
            return this.jsonData.getString("description");
        }

        public ResponseBody setDescription(String description) {
            this.jsonData.put("description", (Object)description);
            return this;
        }

        public List<String> getAccessTypes() {
            JSONArray json = this.jsonData.optJSONArray("accessTypes");
            if (json == null) {
                return null;
            }
            ArrayList<String> list = new ArrayList<String>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(json.getString(i));
            }
            return Collections.unmodifiableList(list);
        }

        public ResponseBody setAccessTypes(List<String> accessTypes) {
            if (accessTypes != null) {
                JSONArray json = new JSONArray();
                for (String string : accessTypes) {
                    json.put((Object)string);
                }
                this.jsonData.put("accessTypes", (Object)json);
            }
            return this;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
        public Boolean getCanPersist() {
            return this.jsonData.has("canPersist") ? Boolean.valueOf(this.jsonData.getBoolean("canPersist")) : null;
        }

        public ResponseBody setCanPersist(Boolean canPersist) {
            this.jsonData.putOpt("canPersist", (Object)canPersist);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            if (!Objects.equals(this.getDataId(), other.getDataId())) {
                return false;
            }
            if (!Objects.equals(this.getDescription(), other.getDescription())) {
                return false;
            }
            if (!Objects.equals(this.getAccessTypes(), other.getAccessTypes())) {
                return false;
            }
            return Objects.equals(this.getCanPersist(), other.getCanPersist());
        }

        public int hashCode() {
            int hash = 5;
            if (this.getDataId() != null) {
                hash = 29 * hash + Objects.hashCode(this.getDataId());
            }
            hash = 29 * hash + Objects.hashCode(this.getDescription());
            if (this.getAccessTypes() != null) {
                hash = 29 * hash + Objects.hashCode(this.getAccessTypes());
            }
            if (this.getCanPersist() != null) {
                hash = 29 * hash + Boolean.hashCode(this.getCanPersist());
            }
            return hash;
        }

        public static ResponseBody create(String dataId, String description) {
            JSONObject json = new JSONObject();
            json.put("dataId", dataId == null ? JSONObject.NULL : dataId);
            json.put("description", (Object)description);
            return new ResponseBody(json);
        }
    }
}

