/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class GotoTarget
extends JSONBase {
    GotoTarget(JSONObject jsonData) {
        super(jsonData);
    }

    public int getId() {
        return this.jsonData.getInt("id");
    }

    public GotoTarget setId(int id) {
        this.jsonData.put("id", id);
        return this;
    }

    public String getLabel() {
        return this.jsonData.getString("label");
    }

    public GotoTarget setLabel(String label) {
        this.jsonData.put("label", (Object)label);
        return this;
    }

    public int getLine() {
        return this.jsonData.getInt("line");
    }

    public GotoTarget setLine(int line) {
        this.jsonData.put("line", line);
        return this;
    }

    public Integer getColumn() {
        return this.jsonData.has("column") ? Integer.valueOf(this.jsonData.getInt("column")) : null;
    }

    public GotoTarget setColumn(Integer column) {
        this.jsonData.putOpt("column", (Object)column);
        return this;
    }

    public Integer getEndLine() {
        return this.jsonData.has("endLine") ? Integer.valueOf(this.jsonData.getInt("endLine")) : null;
    }

    public GotoTarget setEndLine(Integer endLine) {
        this.jsonData.putOpt("endLine", (Object)endLine);
        return this;
    }

    public Integer getEndColumn() {
        return this.jsonData.has("endColumn") ? Integer.valueOf(this.jsonData.getInt("endColumn")) : null;
    }

    public GotoTarget setEndColumn(Integer endColumn) {
        this.jsonData.putOpt("endColumn", (Object)endColumn);
        return this;
    }

    public String getInstructionPointerReference() {
        return this.jsonData.optString("instructionPointerReference", null);
    }

    public GotoTarget setInstructionPointerReference(String instructionPointerReference) {
        this.jsonData.putOpt("instructionPointerReference", (Object)instructionPointerReference);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GotoTarget other = (GotoTarget)obj;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (!Objects.equals(this.getLabel(), other.getLabel())) {
            return false;
        }
        if (this.getLine() != other.getLine()) {
            return false;
        }
        if (!Objects.equals(this.getColumn(), other.getColumn())) {
            return false;
        }
        if (!Objects.equals(this.getEndLine(), other.getEndLine())) {
            return false;
        }
        if (!Objects.equals(this.getEndColumn(), other.getEndColumn())) {
            return false;
        }
        return Objects.equals(this.getInstructionPointerReference(), other.getInstructionPointerReference());
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Integer.hashCode(this.getId());
        hash = 59 * hash + Objects.hashCode(this.getLabel());
        hash = 59 * hash + Integer.hashCode(this.getLine());
        if (this.getColumn() != null) {
            hash = 59 * hash + Integer.hashCode(this.getColumn());
        }
        if (this.getEndLine() != null) {
            hash = 59 * hash + Integer.hashCode(this.getEndLine());
        }
        if (this.getEndColumn() != null) {
            hash = 59 * hash + Integer.hashCode(this.getEndColumn());
        }
        if (this.getInstructionPointerReference() != null) {
            hash = 59 * hash + Objects.hashCode(this.getInstructionPointerReference());
        }
        return hash;
    }

    public static GotoTarget create(Integer id, String label, Integer line) {
        JSONObject json = new JSONObject();
        json.put("id", (Object)id);
        json.put("label", (Object)label);
        json.put("line", (Object)line);
        return new GotoTarget(json);
    }
}

