/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.GotoTarget;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public class GotoTargetsResponse
extends Response {
    GotoTargetsResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public GotoTargetsResponse setBody(ResponseBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GotoTargetsResponse other = (GotoTargetsResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 2;
        hash = 53 * hash + Objects.hashCode(this.getBody());
        hash = 53 * hash + Objects.hashCode(this.getType());
        hash = 53 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 53 * hash + Boolean.hashCode(this.isSuccess());
        hash = 53 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 53 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 53 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static GotoTargetsResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"response");
        json.put("request_seq", (Object)requestSeq);
        json.put("success", (Object)success);
        json.put("command", (Object)command);
        json.put("seq", (Object)seq);
        return new GotoTargetsResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public List<GotoTarget> getTargets() {
            JSONArray json = this.jsonData.getJSONArray("targets");
            ArrayList<GotoTarget> list = new ArrayList<GotoTarget>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(new GotoTarget(json.getJSONObject(i)));
            }
            return Collections.unmodifiableList(list);
        }

        public ResponseBody setTargets(List<GotoTarget> targets) {
            JSONArray json = new JSONArray();
            for (GotoTarget gotoTarget : targets) {
                json.put((Object)gotoTarget.jsonData);
            }
            this.jsonData.put("targets", (Object)json);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            return Objects.equals(this.getTargets(), other.getTargets());
        }

        public int hashCode() {
            int hash = 2;
            hash = 67 * hash + Objects.hashCode(this.getTargets());
            return hash;
        }

        public static ResponseBody create(List<GotoTarget> targets) {
            JSONObject json = new JSONObject();
            JSONArray targetsJsonArr = new JSONArray();
            for (GotoTarget gotoTarget : targets) {
                targetsJsonArr.put((Object)gotoTarget.jsonData);
            }
            json.put("targets", (Object)targetsJsonArr);
            return new ResponseBody(json);
        }
    }
}

