/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.ExceptionOptions;
import com.oracle.truffle.tools.dap.types.JSONBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public class SetExceptionBreakpointsArguments
extends JSONBase {
    SetExceptionBreakpointsArguments(JSONObject jsonData) {
        super(jsonData);
    }

    public List<String> getFilters() {
        JSONArray json = this.jsonData.getJSONArray("filters");
        ArrayList<String> list = new ArrayList<String>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.getString(i));
        }
        return Collections.unmodifiableList(list);
    }

    public SetExceptionBreakpointsArguments setFilters(List<String> filters) {
        JSONArray json = new JSONArray();
        for (String string : filters) {
            json.put((Object)string);
        }
        this.jsonData.put("filters", (Object)json);
        return this;
    }

    public List<ExceptionOptions> getExceptionOptions() {
        JSONArray json = this.jsonData.optJSONArray("exceptionOptions");
        if (json == null) {
            return null;
        }
        ArrayList<ExceptionOptions> list = new ArrayList<ExceptionOptions>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new ExceptionOptions(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public SetExceptionBreakpointsArguments setExceptionOptions(List<ExceptionOptions> exceptionOptions) {
        if (exceptionOptions != null) {
            JSONArray json = new JSONArray();
            for (ExceptionOptions options : exceptionOptions) {
                json.put((Object)options.jsonData);
            }
            this.jsonData.put("exceptionOptions", (Object)json);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetExceptionBreakpointsArguments other = (SetExceptionBreakpointsArguments)obj;
        if (!Objects.equals(this.getFilters(), other.getFilters())) {
            return false;
        }
        return Objects.equals(this.getExceptionOptions(), other.getExceptionOptions());
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + Objects.hashCode(this.getFilters());
        if (this.getExceptionOptions() != null) {
            hash = 61 * hash + Objects.hashCode(this.getExceptionOptions());
        }
        return hash;
    }

    public static SetExceptionBreakpointsArguments create(List<String> filters) {
        JSONObject json = new JSONObject();
        JSONArray filtersJsonArr = new JSONArray();
        for (String string : filters) {
            filtersJsonArr.put((Object)string);
        }
        json.put("filters", (Object)filtersJsonArr);
        return new SetExceptionBreakpointsArguments(json);
    }
}

