/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.FunctionBreakpoint;
import com.oracle.truffle.tools.dap.types.JSONBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public class SetFunctionBreakpointsArguments
extends JSONBase {
    SetFunctionBreakpointsArguments(JSONObject jsonData) {
        super(jsonData);
    }

    public List<FunctionBreakpoint> getBreakpoints() {
        JSONArray json = this.jsonData.getJSONArray("breakpoints");
        ArrayList<FunctionBreakpoint> list = new ArrayList<FunctionBreakpoint>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new FunctionBreakpoint(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public SetFunctionBreakpointsArguments setBreakpoints(List<FunctionBreakpoint> breakpoints) {
        JSONArray json = new JSONArray();
        for (FunctionBreakpoint functionBreakpoint : breakpoints) {
            json.put((Object)functionBreakpoint.jsonData);
        }
        this.jsonData.put("breakpoints", (Object)json);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetFunctionBreakpointsArguments other = (SetFunctionBreakpointsArguments)obj;
        return Objects.equals(this.getBreakpoints(), other.getBreakpoints());
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.getBreakpoints());
        return hash;
    }

    public static SetFunctionBreakpointsArguments create(List<FunctionBreakpoint> breakpoints) {
        JSONObject json = new JSONObject();
        JSONArray breakpointsJsonArr = new JSONArray();
        for (FunctionBreakpoint functionBreakpoint : breakpoints) {
            breakpointsJsonArr.put((Object)functionBreakpoint.jsonData);
        }
        json.put("breakpoints", (Object)breakpointsJsonArr);
        return new SetFunctionBreakpointsArguments(json);
    }
}

