/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import com.oracle.truffle.tools.dap.types.StackFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public class StackTraceResponse
extends Response {
    StackTraceResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public StackTraceResponse setBody(ResponseBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StackTraceResponse other = (StackTraceResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.getBody());
        hash = 89 * hash + Objects.hashCode(this.getType());
        hash = 89 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 89 * hash + Boolean.hashCode(this.isSuccess());
        hash = 89 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 89 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 89 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static StackTraceResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"response");
        json.put("request_seq", (Object)requestSeq);
        json.put("success", (Object)success);
        json.put("command", (Object)command);
        json.put("seq", (Object)seq);
        return new StackTraceResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public List<StackFrame> getStackFrames() {
            JSONArray json = this.jsonData.getJSONArray("stackFrames");
            ArrayList<StackFrame> list = new ArrayList<StackFrame>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(new StackFrame(json.getJSONObject(i)));
            }
            return Collections.unmodifiableList(list);
        }

        public ResponseBody setStackFrames(List<StackFrame> stackFrames) {
            JSONArray json = new JSONArray();
            for (StackFrame stackFrame : stackFrames) {
                json.put((Object)stackFrame.jsonData);
            }
            this.jsonData.put("stackFrames", (Object)json);
            return this;
        }

        public Integer getTotalFrames() {
            return this.jsonData.has("totalFrames") ? Integer.valueOf(this.jsonData.getInt("totalFrames")) : null;
        }

        public ResponseBody setTotalFrames(Integer totalFrames) {
            this.jsonData.putOpt("totalFrames", (Object)totalFrames);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            if (!Objects.equals(this.getStackFrames(), other.getStackFrames())) {
                return false;
            }
            return Objects.equals(this.getTotalFrames(), other.getTotalFrames());
        }

        public int hashCode() {
            int hash = 3;
            hash = 13 * hash + Objects.hashCode(this.getStackFrames());
            if (this.getTotalFrames() != null) {
                hash = 13 * hash + Integer.hashCode(this.getTotalFrames());
            }
            return hash;
        }

        public static ResponseBody create(List<StackFrame> stackFrames) {
            JSONObject json = new JSONObject();
            JSONArray stackFramesJsonArr = new JSONArray();
            for (StackFrame stackFrame : stackFrames) {
                stackFramesJsonArr.put((Object)stackFrame.jsonData);
            }
            json.put("stackFrames", (Object)stackFramesJsonArr);
            return new ResponseBody(json);
        }
    }
}

