/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Event;
import com.oracle.truffle.tools.dap.types.JSONBase;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class ThreadEvent
extends Event {
    ThreadEvent(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public EventBody getBody() {
        return new EventBody(this.jsonData.getJSONObject("body"));
    }

    public ThreadEvent setBody(EventBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadEvent other = (ThreadEvent)obj;
        if (!Objects.equals(this.getEvent(), other.getEvent())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode(this.getEvent());
        hash = 79 * hash + Objects.hashCode(this.getBody());
        hash = 79 * hash + Objects.hashCode(this.getType());
        hash = 79 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static ThreadEvent create(EventBody body, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("event", (Object)"thread");
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"event");
        json.put("seq", (Object)seq);
        return new ThreadEvent(json);
    }

    public static class EventBody
    extends JSONBase {
        EventBody(JSONObject jsonData) {
            super(jsonData);
        }

        public String getReason() {
            return this.jsonData.getString("reason");
        }

        public EventBody setReason(String reason) {
            this.jsonData.put("reason", (Object)reason);
            return this;
        }

        public int getThreadId() {
            return this.jsonData.getInt("threadId");
        }

        public EventBody setThreadId(int threadId) {
            this.jsonData.put("threadId", threadId);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventBody other = (EventBody)obj;
            if (!Objects.equals(this.getReason(), other.getReason())) {
                return false;
            }
            return this.getThreadId() == other.getThreadId();
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + Objects.hashCode(this.getReason());
            hash = 89 * hash + Integer.hashCode(this.getThreadId());
            return hash;
        }

        public static EventBody create(String reason, Integer threadId) {
            JSONObject json = new JSONObject();
            json.put("reason", (Object)reason);
            json.put("threadId", (Object)threadId);
            return new EventBody(json);
        }
    }
}

