/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import com.oracle.truffle.tools.dap.types.Thread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public class ThreadsResponse
extends Response {
    ThreadsResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public ThreadsResponse setBody(ResponseBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadsResponse other = (ThreadsResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + Objects.hashCode(this.getBody());
        hash = 11 * hash + Objects.hashCode(this.getType());
        hash = 11 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 11 * hash + Boolean.hashCode(this.isSuccess());
        hash = 11 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 11 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 11 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static ThreadsResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"response");
        json.put("request_seq", (Object)requestSeq);
        json.put("success", (Object)success);
        json.put("command", (Object)command);
        json.put("seq", (Object)seq);
        return new ThreadsResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public List<Thread> getThreads() {
            JSONArray json = this.jsonData.getJSONArray("threads");
            ArrayList<Thread> list = new ArrayList<Thread>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(new Thread(json.getJSONObject(i)));
            }
            return Collections.unmodifiableList(list);
        }

        public ResponseBody setThreads(List<Thread> threads) {
            JSONArray json = new JSONArray();
            for (Thread thread : threads) {
                json.put((Object)thread.jsonData);
            }
            this.jsonData.put("threads", (Object)json);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            return Objects.equals(this.getThreads(), other.getThreads());
        }

        public int hashCode() {
            int hash = 5;
            hash = 37 * hash + Objects.hashCode(this.getThreads());
            return hash;
        }

        public static ResponseBody create(List<Thread> threads) {
            JSONObject json = new JSONObject();
            JSONArray threadsJsonArr = new JSONArray();
            for (Thread thread : threads) {
                threadsJsonArr.put((Object)thread.jsonData);
            }
            json.put("threads", (Object)threadsJsonArr);
            return new ResponseBody(json);
        }
    }
}

