/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.instrument;

import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.tools.dap.instrument.DAPIOException;
import com.oracle.truffle.tools.dap.instrument.DAPInstrumentOptionDescriptors;
import com.oracle.truffle.tools.dap.server.DebugProtocolServerImpl;
import com.oracle.truffle.tools.dap.server.ExecutionContext;
import java.io.File;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.options.OptionValues;

@TruffleInstrument.Registration(id="dap", name="Debug Protocol Server", version="0.1", website="https://www.graalvm.org/tools/dap/")
public final class DAPInstrument
extends TruffleInstrument {
    public static final String ID = "dap";
    private static final int DEFAULT_PORT = 4711;
    private static final HostAndPort DEFAULT_ADDRESS = new HostAndPort(null, 4711);
    private OptionValues options;
    static final OptionType<HostAndPort> ADDRESS_OR_BOOLEAN = new OptionType("[[host:]port]", address -> {
        if (address.isEmpty() || address.equals("true")) {
            return DEFAULT_ADDRESS;
        }
        return HostAndPort.parse(address);
    }, address -> address.verify());
    static final OptionType<List<URI>> SOURCE_PATH = new OptionType("folder" + File.pathSeparator + "file.zip" + File.pathSeparator + "...", str -> {
        if (str.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        int i1 = 0;
        while (i1 < str.length()) {
            int i2 = str.indexOf(File.pathSeparatorChar, i1);
            if (i2 < 0) {
                i2 = str.length();
            }
            String path = str.substring(i1, i2);
            try {
                uris.add(DAPInstrument.createURIFromPath(path));
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("Wrong path: " + path, ex);
            }
            i1 = i2 + 1;
        }
        return uris;
    });
    @Option(name="", help="Start the Debug Protocol Server on [[host:]port] (default: <loopback address>:4711)", usageSyntax="[[<host>:]<port>]", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<HostAndPort> Dap = new OptionKey((Object)DEFAULT_ADDRESS, ADDRESS_OR_BOOLEAN);
    @Option(help="Suspend the execution at first executed source line (default: true).", usageSyntax="true|false", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> Suspend = new OptionKey((Object)true);
    private static final String SOURCE_PATH_USAGE = "<path>,<path>,...";
    @Option(help="Specifies list of directories or ZIP/JAR files representing source path (default: empty list).", usageSyntax="<path>,<path>,...", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<List<URI>> SourcePath = new OptionKey(Collections.emptyList(), SOURCE_PATH);
    @Option(help="Do not execute any source code until debugger client is attached.", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> WaitAttached = new OptionKey((Object)false);
    @Option(help="Debug internal sources.", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> Internal = new OptionKey((Object)false);
    @Option(help="Debug language initialization.", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> Initialization = new OptionKey((Object)false);
    @Option(help="Requested maximum length of the Socket queue of incoming connections (default: unspecified).", usageSyntax="[0, inf)", category=OptionCategory.EXPERT)
    static final OptionKey<Integer> SocketBacklogSize = new OptionKey((Object)-1);
    private DebugProtocolServerImpl dapServer;

    private static URI createURIFromPath(String path) throws URISyntaxException {
        String lpath = path.toLowerCase();
        int index = 0;
        File jarFile = null;
        while (index < lpath.length()) {
            int zi = lpath.indexOf(".zip", index);
            int ji = lpath.indexOf(".jar", index);
            if (zi >= 0 && zi < ji || ji < 0) {
                ji = zi;
            }
            if (ji >= 0) {
                index = ji + 4;
                File jar = new File(path.substring(0, index));
                if (!jar.isFile()) continue;
                jarFile = jar;
                break;
            }
            index = path.length();
        }
        if (jarFile != null) {
            StringBuilder ssp = new StringBuilder("file://").append(jarFile.toPath().toUri().getPath());
            if (index < path.length()) {
                if (path.charAt(index) != '!') {
                    ssp.append('!');
                }
                ssp.append(path.substring(index));
            } else {
                ssp.append("!/");
            }
            return new URI("jar", ssp.toString(), null);
        }
        return new File(path).toPath().toUri();
    }

    protected void onCreate(TruffleInstrument.Env env) {
        this.options = env.getOptions();
        if (this.options.hasSetOptions()) {
            this.launchServer(env, new PrintWriter(env.out(), true), new PrintWriter(env.err(), true));
        }
    }

    protected void onFinalize(TruffleInstrument.Env env) {
        if (this.dapServer != null) {
            this.dapServer.dispose();
        }
    }

    protected OptionDescriptors getOptionDescriptors() {
        DAPInstrumentOptionDescriptors descriptors = new DAPInstrumentOptionDescriptors();
        return new OptionDescriptors(){
            final /* synthetic */ OptionDescriptors val$descriptors;
            final /* synthetic */ DAPInstrument this$0;
            {
                this.val$descriptors = optionDescriptors;
                this.this$0 = this$0;
            }

            public OptionDescriptor get(String optionName) {
                return this.val$descriptors.get(optionName);
            }

            public Iterator<OptionDescriptor> iterator() {
                final Iterator iterator = this.val$descriptors.iterator();
                return new Iterator<OptionDescriptor>(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public OptionDescriptor next() {
                        OptionDescriptor descriptor = (OptionDescriptor)iterator.next();
                        if (descriptor.getKey() == SourcePath) {
                            String example = " Example: " + File.separator + "projects" + File.separator + "foo" + File.separator + "src" + File.pathSeparator + "sources.jar" + File.pathSeparator + "package.zip!/src";
                            descriptor = OptionDescriptor.newBuilder(SourcePath, (String)descriptor.getName()).deprecated(descriptor.isDeprecated()).category(descriptor.getCategory()).help(descriptor.getHelp() + example).usageSyntax(DAPInstrument.SOURCE_PATH_USAGE).build();
                        }
                        return descriptor;
                    }
                };
            }
        };
    }

    private void launchServer(TruffleInstrument.Env env, PrintWriter info, PrintWriter err) {
        assert (this.options != null);
        assert (this.options.hasSetOptions());
        HostAndPort hostAndPort = (HostAndPort)this.options.get(Dap);
        try {
            InetSocketAddress socketAddress = hostAndPort.createSocket();
            int port = socketAddress.getPort();
            ExecutionContext context = new ExecutionContext(env, info, err, (Boolean)this.options.get(Internal), (Boolean)this.options.get(Initialization));
            ServerSocket serverSocket = new ServerSocket(port, (Integer)this.options.get(SocketBacklogSize), socketAddress.getAddress());
            this.dapServer = DebugProtocolServerImpl.create(context, (Boolean)this.options.get(Suspend), (Boolean)this.options.get(WaitAttached), (Boolean)this.options.get(Initialization), (List)this.options.get(SourcePath));
            this.dapServer.start(serverSocket).exceptionally(throwable -> {
                throwable.printStackTrace(err);
                return null;
            });
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            String message = String.format(Locale.ENGLISH, "[Graal DAP] Starting server on %s failed: %s", hostAndPort.getHostPort(), e.getLocalizedMessage());
            new DAPIOException(message, e).printStackTrace(err);
        }
    }

    static final class HostAndPort {
        private final String host;
        private String portStr;
        private int port;
        private InetAddress inetAddress;

        private HostAndPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        private HostAndPort(String host, String portStr) {
            this.host = host;
            this.portStr = portStr;
        }

        static HostAndPort parse(String address) {
            String host;
            String port;
            int colon = address.indexOf(58);
            if (colon >= 0) {
                port = address.substring(colon + 1);
                host = address.substring(0, colon);
            } else {
                try {
                    Integer.parseInt(address);
                    port = address;
                    host = null;
                }
                catch (NumberFormatException e) {
                    port = Integer.toString(4711);
                    host = address;
                }
            }
            return new HostAndPort(host, port);
        }

        void verify() {
            if (this.port == 0) {
                try {
                    this.port = Integer.parseInt(this.portStr);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Port is not a number: " + this.portStr);
                }
            }
            if (this.port != 0 && (this.port < 1024 || 65535 < this.port)) {
                throw new IllegalArgumentException("Invalid port number: " + this.port + ". Needs to be 0, or in range from 1024 to 65535.");
            }
            if (this.host != null && !this.host.isEmpty()) {
                try {
                    this.inetAddress = InetAddress.getByName(this.host);
                }
                catch (UnknownHostException ex) {
                    throw new IllegalArgumentException(ex.getLocalizedMessage(), ex);
                }
            }
        }

        String getHostPort() {
            String hostName = this.host;
            if (hostName == null || hostName.isEmpty()) {
                hostName = this.inetAddress != null ? this.inetAddress.toString() : InetAddress.getLoopbackAddress().toString();
            }
            return hostName + ":" + this.port;
        }

        InetSocketAddress createSocket() {
            InetAddress ia = this.inetAddress == null ? InetAddress.getLoopbackAddress() : this.inetAddress;
            return new InetSocketAddress(ia, this.port);
        }

        public String toString() {
            return (this.host != null ? this.host : "<loopback address>") + ":" + this.port;
        }
    }
}

