/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.BreakpointLocation;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public class BreakpointLocationsResponse
extends Response {
    BreakpointLocationsResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public BreakpointLocationsResponse setBody(ResponseBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BreakpointLocationsResponse other = (BreakpointLocationsResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.getBody());
        hash = 59 * hash + Objects.hashCode(this.getType());
        hash = 59 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 59 * hash + Boolean.hashCode(this.isSuccess());
        hash = 59 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 59 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 59 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static BreakpointLocationsResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"response");
        json.put("request_seq", (Object)requestSeq);
        json.put("success", (Object)success);
        json.put("command", (Object)command);
        json.put("seq", (Object)seq);
        return new BreakpointLocationsResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public List<BreakpointLocation> getBreakpoints() {
            JSONArray json = this.jsonData.getJSONArray("breakpoints");
            ArrayList<BreakpointLocation> list = new ArrayList<BreakpointLocation>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(new BreakpointLocation(json.getJSONObject(i)));
            }
            return Collections.unmodifiableList(list);
        }

        public ResponseBody setBreakpoints(List<BreakpointLocation> breakpoints) {
            JSONArray json = new JSONArray();
            for (BreakpointLocation breakpointLocation : breakpoints) {
                json.put((Object)breakpointLocation.jsonData);
            }
            this.jsonData.put("breakpoints", (Object)json);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            return Objects.equals(this.getBreakpoints(), other.getBreakpoints());
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + Objects.hashCode(this.getBreakpoints());
            return hash;
        }

        public static ResponseBody create(List<BreakpointLocation> breakpoints) {
            JSONObject json = new JSONObject();
            JSONArray breakpointsJsonArr = new JSONArray();
            for (BreakpointLocation breakpointLocation : breakpoints) {
                breakpointsJsonArr.put((Object)breakpointLocation.jsonData);
            }
            json.put("breakpoints", (Object)breakpointsJsonArr);
            return new ResponseBody(json);
        }
    }
}

