/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class ColumnDescriptor
extends JSONBase {
    ColumnDescriptor(JSONObject jsonData) {
        super(jsonData);
    }

    public String getAttributeName() {
        return this.jsonData.getString("attributeName");
    }

    public ColumnDescriptor setAttributeName(String attributeName) {
        this.jsonData.put("attributeName", (Object)attributeName);
        return this;
    }

    public String getLabel() {
        return this.jsonData.getString("label");
    }

    public ColumnDescriptor setLabel(String label) {
        this.jsonData.put("label", (Object)label);
        return this;
    }

    public String getFormat() {
        return this.jsonData.optString("format", null);
    }

    public ColumnDescriptor setFormat(String format) {
        this.jsonData.putOpt("format", (Object)format);
        return this;
    }

    public String getType() {
        return this.jsonData.optString("type", null);
    }

    public ColumnDescriptor setType(String type) {
        this.jsonData.putOpt("type", (Object)type);
        return this;
    }

    public Integer getWidth() {
        return this.jsonData.has("width") ? Integer.valueOf(this.jsonData.getInt("width")) : null;
    }

    public ColumnDescriptor setWidth(Integer width) {
        this.jsonData.putOpt("width", (Object)width);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnDescriptor other = (ColumnDescriptor)obj;
        if (!Objects.equals(this.getAttributeName(), other.getAttributeName())) {
            return false;
        }
        if (!Objects.equals(this.getLabel(), other.getLabel())) {
            return false;
        }
        if (!Objects.equals(this.getFormat(), other.getFormat())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return Objects.equals(this.getWidth(), other.getWidth());
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.getAttributeName());
        hash = 67 * hash + Objects.hashCode(this.getLabel());
        if (this.getFormat() != null) {
            hash = 67 * hash + Objects.hashCode(this.getFormat());
        }
        if (this.getType() != null) {
            hash = 67 * hash + Objects.hashCode(this.getType());
        }
        if (this.getWidth() != null) {
            hash = 67 * hash + Integer.hashCode(this.getWidth());
        }
        return hash;
    }

    public static ColumnDescriptor create(String attributeName, String label) {
        JSONObject json = new JSONObject();
        json.put("attributeName", (Object)attributeName);
        json.put("label", (Object)label);
        return new ColumnDescriptor(json);
    }
}

