/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class CompletionItem
extends JSONBase {
    CompletionItem(JSONObject jsonData) {
        super(jsonData);
    }

    public String getLabel() {
        return this.jsonData.getString("label");
    }

    public CompletionItem setLabel(String label) {
        this.jsonData.put("label", (Object)label);
        return this;
    }

    public String getText() {
        return this.jsonData.optString("text", null);
    }

    public CompletionItem setText(String text) {
        this.jsonData.putOpt("text", (Object)text);
        return this;
    }

    public String getSortText() {
        return this.jsonData.optString("sortText", null);
    }

    public CompletionItem setSortText(String sortText) {
        this.jsonData.putOpt("sortText", (Object)sortText);
        return this;
    }

    public String getType() {
        return this.jsonData.optString("type", null);
    }

    public CompletionItem setType(String type) {
        this.jsonData.putOpt("type", (Object)type);
        return this;
    }

    public Integer getStart() {
        return this.jsonData.has("start") ? Integer.valueOf(this.jsonData.getInt("start")) : null;
    }

    public CompletionItem setStart(Integer start) {
        this.jsonData.putOpt("start", (Object)start);
        return this;
    }

    public Integer getLength() {
        return this.jsonData.has("length") ? Integer.valueOf(this.jsonData.getInt("length")) : null;
    }

    public CompletionItem setLength(Integer length) {
        this.jsonData.putOpt("length", (Object)length);
        return this;
    }

    public Integer getSelectionStart() {
        return this.jsonData.has("selectionStart") ? Integer.valueOf(this.jsonData.getInt("selectionStart")) : null;
    }

    public CompletionItem setSelectionStart(Integer selectionStart) {
        this.jsonData.putOpt("selectionStart", (Object)selectionStart);
        return this;
    }

    public Integer getSelectionLength() {
        return this.jsonData.has("selectionLength") ? Integer.valueOf(this.jsonData.getInt("selectionLength")) : null;
    }

    public CompletionItem setSelectionLength(Integer selectionLength) {
        this.jsonData.putOpt("selectionLength", (Object)selectionLength);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompletionItem other = (CompletionItem)obj;
        if (!Objects.equals(this.getLabel(), other.getLabel())) {
            return false;
        }
        if (!Objects.equals(this.getText(), other.getText())) {
            return false;
        }
        if (!Objects.equals(this.getSortText(), other.getSortText())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (!Objects.equals(this.getStart(), other.getStart())) {
            return false;
        }
        if (!Objects.equals(this.getLength(), other.getLength())) {
            return false;
        }
        if (!Objects.equals(this.getSelectionStart(), other.getSelectionStart())) {
            return false;
        }
        return Objects.equals(this.getSelectionLength(), other.getSelectionLength());
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.getLabel());
        if (this.getText() != null) {
            hash = 41 * hash + Objects.hashCode(this.getText());
        }
        if (this.getSortText() != null) {
            hash = 41 * hash + Objects.hashCode(this.getSortText());
        }
        if (this.getType() != null) {
            hash = 41 * hash + Objects.hashCode(this.getType());
        }
        if (this.getStart() != null) {
            hash = 41 * hash + Integer.hashCode(this.getStart());
        }
        if (this.getLength() != null) {
            hash = 41 * hash + Integer.hashCode(this.getLength());
        }
        if (this.getSelectionStart() != null) {
            hash = 41 * hash + Integer.hashCode(this.getSelectionStart());
        }
        if (this.getSelectionLength() != null) {
            hash = 41 * hash + Integer.hashCode(this.getSelectionLength());
        }
        return hash;
    }

    public static CompletionItem create(String label) {
        JSONObject json = new JSONObject();
        json.put("label", (Object)label);
        return new CompletionItem(json);
    }
}

