/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import com.oracle.truffle.tools.dap.types.SuppressFBWarnings;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class ContinueResponse
extends Response {
    ContinueResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public ContinueResponse setBody(ResponseBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContinueResponse other = (ContinueResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.getBody());
        hash = 37 * hash + Objects.hashCode(this.getType());
        hash = 37 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 37 * hash + Boolean.hashCode(this.isSuccess());
        hash = 37 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 37 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 37 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static ContinueResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"response");
        json.put("request_seq", (Object)requestSeq);
        json.put("success", (Object)success);
        json.put("command", (Object)command);
        json.put("seq", (Object)seq);
        return new ContinueResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
        public Boolean getAllThreadsContinued() {
            return this.jsonData.has("allThreadsContinued") ? Boolean.valueOf(this.jsonData.getBoolean("allThreadsContinued")) : null;
        }

        public ResponseBody setAllThreadsContinued(Boolean allThreadsContinued) {
            this.jsonData.putOpt("allThreadsContinued", (Object)allThreadsContinued);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            return Objects.equals(this.getAllThreadsContinued(), other.getAllThreadsContinued());
        }

        public int hashCode() {
            int hash = 5;
            if (this.getAllThreadsContinued() != null) {
                hash = 29 * hash + Boolean.hashCode(this.getAllThreadsContinued());
            }
            return hash;
        }

        public static ResponseBody create() {
            JSONObject json = new JSONObject();
            return new ResponseBody(json);
        }
    }
}

