/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.DisassembledInstruction;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public class DisassembleResponse
extends Response {
    DisassembleResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return this.jsonData.has("body") ? new ResponseBody(this.jsonData.optJSONObject("body")) : null;
    }

    public DisassembleResponse setBody(ResponseBody body) {
        this.jsonData.putOpt("body", (Object)(body != null ? body.jsonData : null));
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DisassembleResponse other = (DisassembleResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        if (this.getBody() != null) {
            hash = 29 * hash + Objects.hashCode(this.getBody());
        }
        hash = 29 * hash + Objects.hashCode(this.getType());
        hash = 29 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 29 * hash + Boolean.hashCode(this.isSuccess());
        hash = 29 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 29 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 29 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static DisassembleResponse create(Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"response");
        json.put("request_seq", (Object)requestSeq);
        json.put("success", (Object)success);
        json.put("command", (Object)command);
        json.put("seq", (Object)seq);
        return new DisassembleResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public List<DisassembledInstruction> getInstructions() {
            JSONArray json = this.jsonData.getJSONArray("instructions");
            ArrayList<DisassembledInstruction> list = new ArrayList<DisassembledInstruction>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(new DisassembledInstruction(json.getJSONObject(i)));
            }
            return Collections.unmodifiableList(list);
        }

        public ResponseBody setInstructions(List<DisassembledInstruction> instructions) {
            JSONArray json = new JSONArray();
            for (DisassembledInstruction disassembledInstruction : instructions) {
                json.put((Object)disassembledInstruction.jsonData);
            }
            this.jsonData.put("instructions", (Object)json);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            return Objects.equals(this.getInstructions(), other.getInstructions());
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.getInstructions());
            return hash;
        }

        public static ResponseBody create(List<DisassembledInstruction> instructions) {
            JSONObject json = new JSONObject();
            JSONArray instructionsJsonArr = new JSONArray();
            for (DisassembledInstruction disassembledInstruction : instructions) {
                instructionsJsonArr.put((Object)disassembledInstruction.jsonData);
            }
            json.put("instructions", (Object)instructionsJsonArr);
            return new ResponseBody(json);
        }
    }
}

