/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Source;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class DisassembledInstruction
extends JSONBase {
    DisassembledInstruction(JSONObject jsonData) {
        super(jsonData);
    }

    public String getAddress() {
        return this.jsonData.getString("address");
    }

    public DisassembledInstruction setAddress(String address) {
        this.jsonData.put("address", (Object)address);
        return this;
    }

    public String getInstructionBytes() {
        return this.jsonData.optString("instructionBytes", null);
    }

    public DisassembledInstruction setInstructionBytes(String instructionBytes) {
        this.jsonData.putOpt("instructionBytes", (Object)instructionBytes);
        return this;
    }

    public String getInstruction() {
        return this.jsonData.getString("instruction");
    }

    public DisassembledInstruction setInstruction(String instruction) {
        this.jsonData.put("instruction", (Object)instruction);
        return this;
    }

    public String getSymbol() {
        return this.jsonData.optString("symbol", null);
    }

    public DisassembledInstruction setSymbol(String symbol) {
        this.jsonData.putOpt("symbol", (Object)symbol);
        return this;
    }

    public Source getLocation() {
        return this.jsonData.has("location") ? new Source(this.jsonData.optJSONObject("location")) : null;
    }

    public DisassembledInstruction setLocation(Source location) {
        this.jsonData.putOpt("location", (Object)(location != null ? location.jsonData : null));
        return this;
    }

    public Integer getLine() {
        return this.jsonData.has("line") ? Integer.valueOf(this.jsonData.getInt("line")) : null;
    }

    public DisassembledInstruction setLine(Integer line) {
        this.jsonData.putOpt("line", (Object)line);
        return this;
    }

    public Integer getColumn() {
        return this.jsonData.has("column") ? Integer.valueOf(this.jsonData.getInt("column")) : null;
    }

    public DisassembledInstruction setColumn(Integer column) {
        this.jsonData.putOpt("column", (Object)column);
        return this;
    }

    public Integer getEndLine() {
        return this.jsonData.has("endLine") ? Integer.valueOf(this.jsonData.getInt("endLine")) : null;
    }

    public DisassembledInstruction setEndLine(Integer endLine) {
        this.jsonData.putOpt("endLine", (Object)endLine);
        return this;
    }

    public Integer getEndColumn() {
        return this.jsonData.has("endColumn") ? Integer.valueOf(this.jsonData.getInt("endColumn")) : null;
    }

    public DisassembledInstruction setEndColumn(Integer endColumn) {
        this.jsonData.putOpt("endColumn", (Object)endColumn);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DisassembledInstruction other = (DisassembledInstruction)obj;
        if (!Objects.equals(this.getAddress(), other.getAddress())) {
            return false;
        }
        if (!Objects.equals(this.getInstructionBytes(), other.getInstructionBytes())) {
            return false;
        }
        if (!Objects.equals(this.getInstruction(), other.getInstruction())) {
            return false;
        }
        if (!Objects.equals(this.getSymbol(), other.getSymbol())) {
            return false;
        }
        if (!Objects.equals(this.getLocation(), other.getLocation())) {
            return false;
        }
        if (!Objects.equals(this.getLine(), other.getLine())) {
            return false;
        }
        if (!Objects.equals(this.getColumn(), other.getColumn())) {
            return false;
        }
        if (!Objects.equals(this.getEndLine(), other.getEndLine())) {
            return false;
        }
        return Objects.equals(this.getEndColumn(), other.getEndColumn());
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + Objects.hashCode(this.getAddress());
        if (this.getInstructionBytes() != null) {
            hash = 83 * hash + Objects.hashCode(this.getInstructionBytes());
        }
        hash = 83 * hash + Objects.hashCode(this.getInstruction());
        if (this.getSymbol() != null) {
            hash = 83 * hash + Objects.hashCode(this.getSymbol());
        }
        if (this.getLocation() != null) {
            hash = 83 * hash + Objects.hashCode(this.getLocation());
        }
        if (this.getLine() != null) {
            hash = 83 * hash + Integer.hashCode(this.getLine());
        }
        if (this.getColumn() != null) {
            hash = 83 * hash + Integer.hashCode(this.getColumn());
        }
        if (this.getEndLine() != null) {
            hash = 83 * hash + Integer.hashCode(this.getEndLine());
        }
        if (this.getEndColumn() != null) {
            hash = 83 * hash + Integer.hashCode(this.getEndColumn());
        }
        return hash;
    }

    public static DisassembledInstruction create(String address, String instruction) {
        JSONObject json = new JSONObject();
        json.put("address", (Object)address);
        json.put("instruction", (Object)instruction);
        return new DisassembledInstruction(json);
    }
}

