/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Event;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Source;
import java.util.Objects;
import org.graalvm.shadowed.org.json.JSONObject;

public class OutputEvent
extends Event {
    OutputEvent(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public EventBody getBody() {
        return new EventBody(this.jsonData.getJSONObject("body"));
    }

    public OutputEvent setBody(EventBody body) {
        this.jsonData.put("body", (Object)body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutputEvent other = (OutputEvent)obj;
        if (!Objects.equals(this.getEvent(), other.getEvent())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + Objects.hashCode(this.getEvent());
        hash = 83 * hash + Objects.hashCode(this.getBody());
        hash = 83 * hash + Objects.hashCode(this.getType());
        hash = 83 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static OutputEvent create(EventBody body, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("event", (Object)"output");
        json.put("body", (Object)body.jsonData);
        json.put("type", (Object)"event");
        json.put("seq", (Object)seq);
        return new OutputEvent(json);
    }

    public static class EventBody
    extends JSONBase {
        EventBody(JSONObject jsonData) {
            super(jsonData);
        }

        public String getCategory() {
            return this.jsonData.optString("category", null);
        }

        public EventBody setCategory(String category) {
            this.jsonData.putOpt("category", (Object)category);
            return this;
        }

        public String getOutput() {
            return this.jsonData.getString("output");
        }

        public EventBody setOutput(String output) {
            this.jsonData.put("output", (Object)output);
            return this;
        }

        public String getGroup() {
            return this.jsonData.optString("group", null);
        }

        public EventBody setGroup(String group) {
            this.jsonData.putOpt("group", (Object)group);
            return this;
        }

        public Integer getVariablesReference() {
            return this.jsonData.has("variablesReference") ? Integer.valueOf(this.jsonData.getInt("variablesReference")) : null;
        }

        public EventBody setVariablesReference(Integer variablesReference) {
            this.jsonData.putOpt("variablesReference", (Object)variablesReference);
            return this;
        }

        public Source getSource() {
            return this.jsonData.has("source") ? new Source(this.jsonData.optJSONObject("source")) : null;
        }

        public EventBody setSource(Source source) {
            this.jsonData.putOpt("source", (Object)(source != null ? source.jsonData : null));
            return this;
        }

        public Integer getLine() {
            return this.jsonData.has("line") ? Integer.valueOf(this.jsonData.getInt("line")) : null;
        }

        public EventBody setLine(Integer line) {
            this.jsonData.putOpt("line", (Object)line);
            return this;
        }

        public Integer getColumn() {
            return this.jsonData.has("column") ? Integer.valueOf(this.jsonData.getInt("column")) : null;
        }

        public EventBody setColumn(Integer column) {
            this.jsonData.putOpt("column", (Object)column);
            return this;
        }

        public Object getData() {
            return this.jsonData.opt("data");
        }

        public EventBody setData(Object data) {
            this.jsonData.putOpt("data", data);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventBody other = (EventBody)obj;
            if (!Objects.equals(this.getCategory(), other.getCategory())) {
                return false;
            }
            if (!Objects.equals(this.getOutput(), other.getOutput())) {
                return false;
            }
            if (!Objects.equals(this.getGroup(), other.getGroup())) {
                return false;
            }
            if (!Objects.equals(this.getVariablesReference(), other.getVariablesReference())) {
                return false;
            }
            if (!Objects.equals(this.getSource(), other.getSource())) {
                return false;
            }
            if (!Objects.equals(this.getLine(), other.getLine())) {
                return false;
            }
            if (!Objects.equals(this.getColumn(), other.getColumn())) {
                return false;
            }
            return Objects.equals(this.getData(), other.getData());
        }

        public int hashCode() {
            int hash = 2;
            if (this.getCategory() != null) {
                hash = 23 * hash + Objects.hashCode(this.getCategory());
            }
            hash = 23 * hash + Objects.hashCode(this.getOutput());
            if (this.getGroup() != null) {
                hash = 23 * hash + Objects.hashCode(this.getGroup());
            }
            if (this.getVariablesReference() != null) {
                hash = 23 * hash + Integer.hashCode(this.getVariablesReference());
            }
            if (this.getSource() != null) {
                hash = 23 * hash + Objects.hashCode(this.getSource());
            }
            if (this.getLine() != null) {
                hash = 23 * hash + Integer.hashCode(this.getLine());
            }
            if (this.getColumn() != null) {
                hash = 23 * hash + Integer.hashCode(this.getColumn());
            }
            if (this.getData() != null) {
                hash = 23 * hash + Objects.hashCode(this.getData());
            }
            return hash;
        }

        public static EventBody create(String output) {
            JSONObject json = new JSONObject();
            json.put("output", (Object)output);
            return new EventBody(json);
        }
    }
}

